/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.carol.jndi.spi.MultiContext;
import org.ow2.jonas.versioning.VersioningService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualJNDILookup
extends MultiContext {
    private static Log logger = LogFactory.getLog(VirtualJNDILookup.class);
    private Hashtable<?, ?> environment;
    private static VersioningService versioningService;

    public VirtualJNDILookup(Hashtable<?, ?> env) throws NamingException {
        super(env);
        this.environment = env;
    }

    public Object lookup(String name) throws NamingException {
        String prefix = this.getPrefix();
        if (prefix != null) {
            try {
                return super.lookup(prefix + name);
            }
            catch (NamingException ignored) {
                try {
                    return super.lookup(name);
                }
                catch (NamingException ne) {
                    if (name.startsWith(prefix)) {
                        return super.lookup(name.substring(prefix.length()));
                    }
                    throw ne;
                }
            }
        }
        return super.lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        String prefix = this.getPrefix();
        if (prefix != null) {
            try {
                return super.lookupLink(prefix + name);
            }
            catch (NamingException ignored) {
                try {
                    return super.lookupLink(name);
                }
                catch (NamingException ne) {
                    if (name.startsWith(prefix)) {
                        return super.lookupLink(name.substring(prefix.length()));
                    }
                    throw ne;
                }
            }
        }
        return super.lookupLink(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    protected String getPrefix() {
        String prefix;
        try {
            prefix = (String)new MultiContext(this.environment).lookup("java:comp/env/JNDILookupPrefix");
        }
        catch (NamingException e) {
            prefix = null;
        }
        if (prefix != null) {
            return prefix;
        }
        return null;
    }

    public static void setVersioningService(VersioningService versioningService) {
        VirtualJNDILookup.versioningService = versioningService;
    }

    public static void unsetVersioningService() {
        versioningService = null;
    }

    public static VersioningService getVersioningService() {
        return versioningService;
    }
}

