/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.service.manager;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.lib.management.javaee.J2EEServiceState;
import org.ow2.jonas.lib.service.manager.ServiceItem;
import org.ow2.jonas.lib.service.manager.ServiceTracker;
import org.ow2.jonas.lib.service.manager.ServiceUtil;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerImpl
implements ServiceManager,
Pojo {
    private InstanceManager _cm;
    private boolean _Flogger;
    private Log logger;
    private boolean _FservicesState;
    private Map<String, ServiceItem> servicesState;
    private boolean _Fbc;
    private BundleContext bc;
    private boolean _FconfigurationManager;
    private ConfigurationManager configurationManager;
    private boolean _Fj2eeServer;
    private J2EEServerService j2eeServer;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext;
    private boolean _Mstart;
    private boolean _MaddServiceorg_ow2_jonas_lib_service_manager_ServiceItem;
    private boolean _MsetMandatoryServicejava_lang_String;
    private boolean _MdeleteAllServices;
    private boolean _MgetServices;
    private boolean _MsetServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState;
    private boolean _MgetServiceStatejava_lang_String;
    private boolean _MgetServiceDescriptionjava_lang_String;
    private boolean _MallServicesRunning;
    private boolean _MallServicesStopped;
    private boolean _McheckServerStatejava_lang_String;
    private boolean _MstartMonitoring;
    private boolean _MdepMonitorRunning;
    private boolean _MdepMonitorReference;
    private boolean _Mupdate;
    private boolean _MstartServicejava_lang_String;
    private boolean _MstopServicejava_lang_String;
    private boolean _McreateServiceItemjava_lang_Stringboolean;
    private boolean _MbindJ2EEServerorg_ow2_jonas_management_J2EEServerService;
    private boolean _MunbindJ2EEServerorg_ow2_jonas_management_J2EEServerService;
    private boolean _MsetConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager;

    private Log _getlogger() {
        if (!this._Flogger) {
            return this.logger;
        }
        return (Log)this._cm.getterCallback("logger");
    }

    private void _setlogger(Log log) {
        if (!this._Flogger) {
            this.logger = log;
            return;
        }
        this._cm.setterCallback("logger", (Object)log);
    }

    private Map _getservicesState() {
        if (!this._FservicesState) {
            return this.servicesState;
        }
        return (Map)this._cm.getterCallback("servicesState");
    }

    private void _setservicesState(Map map) {
        if (!this._FservicesState) {
            this.servicesState = map;
            return;
        }
        this._cm.setterCallback("servicesState", (Object)map);
    }

    private BundleContext _getbc() {
        if (!this._Fbc) {
            return this.bc;
        }
        return (BundleContext)this._cm.getterCallback("bc");
    }

    private void _setbc(BundleContext bundleContext) {
        if (!this._Fbc) {
            this.bc = bundleContext;
            return;
        }
        this._cm.setterCallback("bc", (Object)bundleContext);
    }

    private ConfigurationManager _getconfigurationManager() {
        if (!this._FconfigurationManager) {
            return this.configurationManager;
        }
        return (ConfigurationManager)this._cm.getterCallback("configurationManager");
    }

    private void _setconfigurationManager(ConfigurationManager configurationManager) {
        if (!this._FconfigurationManager) {
            this.configurationManager = configurationManager;
            return;
        }
        this._cm.setterCallback("configurationManager", (Object)configurationManager);
    }

    private J2EEServerService _getj2eeServer() {
        if (!this._Fj2eeServer) {
            return this.j2eeServer;
        }
        return (J2EEServerService)this._cm.getterCallback("j2eeServer");
    }

    private void _setj2eeServer(J2EEServerService j2EEServerService) {
        if (!this._Fj2eeServer) {
            this.j2eeServer = j2EEServerService;
            return;
        }
        this._cm.setterCallback("j2eeServer", (Object)j2EEServerService);
    }

    public ServiceManagerImpl(InstanceManager _manager, BundleContext bc) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext");
        }
        this._setlogger(LogFactory.getLog(J2EEServerService.class));
        this._setservicesState(null);
        this._setconfigurationManager(null);
        this._setbc(bc);
        this._setservicesState(new Hashtable());
        Object var4_3 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext", var4_3);
        }
    }

    public void start() {
        if (this._Mstart) {
            this._cm.entryCallback("start");
        }
        try {
            this.update();
        }
        catch (Exception e) {
            this._getlogger().error((Object)"Cannot initialize the service states", new Object[0]);
        }
        ServiceTracker listener = new ServiceTracker(this);
        this._getbc().addServiceListener((ServiceListener)listener);
        Object var2_3 = null;
        if (this._Mstart) {
            this._cm.exitCallback("start", var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addService(ServiceItem serviceItem) {
        void serviceItem2;
        if (this._MaddServiceorg_ow2_jonas_lib_service_manager_ServiceItem) {
            this._cm.entryCallback("addServiceorg_ow2_jonas_lib_service_manager_ServiceItem");
        }
        this._getservicesState().put(serviceItem2.getName(), serviceItem2);
        Object var2_2 = null;
        if (this._MaddServiceorg_ow2_jonas_lib_service_manager_ServiceItem) {
            this._cm.exitCallback("addServiceorg_ow2_jonas_lib_service_manager_ServiceItem", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMandatoryService(String string) {
        void serviceName;
        ServiceItem serviceItem;
        if (this._MsetMandatoryServicejava_lang_String) {
            this._cm.entryCallback("setMandatoryServicejava_lang_String");
        }
        if ((serviceItem = (ServiceItem)this._getservicesState().get(serviceName)) != null) {
            serviceItem.setMandatory(true);
        }
        Object var3_3 = null;
        if (this._MsetMandatoryServicejava_lang_String) {
            this._cm.exitCallback("setMandatoryServicejava_lang_String", var3_3);
        }
    }

    public void deleteAllServices() {
        if (this._MdeleteAllServices) {
            this._cm.entryCallback("deleteAllServices");
        }
        this._getservicesState().clear();
        Object var1_1 = null;
        if (this._MdeleteAllServices) {
            this._cm.exitCallback("deleteAllServices", var1_1);
        }
    }

    public List<String> getServices() {
        if (this._MgetServices) {
            this._cm.entryCallback("getServices");
        }
        ArrayList<String> sl = new ArrayList<String>();
        for (ServiceItem serviceItem : this._getservicesState().values()) {
            sl.add(serviceItem.getName());
        }
        ArrayList<String> arrayList = sl;
        if (this._MgetServices) {
            this._cm.exitCallback("getServices", arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public J2EEServiceState setServiceState(String string, J2EEServiceState j2EEServiceState) {
        void state;
        void serviceName;
        if (this._MsetServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState) {
            this._cm.entryCallback("setServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState");
        }
        if (this._getservicesState() == null) {
            this._getlogger().error((Object)"setServiceState called but servicesState table null", new Object[0]);
            J2EEServiceState j2EEServiceState2 = null;
            if (this._MsetServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState) {
                this._cm.exitCallback("setServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState", j2EEServiceState2);
            }
            return j2EEServiceState2;
        }
        ServiceItem serviceItem = (ServiceItem)this._getservicesState().get(serviceName);
        if (serviceItem == null) {
            this._getlogger().error((Object)("setServiceState called but service " + (String)serviceName + " not known"), new Object[0]);
            J2EEServiceState j2EEServiceState3 = null;
            if (this._MsetServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState) {
                this._cm.exitCallback("setServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState", j2EEServiceState3);
            }
            return j2EEServiceState3;
        }
        J2EEServiceState prevState = serviceItem.getState();
        if (prevState != null && prevState.equals((Object)state)) {
            J2EEServiceState j2EEServiceState4 = prevState;
            if (this._MsetServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState) {
                this._cm.exitCallback("setServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState", (Object)j2EEServiceState4);
            }
            return j2EEServiceState4;
        }
        serviceItem.setState((J2EEServiceState)state);
        if (this._getservicesState().get(serviceName) != null) {
            this.checkServerState((String)serviceName);
        }
        void var8_8 = state;
        if (this._MsetServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState) {
            this._cm.exitCallback("setServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState", (Object)var8_8);
        }
        return var8_8;
    }

    /*
     * WARNING - void declaration
     */
    public String getServiceState(String string) {
        void serviceName;
        ServiceItem serviceItem;
        if (this._MgetServiceStatejava_lang_String) {
            this._cm.entryCallback("getServiceStatejava_lang_String");
        }
        if ((serviceItem = (ServiceItem)this._getservicesState().get(serviceName)) != null) {
            String string2 = serviceItem.getState().toString();
            if (this._MgetServiceStatejava_lang_String) {
                this._cm.exitCallback("getServiceStatejava_lang_String", (Object)string2);
            }
            return string2;
        }
        this._getlogger().error((Object)("getServiceState called but service " + (String)serviceName + " not known"), new Object[0]);
        String string3 = null;
        if (this._MgetServiceStatejava_lang_String) {
            this._cm.exitCallback("getServiceStatejava_lang_String", string3);
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    public String getServiceDescription(String string) {
        void serviceName;
        ServiceItem serviceItem;
        if (this._MgetServiceDescriptionjava_lang_String) {
            this._cm.entryCallback("getServiceDescriptionjava_lang_String");
        }
        if ((serviceItem = (ServiceItem)this._getservicesState().get(serviceName)) != null) {
            String string2 = serviceItem.getDescription();
            if (this._MgetServiceDescriptionjava_lang_String) {
                this._cm.exitCallback("getServiceDescriptionjava_lang_String", (Object)string2);
            }
            return string2;
        }
        this._getlogger().error((Object)("getServiceDescription called but service " + (String)serviceName + " not known"), new Object[0]);
        String string3 = null;
        if (this._MgetServiceDescriptionjava_lang_String) {
            this._cm.exitCallback("getServiceDescriptionjava_lang_String", string3);
        }
        return string3;
    }

    private boolean allServicesRunning() {
        if (this._MallServicesRunning) {
            this._cm.entryCallback("allServicesRunning");
        }
        boolean servicesRunning = true;
        for (ServiceItem serviceItem : this._getservicesState().values()) {
            J2EEServiceState state = serviceItem.getState();
            if (state.equals((Object)J2EEServiceState.RUNNING)) continue;
            servicesRunning = false;
            break;
        }
        Boolean bl = new Boolean(servicesRunning);
        if (this._MallServicesRunning) {
            this._cm.exitCallback("allServicesRunning", (Object)bl);
        }
        return bl;
    }

    private boolean allServicesStopped() {
        if (this._MallServicesStopped) {
            this._cm.entryCallback("allServicesStopped");
        }
        boolean servicesStopped = true;
        for (ServiceItem serviceItem : this._getservicesState().values()) {
            J2EEServiceState state = serviceItem.getState();
            if (state.equals((Object)J2EEServiceState.STOPPED) || serviceItem.isMandatory()) continue;
            servicesStopped = false;
            break;
        }
        Boolean bl = new Boolean(servicesStopped);
        if (this._MallServicesStopped) {
            this._cm.exitCallback("allServicesStopped", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkServerState(String string) {
        if (this._McheckServerStatejava_lang_String) {
            this._cm.entryCallback("checkServerStatejava_lang_String");
        }
        if (this._getj2eeServer() != null) {
            void serviceName;
            if (this._getj2eeServer().isStarting() && this.allServicesRunning() && !this.startMonitoring()) {
                this._getj2eeServer().setRunning();
            }
            if (this._getj2eeServer().isRunning() && "depmonitor".equals(serviceName) && this.depMonitorRunning()) {
                this.startMonitoring();
            }
            if ((this._getj2eeServer().isRunning() || this._getj2eeServer().isStopping()) && this.allServicesStopped()) {
                this._getj2eeServer().setStopped();
            }
        }
        Object var2_2 = null;
        if (this._McheckServerStatejava_lang_String) {
            this._cm.exitCallback("checkServerStatejava_lang_String", var2_2);
        }
    }

    private boolean startMonitoring() {
        ServiceReference reference;
        if (this._MstartMonitoring) {
            this._cm.entryCallback("startMonitoring");
        }
        if ((reference = this.depMonitorReference()) != null) {
            MonitoringService monitoringService = (MonitoringService)this._getbc().getService(reference);
            monitoringService.startMonitoring();
            Boolean bl = new Boolean(true);
            if (this._MstartMonitoring) {
                this._cm.exitCallback("startMonitoring", (Object)bl);
            }
            return bl;
        }
        Boolean bl = new Boolean(false);
        if (this._MstartMonitoring) {
            this._cm.exitCallback("startMonitoring", (Object)bl);
        }
        return bl;
    }

    private boolean depMonitorRunning() {
        if (this._MdepMonitorRunning) {
            this._cm.entryCallback("depMonitorRunning");
        }
        if (this.depMonitorReference() != null) {
            Boolean bl = new Boolean(true);
            if (this._MdepMonitorRunning) {
                this._cm.exitCallback("depMonitorRunning", (Object)bl);
            }
            return bl;
        }
        Boolean bl = new Boolean(false);
        if (this._MdepMonitorRunning) {
            this._cm.exitCallback("depMonitorRunning", (Object)bl);
        }
        return bl;
    }

    private ServiceReference depMonitorReference() {
        if (this._MdepMonitorReference) {
            this._cm.entryCallback("depMonitorReference");
        }
        ServiceReference serviceReference = this._getbc().getServiceReference(MonitoringService.class.getName());
        if (this._MdepMonitorReference) {
            this._cm.exitCallback("depMonitorReference", (Object)serviceReference);
        }
        return serviceReference;
    }

    public synchronized void update() throws Exception {
        if (this._Mupdate) {
            this._cm.entryCallback("update");
        }
        this.deleteAllServices();
        for (String service : this._getconfigurationManager().getMandatoryServices()) {
            this.addService(this.createServiceItem(service, Boolean.TRUE));
        }
        for (String service : this._getconfigurationManager().getOptionalServices()) {
            this.addService(this.createServiceItem(service, Boolean.FALSE));
        }
        List<String> runningServices = ServiceUtil.runningServices(this._getbc());
        for (String service : runningServices) {
            this.setServiceState(service, J2EEServiceState.RUNNING);
        }
        Object var4_4 = null;
        if (this._Mupdate) {
            this._cm.exitCallback("update", var4_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void startService(String string) {
        void service;
        if (this._MstartServicejava_lang_String) {
            this._cm.entryCallback("startServicejava_lang_String");
        }
        if (this._getservicesState().get(service) == null || ((ServiceItem)this._getservicesState().get(service)).getState() != J2EEServiceState.RUNNING) {
            try {
                this.addService(this.createServiceItem((String)service, false));
                this._getconfigurationManager().updateServiceConfiguration((String)service);
            }
            catch (Exception e) {
                this._getlogger().error((Object)"Cannot create configuration for the ''{0 }}' service", new Object[]{service});
            }
        } else {
            this._getlogger().debug((Object)"Service ''{0 }}' is already running", new Object[]{service});
        }
        Object var3_3 = null;
        if (this._MstartServicejava_lang_String) {
            this._cm.exitCallback("startServicejava_lang_String", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void stopService(String string) {
        void service;
        if (this._MstopServicejava_lang_String) {
            this._cm.entryCallback("stopServicejava_lang_String");
        }
        if (this._getservicesState().get(service) != null && ((ServiceItem)this._getservicesState().get(service)).getState() == J2EEServiceState.RUNNING) {
            try {
                this._getconfigurationManager().deleteServiceConfiguration((String)service);
            }
            catch (Exception e) {
                this._getlogger().error((Object)"Cannot delete configuration for the ''{0 }}' service", new Object[]{service});
            }
        } else {
            this._getlogger().debug((Object)"Service ''0}'' is not running", new Object[]{service});
        }
        Object var3_3 = null;
        if (this._MstopServicejava_lang_String) {
            this._cm.exitCallback("stopServicejava_lang_String", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ServiceItem createServiceItem(String string, boolean bl) {
        void mandatory;
        void service;
        if (this._McreateServiceItemjava_lang_Stringboolean) {
            this._cm.entryCallback("createServiceItemjava_lang_Stringboolean");
        }
        ServiceItem serviceItem = new ServiceItem();
        serviceItem.setName((String)service);
        serviceItem.setDescription((String)service + " description ...");
        serviceItem.setState(J2EEServiceState.STOPPED);
        serviceItem.setMandatory((boolean)mandatory);
        ServiceItem serviceItem2 = serviceItem;
        if (this._McreateServiceItemjava_lang_Stringboolean) {
            this._cm.exitCallback("createServiceItemjava_lang_Stringboolean", (Object)serviceItem2);
        }
        return serviceItem2;
    }

    /*
     * WARNING - void declaration
     */
    public void bindJ2EEServer(J2EEServerService j2EEServerService) {
        void j2eeServer;
        if (this._MbindJ2EEServerorg_ow2_jonas_management_J2EEServerService) {
            this._cm.entryCallback("bindJ2EEServerorg_ow2_jonas_management_J2EEServerService");
        }
        this._setj2eeServer((J2EEServerService)j2eeServer);
        Object var2_2 = null;
        if (this._MbindJ2EEServerorg_ow2_jonas_management_J2EEServerService) {
            this._cm.exitCallback("bindJ2EEServerorg_ow2_jonas_management_J2EEServerService", var2_2);
        }
    }

    public void unbindJ2EEServer(J2EEServerService j2EEServerService) {
        if (this._MunbindJ2EEServerorg_ow2_jonas_management_J2EEServerService) {
            this._cm.entryCallback("unbindJ2EEServerorg_ow2_jonas_management_J2EEServerService");
        }
        this._setj2eeServer(null);
        Object var2_2 = null;
        if (this._MunbindJ2EEServerorg_ow2_jonas_management_J2EEServerService) {
            this._cm.exitCallback("unbindJ2EEServerorg_ow2_jonas_management_J2EEServerService", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigurationManager(ConfigurationManager configurationManager) {
        void configurationManager2;
        if (this._MsetConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager) {
            this._cm.entryCallback("setConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager");
        }
        this._setconfigurationManager((ConfigurationManager)configurationManager2);
        Object var2_2 = null;
        if (this._MsetConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager) {
            this._cm.exitCallback("setConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager", var2_2);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("bc")) {
                this._Fbc = true;
            }
            if (set.contains("j2eeServer")) {
                this._Fj2eeServer = true;
            }
            if (set.contains("servicesState")) {
                this._FservicesState = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("configurationManager")) {
                this._FconfigurationManager = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext")) {
                this._M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext = true;
            }
            if (set.contains("start")) {
                this._Mstart = true;
            }
            if (set.contains("addServiceorg_ow2_jonas_lib_service_manager_ServiceItem")) {
                this._MaddServiceorg_ow2_jonas_lib_service_manager_ServiceItem = true;
            }
            if (set.contains("setMandatoryServicejava_lang_String")) {
                this._MsetMandatoryServicejava_lang_String = true;
            }
            if (set.contains("deleteAllServices")) {
                this._MdeleteAllServices = true;
            }
            if (set.contains("getServices")) {
                this._MgetServices = true;
            }
            if (set.contains("setServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState")) {
                this._MsetServiceStatejava_lang_Stringorg_ow2_jonas_lib_management_javaee_J2EEServiceState = true;
            }
            if (set.contains("getServiceStatejava_lang_String")) {
                this._MgetServiceStatejava_lang_String = true;
            }
            if (set.contains("getServiceDescriptionjava_lang_String")) {
                this._MgetServiceDescriptionjava_lang_String = true;
            }
            if (set.contains("allServicesRunning")) {
                this._MallServicesRunning = true;
            }
            if (set.contains("allServicesStopped")) {
                this._MallServicesStopped = true;
            }
            if (set.contains("checkServerStatejava_lang_String")) {
                this._McheckServerStatejava_lang_String = true;
            }
            if (set.contains("startMonitoring")) {
                this._MstartMonitoring = true;
            }
            if (set.contains("depMonitorRunning")) {
                this._MdepMonitorRunning = true;
            }
            if (set.contains("depMonitorReference")) {
                this._MdepMonitorReference = true;
            }
            if (set.contains("update")) {
                this._Mupdate = true;
            }
            if (set.contains("startServicejava_lang_String")) {
                this._MstartServicejava_lang_String = true;
            }
            if (set.contains("stopServicejava_lang_String")) {
                this._MstopServicejava_lang_String = true;
            }
            if (set.contains("createServiceItemjava_lang_Stringboolean")) {
                this._McreateServiceItemjava_lang_Stringboolean = true;
            }
            if (set.contains("bindJ2EEServerorg_ow2_jonas_management_J2EEServerService")) {
                this._MbindJ2EEServerorg_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("unbindJ2EEServerorg_ow2_jonas_management_J2EEServerService")) {
                this._MunbindJ2EEServerorg_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("setConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager")) {
                this._MsetConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

