/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.iiop;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.ow2.carol.util.csiv2.gss.GSSHelper;
import org.ow2.jonas.security.iiop.Csiv2Const;
import org.ow2.jonas.security.iiop.Csiv2InterceptorException;
import org.ow2.jonas.security.iiop.ORBHelper;
import org.ow2.jonas.security.iiop.SecurityContextHelper;

public class Csiv2ClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final String NAME = "Csiv2ClientInterceptor";
    private Codec codec = null;
    private Logger logger = null;
    private Logger loggerDetails = null;

    public Csiv2ClientInterceptor(Codec codec, Logger logger, Logger loggerDetails) {
        this.codec = codec;
        this.logger = logger;
        this.loggerDetails = loggerDetails;
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        TaggedComponent taggedComponent = null;
        try {
            taggedComponent = ri.get_effective_component(33);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"There is a TAG_CSI_SEC_MECH_LIST tagged component");
            }
        }
        catch (BAD_PARAM e) {
            if (this.loggerDetails.isLoggable(BasicLevel.DEBUG)) {
                this.loggerDetails.log(BasicLevel.DEBUG, (Object)"No tagged component with id 33");
            }
            return;
        }
        if (taggedComponent == null) {
            return;
        }
        Any pAny = null;
        try {
            pAny = this.codec.decode_value(taggedComponent.component_data, CompoundSecMechListHelper.type());
        }
        catch (FormatMismatch fm) {
            this.logger.log(BasicLevel.ERROR, (Object)("Format mismatch while decoding value :" + fm.getMessage()));
            return;
        }
        catch (TypeMismatch tm) {
            this.logger.log(BasicLevel.ERROR, (Object)("Type mismatch while decoding value :" + tm.getMessage()));
            return;
        }
        CompoundSecMechList compoundSecMechList = CompoundSecMechListHelper.extract((Any)pAny);
        CompoundSecMech compoundSecMech = null;
        if (compoundSecMechList.mechanism_list.length <= 0) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"No coumpound sec mech in the list.");
            }
            return;
        }
        compoundSecMech = compoundSecMechList.mechanism_list[0];
        long clientContextId = 0L;
        AuthorizationElement[] withoutAuthorizationToken = new AuthorizationElement[]{};
        IdentityToken identityToken = null;
        IdentityToken anonymousIdentityToken = new IdentityToken();
        anonymousIdentityToken.anonymous(true);
        IdentityToken absentIdentityToken = new IdentityToken();
        absentIdentityToken.absent(true);
        byte[] clientAuthenticationToken = Csiv2Const.EMPTY_BYTES;
        if ((compoundSecMech.as_context_mech.target_requires & 0x40) == 64) {
            pAny = null;
            try {
                pAny = ORBHelper.getOrb().create_any();
            }
            catch (Csiv2InterceptorException csie) {
                this.logger.log(BasicLevel.ERROR, (Object)("Cannot get orb for any = " + csie.getMessage()));
                return;
            }
            InitialContextToken initialContextToken = null;
            try {
                initialContextToken = SecurityContextHelper.getInstance().getInitialContextToken();
            }
            catch (UnsupportedEncodingException uee) {
                this.logger.log(BasicLevel.ERROR, (Object)("Unsupported encoding for UTF8" + uee.getMessage()));
                return;
            }
            InitialContextTokenHelper.insert((Any)pAny, (InitialContextToken)initialContextToken);
            byte[] contextData = null;
            try {
                contextData = this.codec.encode_value(pAny);
            }
            catch (InvalidTypeForEncoding itfe) {
                this.logger.log(BasicLevel.ERROR, (Object)("Cannot encode a given any corba object : " + itfe.getMessage()));
                return;
            }
            try {
                clientAuthenticationToken = GSSHelper.encodeToken((byte[])contextData);
            }
            catch (IOException ioe) {
                this.logger.log(BasicLevel.ERROR, (Object)("Cannot encode client authentication token : " + ioe.getMessage()));
                return;
            }
        }
        if ((compoundSecMech.sas_context_mech.target_supports & 0x400) == 1024) {
            pAny = null;
            try {
                pAny = ORBHelper.getOrb().create_any();
            }
            catch (Csiv2InterceptorException csie) {
                this.logger.log(BasicLevel.ERROR, (Object)("Cannot get orb for any = " + csie.getMessage()));
                return;
            }
            String identity = SecurityContextHelper.getInstance().getIdentityToken();
            byte[] name = GSSHelper.encodeExported((String)identity);
            byte[] principalName = null;
            GSS_NT_ExportedNameHelper.insert((Any)pAny, (byte[])name);
            try {
                principalName = this.codec.encode_value(pAny);
            }
            catch (InvalidTypeForEncoding itfe) {
                this.logger.log(BasicLevel.ERROR, (Object)("Cannot encode a given any corba object : " + itfe.getMessage()));
                return;
            }
            identityToken = new IdentityToken();
            identityToken.principal_name(principalName);
        }
        if (identityToken == null) {
            identityToken = absentIdentityToken;
        }
        if (identityToken == absentIdentityToken && clientAuthenticationToken == Csiv2Const.EMPTY_BYTES) {
            return;
        }
        EstablishContext establishContext = new EstablishContext(clientContextId, withoutAuthorizationToken, identityToken, clientAuthenticationToken);
        try {
            pAny = ORBHelper.getOrb().create_any();
        }
        catch (Csiv2InterceptorException csie) {
            this.logger.log(BasicLevel.ERROR, (Object)("Cannot get orb for any = " + csie.getMessage()));
            return;
        }
        SASContextBody sasContextBody = new SASContextBody();
        sasContextBody.establish_msg(establishContext);
        SASContextBodyHelper.insert((Any)pAny, (SASContextBody)sasContextBody);
        byte[] contextData = null;
        try {
            contextData = this.codec.encode_value(pAny);
        }
        catch (InvalidTypeForEncoding itfe) {
            this.logger.log(BasicLevel.ERROR, (Object)("Cannot encode a given any corba object : " + itfe.getMessage()));
            return;
        }
        ServiceContext serviceContext = new ServiceContext(15, contextData);
        ri.add_request_service_context(serviceContext, true);
    }

    public void destroy() {
    }

    public String name() {
        return NAME;
    }
}

