/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.PropDump;
import org.ow2.jonas.mail.MailService;
import org.ow2.jonas.mail.MailServiceException;
import org.ow2.jonas.mail.factory.JavaMail;
import org.ow2.jonas.mail.internal.factory.AbstractJavaMail;
import org.ow2.jonas.mail.internal.factory.JavaMailMimePartDS;
import org.ow2.jonas.mail.internal.factory.JavaMailSession;
import org.ow2.jonas.mail.internal.factory.mbean.JavaMailMimePartDSResource;
import org.ow2.jonas.mail.internal.factory.mbean.JavaMailSessionResource;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASMailService
extends AbsServiceImpl
implements MailService,
Pojo {
    private InstanceManager _cm;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.mail");
    private boolean _FjmxService;
    private JmxService jmxService;
    private boolean _Fictx;
    private Context ictx;
    private boolean _FregistryService;
    private RegistryService registryService;
    private boolean _FfactoryNames;
    private List<String> factoryNames;
    private boolean _FjMailSessionFactories;
    private Map<String, JavaMailSession> jMailSessionFactories;
    private boolean _FjMailMimePartDSFactories;
    private Map<String, JavaMailMimePartDS> jMailMimePartDSFactories;
    private boolean _FbindedFactories;
    private Map<String, String> bindedFactories;
    private static final int JAVAX_MAIL_SESSION_FACTORY = 1;
    private static final int JAVAX_MAIL_INTERNET_MIMEPARTDATASOURCE = 2;
    public static final String FACTORIES = "jonas.service.mail.factories";
    public static final String CLASS = "jonas.service.mail.class";
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MsetFactoriesjava_lang_String;
    private boolean _MdoStart;
    private boolean _MdoStop;
    private boolean _MrecreateJavaMailFactoryorg_ow2_jonas_mail_factory_JavaMail;
    private boolean _MrenameJavaMailFactoryjava_lang_Stringorg_ow2_jonas_mail_factory_JavaMail;
    private boolean _McreateMailFactoryjava_lang_Stringjava_util_Properties;
    private boolean _McreateMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean;
    private boolean _MunbindMailFactories;
    private boolean _MunbindMailFactoryMBeanjava_lang_String;
    private boolean _MgetFactoryNamejava_lang_String;
    private boolean _MgetCurrentNumberOfMailFactories;
    private boolean _MgetCurrentNumberOfSessionMailFactories;
    private boolean _MgetCurrentNumberOfMimeMailFactories;
    private boolean _MgetMailFactoryPropertiesFilejava_lang_String;
    private boolean _MgetMailFactoryPropertiesFiles;
    private boolean _MgetMimePartMailFactoryPropertiesFiles;
    private boolean _MgetSessionMailFactoryPropertiesFiles;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;
    private boolean _MsetRegistryServiceorg_ow2_jonas_registry_RegistryService;
    private boolean _MgetRegistryService;

    private JmxService _getjmxService() {
        if (!this._FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this._cm.getterCallback("jmxService");
    }

    private void _setjmxService(JmxService jmxService) {
        if (!this._FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this._cm.setterCallback("jmxService", (Object)jmxService);
    }

    private Context _getictx() {
        if (!this._Fictx) {
            return this.ictx;
        }
        return (Context)this._cm.getterCallback("ictx");
    }

    private void _setictx(Context context) {
        if (!this._Fictx) {
            this.ictx = context;
            return;
        }
        this._cm.setterCallback("ictx", (Object)context);
    }

    private RegistryService _getregistryService() {
        if (!this._FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this._cm.getterCallback("registryService");
    }

    private void _setregistryService(RegistryService registryService) {
        if (!this._FregistryService) {
            this.registryService = registryService;
            return;
        }
        this._cm.setterCallback("registryService", (Object)registryService);
    }

    private List _getfactoryNames() {
        if (!this._FfactoryNames) {
            return this.factoryNames;
        }
        return (List)this._cm.getterCallback("factoryNames");
    }

    private void _setfactoryNames(List list) {
        if (!this._FfactoryNames) {
            this.factoryNames = list;
            return;
        }
        this._cm.setterCallback("factoryNames", (Object)list);
    }

    private Map _getjMailSessionFactories() {
        if (!this._FjMailSessionFactories) {
            return this.jMailSessionFactories;
        }
        return (Map)this._cm.getterCallback("jMailSessionFactories");
    }

    private void _setjMailSessionFactories(Map map) {
        if (!this._FjMailSessionFactories) {
            this.jMailSessionFactories = map;
            return;
        }
        this._cm.setterCallback("jMailSessionFactories", (Object)map);
    }

    private Map _getjMailMimePartDSFactories() {
        if (!this._FjMailMimePartDSFactories) {
            return this.jMailMimePartDSFactories;
        }
        return (Map)this._cm.getterCallback("jMailMimePartDSFactories");
    }

    private void _setjMailMimePartDSFactories(Map map) {
        if (!this._FjMailMimePartDSFactories) {
            this.jMailMimePartDSFactories = map;
            return;
        }
        this._cm.setterCallback("jMailMimePartDSFactories", (Object)map);
    }

    private Map _getbindedFactories() {
        if (!this._FbindedFactories) {
            return this.bindedFactories;
        }
        return (Map)this._cm.getterCallback("bindedFactories");
    }

    private void _setbindedFactories(Map map) {
        if (!this._FbindedFactories) {
            this.bindedFactories = map;
            return;
        }
        this._cm.setterCallback("bindedFactories", (Object)map);
    }

    public JOnASMailService(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setjmxService(null);
        this._setictx(null);
        this._setfactoryNames(new Vector());
        this._setjMailSessionFactories(new Hashtable());
        this._setjMailMimePartDSFactories(new Hashtable());
        this._setbindedFactories(new Hashtable());
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFactories(String string) {
        void factories;
        if (this._MsetFactoriesjava_lang_String) {
            this._cm.entryCallback("setFactoriesjava_lang_String");
        }
        this._setfactoryNames(JOnASMailService.convertToList((String)factories));
        Object var2_2 = null;
        if (this._MsetFactoriesjava_lang_String) {
            this._cm.exitCallback("setFactoriesjava_lang_String", var2_2);
        }
    }

    protected void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        super.initLogger(Log.getLogger((String)"org.ow2.jonas.management"));
        IExecution<InitialContext> ictxGetter = new IExecution<InitialContext>(){

            public InitialContext execute() throws Exception {
                return JOnASMailService.this.getRegistryService().getRegistryContext();
            }
        };
        ExecutionResult ictxResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)ictxGetter);
        if (ictxResult.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when Mail service initializing");
            ServiceException serviceException = new ServiceException("Cannot create initial context when Mail service initializing", (Throwable)ictxResult.getException());
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        this._setictx((Context)ictxResult.getResult());
        if (this._getjmxService() != null) {
            this._getjmxService().loadDescriptors(((Object)((Object)this)).getClass().getPackage().getName(), ((Object)((Object)this)).getClass().getClassLoader());
        }
        String factoryName = null;
        for (int i = 0; i < this._getfactoryNames().size(); ++i) {
            factoryName = (String)this._getfactoryNames().get(i);
            try {
                JProp prop = JProp.getInstance((String)factoryName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Creating mail factory " + factoryName));
                }
                this.createMailFactory(factoryName, prop.getConfigFileEnv());
                continue;
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                logger.log(BasicLevel.ERROR, (Object)("JOnAS: Cannot create mail factory " + factoryName + " : " + e));
                logger.log(BasicLevel.ERROR, (Object)("Please check the " + factoryName + ".properties file"));
            }
        }
        if (this._getjmxService() != null) {
            try {
                this._getjmxService().registerModelMBean((Object)this, JonasObjectName.mailService((String)this.getDomainName()));
            }
            catch (Exception e) {
                logger.log(BasicLevel.INFO, (Object)"Cannot register 'mail' service MBean", (Throwable)e);
            }
        }
        logger.log(BasicLevel.INFO, (Object)"Mail Service started");
        Object var7_9 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var7_9);
        }
    }

    protected void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        try {
            this.unbindMailFactories();
        }
        catch (MailServiceException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot unbind mail factories " + (Object)((Object)e)));
            ServiceException serviceException = new ServiceException("Cannot unbind mail factories ", (Throwable)e);
            if (this._MdoStop) {
                this._cm.exitCallback("doStop", (Object)serviceException);
            }
            throw serviceException;
        }
        if (this._getjmxService() != null) {
            this._getjmxService().unregisterModelMBean(JonasObjectName.mailService((String)this.getDomainName()));
        }
        logger.log(BasicLevel.INFO, (Object)"mail service stopped");
        Object var3_3 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void recreateJavaMailFactory(JavaMail javaMail) throws MailServiceException {
        void factory;
        if (this._MrecreateJavaMailFactoryorg_ow2_jonas_mail_factory_JavaMail) {
            this._cm.entryCallback("recreateJavaMailFactoryorg_ow2_jonas_mail_factory_JavaMail");
        }
        String jndiName = factory.getName();
        try {
            this._getictx().rebind(jndiName, (Object)factory);
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot bind mail factory '" + jndiName + "'  :" + e.getMessage()));
            MailServiceException mailServiceException = new MailServiceException("Cannot bind mail factory " + jndiName + ".", (Throwable)e);
            if (this._MrecreateJavaMailFactoryorg_ow2_jonas_mail_factory_JavaMail) {
                this._cm.exitCallback("recreateJavaMailFactoryorg_ow2_jonas_mail_factory_JavaMail", (Object)mailServiceException);
            }
            throw mailServiceException;
        }
        Object var5_5 = null;
        if (this._MrecreateJavaMailFactoryorg_ow2_jonas_mail_factory_JavaMail) {
            this._cm.exitCallback("recreateJavaMailFactoryorg_ow2_jonas_mail_factory_JavaMail", var5_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void renameJavaMailFactory(String string, JavaMail javaMail) throws MailServiceException {
        void factory;
        void oldName;
        block10: {
            if (this._MrenameJavaMailFactoryjava_lang_Stringorg_ow2_jonas_mail_factory_JavaMail) {
                this._cm.entryCallback("renameJavaMailFactoryjava_lang_Stringorg_ow2_jonas_mail_factory_JavaMail");
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("In renameMailFactory, old name = " + (String)oldName));
            }
            try {
                this._getictx().unbind((String)oldName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)((String)oldName + " unbound"));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block10;
                logger.log(BasicLevel.DEBUG, (Object)("Warning: cannot unbind mail factory object named " + (String)oldName));
            }
        }
        String jndiName = factory.getName();
        try {
            this._getictx().rebind(jndiName, (Object)factory);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("factory rebound under the name " + jndiName));
            }
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot bind mail factory '" + jndiName + "'  :" + e.getMessage()));
            MailServiceException mailServiceException = new MailServiceException("Cannot bind mail factory " + jndiName + ".", (Throwable)e);
            if (this._MrenameJavaMailFactoryjava_lang_Stringorg_ow2_jonas_mail_factory_JavaMail) {
                this._cm.exitCallback("renameJavaMailFactoryjava_lang_Stringorg_ow2_jonas_mail_factory_JavaMail", (Object)mailServiceException);
            }
            throw mailServiceException;
        }
        this._getbindedFactories().put(jndiName, factory.getFactoryName());
        this._getbindedFactories().remove(oldName);
        Object var6_7 = null;
        if (this._MrenameJavaMailFactoryjava_lang_Stringorg_ow2_jonas_mail_factory_JavaMail) {
            this._cm.exitCallback("renameJavaMailFactoryjava_lang_Stringorg_ow2_jonas_mail_factory_JavaMail", var6_7);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createMailFactory(String string, Properties properties) throws MailServiceException {
        void factoryName;
        void props;
        if (this._McreateMailFactoryjava_lang_Stringjava_util_Properties) {
            this._cm.entryCallback("createMailFactoryjava_lang_Stringjava_util_Properties");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            PropDump.print((String)"These are the properties from which the MailService picks to construct Mail Factories", (Properties)props, (Logger)logger, (int)BasicLevel.DEBUG);
        }
        AbstractJavaMail factory = null;
        String factoryType = props.getProperty("mail.factory.type");
        String jndiName = props.getProperty("mail.factory.name");
        if (jndiName == null) {
            logger.log(BasicLevel.ERROR, (Object)"The property 'mail.factory.name' is a required property.");
            MailServiceException mailServiceException = new MailServiceException("The property 'mail.factory.name' is a required property for this factory.");
            if (this._McreateMailFactoryjava_lang_Stringjava_util_Properties) {
                this._cm.exitCallback("createMailFactoryjava_lang_Stringjava_util_Properties", (Object)mailServiceException);
            }
            throw mailServiceException;
        }
        if (factoryType == null) {
            logger.log(BasicLevel.ERROR, (Object)"The property 'mail.factory.type' is a required property.");
            MailServiceException mailServiceException = new MailServiceException("The property 'mail.factory.type' is a required property for this factory.");
            if (this._McreateMailFactoryjava_lang_Stringjava_util_Properties) {
                this._cm.exitCallback("createMailFactoryjava_lang_Stringjava_util_Properties", (Object)mailServiceException);
            }
            throw mailServiceException;
        }
        if (this._getbindedFactories().containsKey(jndiName)) {
            logger.log(BasicLevel.ERROR, (Object)("There is already a factory bound with the name " + jndiName));
            MailServiceException mailServiceException = new MailServiceException("There is already a factory bound with the name '" + jndiName + "', please correct the provided configuration properties");
            if (this._McreateMailFactoryjava_lang_Stringjava_util_Properties) {
                this._cm.exitCallback("createMailFactoryjava_lang_Stringjava_util_Properties", (Object)mailServiceException);
            }
            throw mailServiceException;
        }
        int typeOfFactory = factoryType.equalsIgnoreCase("javax.mail.Session") ? 1 : (factoryType.equalsIgnoreCase("javax.mail.internet.MimePartDataSource") ? 2 : 0);
        switch (typeOfFactory) {
            case 1: {
                JavaMailSession sessionFactory = new JavaMailSession((String)factoryName, jndiName, (Properties)props, this);
                this._getjMailSessionFactories().put(factoryName, sessionFactory);
                factory = sessionFactory;
                break;
            }
            case 2: {
                JavaMailMimePartDS mimeFactory = new JavaMailMimePartDS((String)factoryName, jndiName, (Properties)props, this);
                this._getjMailMimePartDSFactories().put(factoryName, mimeFactory);
                factory = mimeFactory;
                break;
            }
            default: {
                MailServiceException mailServiceException = new MailServiceException("Can not create a factory of the type '" + factoryType + "'. This type is incorrect.");
                if (this._McreateMailFactoryjava_lang_Stringjava_util_Properties) {
                    this._cm.exitCallback("createMailFactoryjava_lang_Stringjava_util_Properties", (Object)mailServiceException);
                }
                throw mailServiceException;
            }
        }
        try {
            this._getictx().rebind(jndiName, (Object)factory);
            this._getbindedFactories().put(jndiName, factoryName);
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot bind mail factory '" + jndiName + "'  :" + e.getMessage()));
            MailServiceException mailServiceException = new MailServiceException("Cannot bind mail factory " + jndiName + ".", (Throwable)e);
            if (this._McreateMailFactoryjava_lang_Stringjava_util_Properties) {
                this._cm.exitCallback("createMailFactoryjava_lang_Stringjava_util_Properties", (Object)mailServiceException);
            }
            throw mailServiceException;
        }
        logger.log(BasicLevel.INFO, (Object)("Mapping Mail Factory " + factoryType + " on " + jndiName));
        try {
            if (this._getjmxService() != null) {
                ObjectName on = null;
                switch (typeOfFactory) {
                    case 1: {
                        on = J2eeObjectName.JavaMailResource((String)this.getDomainName(), (String)factoryName, (String)this.getJonasServerName(), (String)"javax.mail.Session");
                        JavaMailSessionResource javaMailSessionResource = null;
                        javaMailSessionResource = new JavaMailSessionResource(on.toString(), false, false, false, (JavaMailSession)factory);
                        this._getjmxService().registerModelMBean((Object)javaMailSessionResource, on);
                        if (!logger.isLoggable(BasicLevel.DEBUG)) break;
                        logger.log(BasicLevel.DEBUG, (Object)("Register session mail factory with name " + (String)factoryName));
                        break;
                    }
                    case 2: {
                        on = J2eeObjectName.JavaMailResource((String)this.getDomainName(), (String)factoryName, (String)this.getJonasServerName(), (String)"javax.mail.internet.MimePartDataSource");
                        JavaMailMimePartDSResource javaMailMimePartDSResource = null;
                        javaMailMimePartDSResource = new JavaMailMimePartDSResource(on.toString(), false, false, false, (JavaMailMimePartDS)factory);
                        this._getjmxService().registerModelMBean((Object)javaMailMimePartDSResource, on);
                        if (!logger.isLoggable(BasicLevel.DEBUG)) break;
                        logger.log(BasicLevel.DEBUG, (Object)("Register mime mail factory with name " + (String)factoryName));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register JavaMailResource MBean");
        }
        Object var15_17 = null;
        if (this._McreateMailFactoryjava_lang_Stringjava_util_Properties) {
            this._cm.exitCallback("createMailFactoryjava_lang_Stringjava_util_Properties", var15_17);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createMailFactoryMBean(String string, Properties properties, Boolean bl) throws MailServiceException {
        void props;
        void name;
        void loadFromFile;
        boolean fromFile;
        if (this._McreateMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean) {
            this._cm.entryCallback("createMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean");
        }
        if (!(fromFile = loadFromFile.booleanValue())) {
            try {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Call getInstance on JProp in order to create the properties file");
                }
                JProp.getInstance((String)name, (Properties)props);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create mail factory " + (String)name + " as cannot create properties file : " + e.toString()));
                ServiceException serviceException = new ServiceException("MailService: Cannot create mail factory " + (String)name + ",\n" + e.toString());
                if (this._McreateMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean) {
                    this._cm.exitCallback("createMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean", (Object)serviceException);
                }
                throw serviceException;
            }
        }
        try {
            this.createMailFactory((String)name, (Properties)props);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot create mail factory: " + (String)name));
            ServiceException serviceException = new ServiceException("MailService: Cannot create mail factory: " + (String)name + ",\n" + e.toString());
            if (this._McreateMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean) {
                this._cm.exitCallback("createMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean", (Object)serviceException);
            }
            throw serviceException;
        }
        Object var8_9 = null;
        if (this._McreateMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean) {
            this._cm.exitCallback("createMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean", var8_9);
        }
    }

    public void unbindMailFactories() throws MailServiceException {
        String factoryName;
        int i;
        if (this._MunbindMailFactories) {
            this._cm.entryCallback("unbindMailFactories");
        }
        String[] factories = new String[this._getjMailSessionFactories().size()];
        factories = this._getjMailSessionFactories().keySet().toArray(factories);
        for (i = 0; i < factories.length; ++i) {
            factoryName = factories[i];
            this.unbindMailFactoryMBean(factoryName);
        }
        factories = new String[this._getjMailMimePartDSFactories().size()];
        factories = this._getjMailMimePartDSFactories().keySet().toArray(factories);
        for (i = 0; i < factories.length; ++i) {
            factoryName = factories[i];
            this.unbindMailFactoryMBean(factoryName);
        }
        Object var4_4 = null;
        if (this._MunbindMailFactories) {
            this._cm.exitCallback("unbindMailFactories", var4_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unbindMailFactoryMBean(String string) throws MailServiceException {
        int typeOfFactory;
        void factoryName;
        if (this._MunbindMailFactoryMBeanjava_lang_String) {
            this._cm.entryCallback("unbindMailFactoryMBeanjava_lang_String");
        }
        String name = null;
        JavaMailSession jmailSession = (JavaMailSession)this._getjMailSessionFactories().get(factoryName);
        JavaMailMimePartDS jMailMimePartDS = (JavaMailMimePartDS)this._getjMailMimePartDSFactories().get(factoryName);
        if (jmailSession != null) {
            name = jmailSession.getName();
            typeOfFactory = 1;
        } else if (jMailMimePartDS != null) {
            name = jMailMimePartDS.getName();
            typeOfFactory = 2;
        } else {
            MailServiceException mailServiceException = new MailServiceException("Can not unload the mail factory '" + (String)factoryName + "' (this is not a known factory name)");
            if (this._MunbindMailFactoryMBeanjava_lang_String) {
                this._cm.exitCallback("unbindMailFactoryMBeanjava_lang_String", (Object)mailServiceException);
            }
            throw mailServiceException;
        }
        try {
            this._getictx().unbind(name);
            this._getbindedFactories().remove(name);
        }
        catch (NamingException e) {
            MailServiceException mailServiceException = new MailServiceException("Can not unbind the factory '" + name + "'.", (Throwable)e);
            if (this._MunbindMailFactoryMBeanjava_lang_String) {
                this._cm.exitCallback("unbindMailFactoryMBeanjava_lang_String", (Object)mailServiceException);
            }
            throw mailServiceException;
        }
        JProp.removeInstance((String)name);
        if (this._getjmxService() != null) {
            ObjectName on = null;
            switch (typeOfFactory) {
                case 1: {
                    on = J2eeObjectName.JavaMailResource((String)this.getDomainName(), (String)factoryName, (String)this.getJonasServerName(), (String)"javax.mail.Session");
                    this._getjmxService().unregisterModelMBean(on);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Unregister session mail factory with name " + (String)factoryName));
                    }
                    this._getjMailSessionFactories().remove(factoryName);
                    break;
                }
                case 2: {
                    on = J2eeObjectName.JavaMailResource((String)this.getDomainName(), (String)factoryName, (String)this.getJonasServerName(), (String)"javax.mail.internet.MimePartDataSource");
                    this._getjmxService().unregisterModelMBean(on);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Unregister mime mail factory with name " + (String)factoryName));
                    }
                    this._getjMailMimePartDSFactories().remove(factoryName);
                }
            }
        }
        Object var9_10 = null;
        if (this._MunbindMailFactoryMBeanjava_lang_String) {
            this._cm.exitCallback("unbindMailFactoryMBeanjava_lang_String", var9_10);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getFactoryName(String string) {
        void jndiName;
        if (this._MgetFactoryNamejava_lang_String) {
            this._cm.entryCallback("getFactoryNamejava_lang_String");
        }
        String string2 = (String)this._getbindedFactories().get(jndiName);
        if (this._MgetFactoryNamejava_lang_String) {
            this._cm.exitCallback("getFactoryNamejava_lang_String", (Object)string2);
        }
        return string2;
    }

    public Integer getCurrentNumberOfMailFactories() {
        if (this._MgetCurrentNumberOfMailFactories) {
            this._cm.entryCallback("getCurrentNumberOfMailFactories");
        }
        Integer n = this._getjMailSessionFactories().size() + this._getjMailMimePartDSFactories().size();
        if (this._MgetCurrentNumberOfMailFactories) {
            this._cm.exitCallback("getCurrentNumberOfMailFactories", (Object)n);
        }
        return n;
    }

    public Integer getCurrentNumberOfSessionMailFactories() {
        if (this._MgetCurrentNumberOfSessionMailFactories) {
            this._cm.entryCallback("getCurrentNumberOfSessionMailFactories");
        }
        Integer n = this._getjMailSessionFactories().size();
        if (this._MgetCurrentNumberOfSessionMailFactories) {
            this._cm.exitCallback("getCurrentNumberOfSessionMailFactories", (Object)n);
        }
        return n;
    }

    public Integer getCurrentNumberOfMimeMailFactories() {
        if (this._MgetCurrentNumberOfMimeMailFactories) {
            this._cm.entryCallback("getCurrentNumberOfMimeMailFactories");
        }
        Integer n = this._getjMailMimePartDSFactories().size();
        if (this._MgetCurrentNumberOfMimeMailFactories) {
            this._cm.exitCallback("getCurrentNumberOfMimeMailFactories", (Object)n);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getMailFactoryPropertiesFile(String string) throws Exception {
        Properties properties;
        block4: {
            void configFile;
            if (this._MgetMailFactoryPropertiesFilejava_lang_String) {
                this._cm.entryCallback("getMailFactoryPropertiesFilejava_lang_String");
            }
            try {
                properties = JProp.getInstance((String)configFile).getConfigFileEnv();
                if (!this._MgetMailFactoryPropertiesFilejava_lang_String) break block4;
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Error occured when reading file " + (String)configFile));
                Exception exception = e;
                if (this._MgetMailFactoryPropertiesFilejava_lang_String) {
                    this._cm.exitCallback("getMailFactoryPropertiesFilejava_lang_String", (Object)exception);
                }
                throw exception;
            }
            this._cm.exitCallback("getMailFactoryPropertiesFilejava_lang_String", (Object)properties);
        }
        return properties;
    }

    public List<String> getMailFactoryPropertiesFiles() throws Exception {
        if (this._MgetMailFactoryPropertiesFiles) {
            this._cm.entryCallback("getMailFactoryPropertiesFiles");
        }
        ArrayList arrayList = JModule.getMailFactoryPropsInDir();
        if (this._MgetMailFactoryPropertiesFiles) {
            this._cm.exitCallback("getMailFactoryPropertiesFiles", (Object)arrayList);
        }
        return arrayList;
    }

    public List<String> getMimePartMailFactoryPropertiesFiles() throws Exception {
        if (this._MgetMimePartMailFactoryPropertiesFiles) {
            this._cm.entryCallback("getMimePartMailFactoryPropertiesFiles");
        }
        ArrayList arrayList = JModule.getMailFactoryPropsInDir((String)"javax.mail.internet.MimePartDataSource");
        if (this._MgetMimePartMailFactoryPropertiesFiles) {
            this._cm.exitCallback("getMimePartMailFactoryPropertiesFiles", (Object)arrayList);
        }
        return arrayList;
    }

    public List<String> getSessionMailFactoryPropertiesFiles() throws Exception {
        if (this._MgetSessionMailFactoryPropertiesFiles) {
            this._cm.entryCallback("getSessionMailFactoryPropertiesFiles");
        }
        ArrayList arrayList = JModule.getMailFactoryPropsInDir((String)"javax.mail.Session");
        if (this._MgetSessionMailFactoryPropertiesFiles) {
            this._cm.exitCallback("getSessionMailFactoryPropertiesFiles", (Object)arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this._setjmxService((JmxService)jmxService2);
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRegistryService(RegistryService registryService) {
        void registry;
        if (this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService) {
            this._cm.entryCallback("setRegistryServiceorg_ow2_jonas_registry_RegistryService");
        }
        this._setregistryService((RegistryService)registry);
        Object var2_2 = null;
        if (this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService) {
            this._cm.exitCallback("setRegistryServiceorg_ow2_jonas_registry_RegistryService", var2_2);
        }
    }

    private RegistryService getRegistryService() {
        if (this._MgetRegistryService) {
            this._cm.entryCallback("getRegistryService");
        }
        RegistryService registryService = this._getregistryService();
        if (this._MgetRegistryService) {
            this._cm.exitCallback("getRegistryService", (Object)registryService);
        }
        return registryService;
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("CLASS")) {
                this._FCLASS = true;
            }
            if (set.contains("jMailMimePartDSFactories")) {
                this._FjMailMimePartDSFactories = true;
            }
            if (set.contains("ictx")) {
                this._Fictx = true;
            }
            if (set.contains("JAVAX_MAIL_INTERNET_MIMEPARTDATASOURCE")) {
                this._FJAVAX_MAIL_INTERNET_MIMEPARTDATASOURCE = true;
            }
            if (set.contains("JAVAX_MAIL_SESSION_FACTORY")) {
                this._FJAVAX_MAIL_SESSION_FACTORY = true;
            }
            if (set.contains("factoryNames")) {
                this._FfactoryNames = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("registryService")) {
                this._FregistryService = true;
            }
            if (set.contains("bindedFactories")) {
                this._FbindedFactories = true;
            }
            if (set.contains("FACTORIES")) {
                this._FFACTORIES = true;
            }
            if (set.contains("jMailSessionFactories")) {
                this._FjMailSessionFactories = true;
            }
            if (set.contains("jmxService")) {
                this._FjmxService = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("setFactoriesjava_lang_String")) {
                this._MsetFactoriesjava_lang_String = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("recreateJavaMailFactoryorg_ow2_jonas_mail_factory_JavaMail")) {
                this._MrecreateJavaMailFactoryorg_ow2_jonas_mail_factory_JavaMail = true;
            }
            if (set.contains("renameJavaMailFactoryjava_lang_Stringorg_ow2_jonas_mail_factory_JavaMail")) {
                this._MrenameJavaMailFactoryjava_lang_Stringorg_ow2_jonas_mail_factory_JavaMail = true;
            }
            if (set.contains("createMailFactoryjava_lang_Stringjava_util_Properties")) {
                this._McreateMailFactoryjava_lang_Stringjava_util_Properties = true;
            }
            if (set.contains("createMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean")) {
                this._McreateMailFactoryMBeanjava_lang_Stringjava_util_Propertiesjava_lang_Boolean = true;
            }
            if (set.contains("unbindMailFactories")) {
                this._MunbindMailFactories = true;
            }
            if (set.contains("unbindMailFactoryMBeanjava_lang_String")) {
                this._MunbindMailFactoryMBeanjava_lang_String = true;
            }
            if (set.contains("getFactoryNamejava_lang_String")) {
                this._MgetFactoryNamejava_lang_String = true;
            }
            if (set.contains("getCurrentNumberOfMailFactories")) {
                this._MgetCurrentNumberOfMailFactories = true;
            }
            if (set.contains("getCurrentNumberOfSessionMailFactories")) {
                this._MgetCurrentNumberOfSessionMailFactories = true;
            }
            if (set.contains("getCurrentNumberOfMimeMailFactories")) {
                this._MgetCurrentNumberOfMimeMailFactories = true;
            }
            if (set.contains("getMailFactoryPropertiesFilejava_lang_String")) {
                this._MgetMailFactoryPropertiesFilejava_lang_String = true;
            }
            if (set.contains("getMailFactoryPropertiesFiles")) {
                this._MgetMailFactoryPropertiesFiles = true;
            }
            if (set.contains("getMimePartMailFactoryPropertiesFiles")) {
                this._MgetMimePartMailFactoryPropertiesFiles = true;
            }
            if (set.contains("getSessionMailFactoryPropertiesFiles")) {
                this._MgetSessionMailFactoryPropertiesFiles = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setRegistryServiceorg_ow2_jonas_registry_RegistryService")) {
                this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("getRegistryService")) {
                this._MgetRegistryService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

