/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.ha;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.ha.ActiveExecutionObject;
import org.ow2.cmi.ha.BeanInfo;
import org.ow2.cmi.ha.EntityBeanReference;
import org.ow2.cmi.ha.HaMessageData;
import org.ow2.cmi.ha.JGMessageManager;
import org.ow2.cmi.ha.MessageManager;
import org.ow2.cmi.ha.ReplicationException;
import org.ow2.cmi.ha.ReplicationManager;
import org.ow2.cmi.ha.ReplicationManagerImplMBean;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.SessionId;
import org.ow2.cmi.ha.StatefulBeanReference;
import org.ow2.cmi.ha.TOHashTable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ReplicationManagerImpl
implements ReplicationManager,
ReplicationManagerImplMBean {
    private static Log logger = LogFactory.getLog(ReplicationManagerImpl.class);
    private static final int HA_BACKUPINFO_DEFAULT_TIMEOUT = 600;
    private int timeout;
    private String txTableDatasource;
    private DataSource ds = null;
    private final MessageManager messageMgr;
    private final TOHashTable<RequestId, ActiveExecutionObject> activeExecutionObjects;
    private final Vector<HaMessageData> otherMessages = new Vector();
    private final TOHashTable<SessionId, HaMessageData> committingMessages;
    private final TOHashTable<SessionId, BeanInfo> backupBeanInfo;
    private final TOHashTable<RequestId, Object> backupRequestReponse;
    private String name = "HA";
    private ObjectName objectName = null;

    public ReplicationManagerImpl(int timeout, String datasource, String jgroupsConf, String jgroupsGroupname, long reconnectionTimeout) throws Exception {
        if (timeout == 0) {
            this.timeout = 600;
            logger.debug((Object)"Using defaults backup info timeout", new Object[0]);
        } else {
            this.timeout = timeout;
        }
        logger.debug((Object)("Backup info timeout: " + this.timeout), new Object[0]);
        this.txTableDatasource = datasource;
        logger.debug((Object)("Tx table datasource: " + this.txTableDatasource), new Object[0]);
        this.messageMgr = new JGMessageManager(jgroupsConf, jgroupsGroupname, this, reconnectionTimeout);
        this.activeExecutionObjects = new TOHashTable(timeout);
        this.committingMessages = new TOHashTable(timeout);
        this.backupBeanInfo = new TOHashTable(timeout);
        this.backupRequestReponse = new TOHashTable(timeout);
        logger.debug((Object)"Registering HA MBean", new Object[0]);
        this.objectName = MBeanUtils.registerXtraMBean(this.name, this);
        AbsServerClusterViewManager.getServerClusterViewManager().setReplicationManagerStarted(true);
    }

    public void addModifiedBean(RequestId reqId, SessionId clusterOId, StatefulBeanReference bean) {
        Vector<BeanInfo> modifiedBeans;
        logger.debug((Object)("Adding to request " + reqId + " modified bean " + clusterOId), new Object[0]);
        ActiveExecutionObject aeo = this.activeExecutionObjects.get(reqId);
        if (aeo == null) {
            logger.debug((Object)"\tCreating new ActiveExecutionObject", new Object[0]);
            aeo = new ActiveExecutionObject(reqId, null, null);
        }
        if ((modifiedBeans = aeo.getBeans()) == null) {
            logger.debug((Object)"\tCreating new beans vector", new Object[0]);
            modifiedBeans = new Vector();
        }
        modifiedBeans.add(new BeanInfo(clusterOId, bean));
        aeo.setBeans(modifiedBeans);
        this.activeExecutionObjects.put(reqId, aeo);
    }

    public void addEntityBean(RequestId reqId, EntityBeanReference bean) {
        Vector<EntityBeanReference> entityBeans;
        ActiveExecutionObject aeo;
        if (logger.isDebugEnabled()) {
            try {
                logger.debug((Object)("Adding to request " + reqId + " entity bean: " + bean.getPrimaryKey()), new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((aeo = this.activeExecutionObjects.get(reqId)) == null) {
            logger.debug((Object)"\tCreating new ActiveExecutionObject", new Object[0]);
            aeo = new ActiveExecutionObject(reqId, null, null);
        }
        if ((entityBeans = aeo.getEntityBeans()) == null) {
            logger.debug((Object)"\tCreating new entity beans vector", new Object[0]);
            entityBeans = new Vector();
        }
        entityBeans.add(bean);
        aeo.setEntityBeans(entityBeans);
        this.activeExecutionObjects.put(reqId, aeo);
    }

    public void addResponse(RequestId reqId, Object response) {
        logger.debug((Object)("Adding response to request: " + reqId + " response: " + response), new Object[0]);
        ActiveExecutionObject aeo = this.activeExecutionObjects.get(reqId);
        if (aeo == null) {
            aeo = new ActiveExecutionObject(reqId, null, response);
        } else {
            aeo.setResponse(response);
        }
        this.activeExecutionObjects.put(reqId, aeo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(RequestId requestId) throws ReplicationException {
        logger.debug((Object)("Replicating... Getting states from reqId " + requestId), new Object[0]);
        ActiveExecutionObject aeo = this.activeExecutionObjects.get(requestId);
        if (aeo != null) {
            Vector<BeanInfo> aeobeans = aeo.getBeans();
            Vector<BeanInfo> beans = new Vector<BeanInfo>();
            if (aeobeans != null) {
                for (int i = 0; i < aeobeans.size(); ++i) {
                    BeanInfo bean = aeobeans.elementAt(i);
                    StatefulBeanReference br = bean.getBean();
                    logger.debug((Object)("\tProcessing bean: " + bean.getBId()), new Object[0]);
                    if (br != null) {
                        if (br.isModified()) {
                            logger.debug((Object)"\tBean modified", new Object[0]);
                            bean.obtainBeanState();
                            beans.add(bean);
                            continue;
                        }
                        logger.debug((Object)"\tBean not modified", new Object[0]);
                        continue;
                    }
                    logger.debug((Object)"\tBean marked for remove", new Object[0]);
                    beans.add(bean);
                }
            }
            boolean readOnly = true;
            Vector<EntityBeanReference> entityBeans = aeo.getEntityBeans();
            if (entityBeans != null) {
                if (entityBeans.size() > 0) {
                    for (int i = 0; i < entityBeans.size(); ++i) {
                        EntityBeanReference ebr = entityBeans.elementAt(i);
                        if (!ebr.isModified()) continue;
                        readOnly = false;
                        break;
                    }
                } else {
                    readOnly = true;
                }
            } else {
                readOnly = true;
            }
            Object response = aeo.getResponse();
            Vector<HaMessageData> om = new Vector<HaMessageData>();
            Vector<HaMessageData> vector = this.otherMessages;
            synchronized (vector) {
                if (this.otherMessages.size() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"\tPiggy back messages", new Object[0]);
                        for (HaMessageData md : this.otherMessages) {
                            logger.debug((Object)("\t\tMessage: " + md), new Object[0]);
                        }
                    }
                    om.addAll(this.otherMessages);
                    this.otherMessages.clear();
                } else {
                    logger.debug((Object)"\tNo messages to Piggy back", new Object[0]);
                }
            }
            HaMessageData messageData = HaMessageData.newCommittingMessage(requestId, response, beans, readOnly, om);
            try {
                logger.debug((Object)("\tSend message: " + messageData), new Object[0]);
                if (!readOnly) {
                    this.insertTxid(requestId);
                }
                this.messageMgr.sendMessage(messageData);
                logger.debug((Object)("\tDeleting changes from requestChanges table for reqId: " + requestId), new Object[0]);
                this.activeExecutionObjects.remove(requestId);
            }
            catch (Exception e) {
                logger.error((Object)"\tunable to replicate", new Object[]{e});
                throw new ReplicationException();
            }
            logger.debug((Object)("\tactiveExecutionObjects T. Size : " + this.activeExecutionObjects.size()), new Object[0]);
        } else {
            logger.debug((Object)("\tNothing to replicate on committing for: " + requestId), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicateCommit(RequestId reqId, boolean committed) throws ReplicationException {
        logger.debug((Object)("Replicate commit: " + reqId + " committed: " + committed), new Object[0]);
        HaMessageData messageData = null;
        if (committed) {
            messageData = HaMessageData.newCommitMessage(reqId);
        } else {
            ActiveExecutionObject aeo = this.activeExecutionObjects.get(reqId);
            Object response = null;
            if (aeo != null) {
                response = aeo.getResponse();
                this.activeExecutionObjects.remove(reqId);
            }
            messageData = HaMessageData.newAbortMessage(reqId, response);
        }
        Vector<HaMessageData> vector = this.otherMessages;
        synchronized (vector) {
            logger.debug((Object)("Add message to otherMessages: " + messageData), new Object[0]);
            this.otherMessages.add(messageData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBackupResponse(RequestId requestId) {
        logger.debug((Object)("Check response for: " + requestId), new Object[0]);
        boolean found = false;
        found = this.backupRequestReponse.containsKey(requestId);
        if (!found) {
            logger.debug((Object)"\tResponse not found in backupRequestResponse", new Object[0]);
            TOHashTable<SessionId, HaMessageData> tOHashTable = this.committingMessages;
            synchronized (tOHashTable) {
                HaMessageData data = this.committingMessages.get(requestId.getObjectId());
                if (data != null) {
                    if (requestId.getRequestNo() == data.getRequestId().getRequestNo()) {
                        logger.debug((Object)"\tMessage found in commitingMessages", new Object[0]);
                        if (this.isCommitted(requestId)) {
                            logger.debug((Object)"\tTransaction found in tx table", new Object[0]);
                            this.commitMessageToBeanInfo(requestId);
                            found = true;
                        } else {
                            logger.debug((Object)"\tTransaction not found in tx table", new Object[0]);
                            this.committingMessages.remove(requestId.getObjectId());
                            found = false;
                        }
                    } else {
                        logger.debug((Object)"\tMessage found in commitingMessages but with bad request number", new Object[0]);
                    }
                }
            }
        } else {
            logger.debug((Object)"\tResponse found in backupRequestResponse", new Object[0]);
        }
        return found;
    }

    public Object getBackupResponse(RequestId reqId) {
        return this.backupRequestReponse.get(reqId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreBeanChanges(SessionId clusterOID, StatefulBeanReference bean) {
        logger.debug((Object)("Trying to restore EJB: " + clusterOID), new Object[0]);
        logger.debug((Object)"\tSearching in backupBeanInfo", new Object[0]);
        TOHashTable<SessionId, BeanInfo> tOHashTable = this.backupBeanInfo;
        synchronized (tOHashTable) {
            if (this.backupBeanInfo.containsKey(clusterOID)) {
                logger.debug((Object)(clusterOID + "\tBean found!"), new Object[0]);
                BeanInfo beanInfo = this.backupBeanInfo.get(clusterOID);
                try {
                    bean.injectState(beanInfo.getState());
                    logger.debug((Object)(clusterOID + "\tState injected!"), new Object[0]);
                }
                catch (Exception e) {
                    logger.error((Object)("\tError injecting the state in: " + clusterOID), new Object[]{e});
                }
                this.backupBeanInfo.remove(clusterOID);
                logger.debug((Object)("\t" + clusterOID + " EJB removed from backupBeanInfo!"), new Object[0]);
            } else {
                logger.debug((Object)(clusterOID + "\tBean not found!"), new Object[0]);
            }
        }
    }

    public void processMessage(HaMessageData data) {
        switch (data.getType()) {
            case COMMITTING_MESSAGE: {
                this.processCommittingMessage(data);
                break;
            }
            case COMMIT_MESSAGE: {
                this.processCommitMessage(data);
                break;
            }
            case ABORT_MESSAGE: {
                this.processAbortMessage(data);
                break;
            }
            default: {
                logger.error((Object)("Unknown message type: " + (Object)((Object)data.getType())), new Object[0]);
            }
        }
    }

    private void processCommittingMessage(HaMessageData data) {
        logger.debug((Object)("Processing committing message: " + data), new Object[0]);
        Iterator<HaMessageData> it = data.getOtherMessages().iterator();
        if (logger.isDebugEnabled() && it.hasNext()) {
            logger.debug((Object)"Processing piggy backed messages", new Object[0]);
        }
        while (it.hasNext()) {
            HaMessageData hmd = it.next();
            this.processMessage(hmd);
        }
        if (data.isReadOnly()) {
            this.messageToBeanInfo(data);
        } else {
            this.committingMessages.put(data.getRequestId().getObjectId(), data);
        }
    }

    private void processCommitMessage(HaMessageData data) {
        logger.debug((Object)("Processing commit message: " + data), new Object[0]);
        RequestId requestId = data.getRequestId();
        if (!this.commitMessageToBeanInfo(requestId)) {
            logger.debug((Object)("Request " + requestId + " from commit message don't found in table"), new Object[0]);
        }
    }

    private void processAbortMessage(HaMessageData data) {
        logger.debug((Object)("Processing abort message: " + data), new Object[0]);
        RequestId requestId = data.getRequestId();
        HaMessageData md = this.committingMessages.get(requestId.getObjectId());
        if (md != null) {
            this.backupRequestReponse.put(requestId, md.getResponse());
            this.committingMessages.remove(requestId.getObjectId());
        }
    }

    private boolean commitMessageToBeanInfo(RequestId requestId) {
        logger.debug((Object)("Processing from commitingMessages: " + requestId), new Object[0]);
        boolean found = false;
        HaMessageData md = this.committingMessages.get(requestId.getObjectId());
        if (md != null) {
            logger.debug((Object)"\tFound in committingMessages", new Object[0]);
            found = true;
            this.messageToBeanInfo(md);
            this.committingMessages.remove(requestId.getObjectId());
        } else {
            logger.debug((Object)"\tNot found in committingMessages", new Object[0]);
            found = false;
        }
        return found;
    }

    private void messageToBeanInfo(HaMessageData md) {
        Iterator<BeanInfo> it = md.getBeans().iterator();
        if (logger.isDebugEnabled()) {
            if (it.hasNext()) {
                logger.debug((Object)"\tMessage has beans", new Object[0]);
            } else {
                logger.debug((Object)"\tMessage don't have beans", new Object[0]);
            }
        }
        while (it.hasNext()) {
            BeanInfo bi = it.next();
            if (bi.getState() != null) {
                logger.debug((Object)("\tBean added to backupBeanInfo: " + bi.getBId()), new Object[0]);
                this.backupBeanInfo.put(bi.getBId(), bi);
                continue;
            }
            logger.debug((Object)("\tBean removed from backupBeanInfo: " + bi.getBId()), new Object[0]);
            this.backupBeanInfo.remove(bi.getBId());
        }
        this.backupRequestReponse.put(md.getRequestId(), md.getResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTxid(RequestId txid) {
        logger.debug((Object)("Insert txid in transaction table: " + txid), new Object[0]);
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement("insert into ha_transactions (txid) values (?)");
            pstmt.setString(1, txid.toString());
            int count = pstmt.executeUpdate();
            if (count != 1) {
                logger.error((Object)("\tUnable to insert tx id: " + txid + " expected 1, received: " + count), new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\tUnable to insert tx id: " + txid), new Object[]{e});
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCommitted(RequestId txid) {
        logger.debug((Object)("Check for txid in transaction table: " + txid), new Object[0]);
        boolean found = false;
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement("select txid from ha_transactions where txid = ?");
            pstmt.setString(1, txid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                logger.debug((Object)"\tTransaction found", new Object[0]);
                found = true;
            } else {
                logger.debug((Object)"\tTransaction not found", new Object[0]);
                found = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\tUnable to obtain tx id: " + txid), new Object[]{e});
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        return found;
    }

    private Connection getConnection() throws Exception {
        Connection conn = this.getDatasource().getConnection();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Tx table connection, isolation level: " + conn.getTransactionIsolation() + " autocommit: " + conn.getAutoCommit()), new Object[0]);
        }
        return conn;
    }

    private DataSource getDatasource() throws Exception {
        if (this.ds == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.ds = (DataSource)ctx.lookup(this.txTableDatasource);
            }
            catch (NamingException e) {
                logger.error((Object)"Unable to find datasource", new Object[]{e});
                throw e;
            }
        }
        return this.ds;
    }

    public void clear() {
        this.messageMgr.clear();
    }

    public String getName() {
        return this.name;
    }

    public String getobjectName() {
        return this.objectName.toString();
    }

    public void setobjectName(ObjectName name) {
        this.objectName = name;
    }

    public long getnumberofReplicatedMessages() {
        return this.messageMgr.getNumberofReplicatedMessages();
    }

    public double getavgSizeofReplicatedMessages() {
        return this.messageMgr.getAvgSizeofReplicatedMessages();
    }

    public double gettotSizeofReplicatedMessages() {
        return this.messageMgr.getTotSizeofReplicatedMessages();
    }

    public String getjgroupsConfFileName() {
        return this.messageMgr.jgroupsConfFileName();
    }

    public long getinfoTimeout() {
        return this.timeout;
    }

    public void setinfoTimeout(long timeout) {
        this.timeout = (int)timeout;
        this.activeExecutionObjects.setTimeout(this.timeout);
        this.committingMessages.setTimeout(this.timeout);
        this.backupBeanInfo.setTimeout(this.timeout);
        this.backupRequestReponse.setTimeout(this.timeout);
    }

    public String getdatasourceName() {
        return this.txTableDatasource;
    }

    public void setdatasourceName(String name) {
        this.txTableDatasource = name;
        this.ds = null;
    }
}

