/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.policy;

import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.lb.NoLoadBalanceableException;
import org.ow2.cmi.lb.policy.AbstractPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class Random<T extends LoadBalanceable>
extends AbstractPolicy<T> {
    private static final Log LOGGER = LogFactory.getLog(Random.class);
    private final java.util.Random random = new java.util.Random();

    @Override
    public synchronized T choose(List<T> loadBalanceables) throws NoLoadBalanceableException {
        List<T> cmiRefsWithStrategy;
        if (loadBalanceables == null || loadBalanceables.isEmpty()) {
            LOGGER.error((Object)("The given list is null or empty: " + loadBalanceables), new Object[0]);
            throw new NoLoadBalanceableException("The given list is null or empty: " + loadBalanceables);
        }
        IStrategy<T> strategy = this.getStrategy();
        if (strategy != null) {
            cmiRefsWithStrategy = strategy.choose(loadBalanceables);
            if (cmiRefsWithStrategy.isEmpty()) {
                cmiRefsWithStrategy = loadBalanceables;
            }
        } else {
            cmiRefsWithStrategy = loadBalanceables;
        }
        int index = this.random.nextInt(cmiRefsWithStrategy.size());
        return (T)((LoadBalanceable)cmiRefsWithStrategy.get(index));
    }

    public String toString() {
        return "Random[strategy: " + this.getStrategy() + "]";
    }
}

