/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.versioning.internal;

import java.io.File;
import java.net.URL;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.versioning.VersioningServiceBase;
import org.ow2.jonas.versioning.contexts.VirtualJNDIBinding;
import org.ow2.jonas.versioning.internal.VersioningServiceImplMBean;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningServiceImpl
extends AbsServiceImpl
implements VersioningService,
VersioningServiceImplMBean,
Pojo {
    private InstanceManager _cm;
    private static Log logger = LogFactory.getLog(VersioningService.class);
    private boolean _FdefaultPolicy;
    private String defaultPolicy;
    private boolean _FjmxService;
    private JmxService jmxService;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;
    private boolean _MdoStart;
    private boolean _MdoStop;
    private boolean _MgetPolicies;
    private boolean _MisVersioningEnabled;
    private boolean _MgetDefaultDeploymentPolicy;
    private boolean _MsetDefaultDeploymentPolicyjava_lang_String;
    private boolean _MgetVersionIDjava_io_File;
    private boolean _MgetVersionIDjava_net_URL;
    private boolean _MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean _MgetPrefixjava_io_File;
    private boolean _MgetPrefixjava_net_URL;
    private boolean _MgetPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean _MgetOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean _McreateJNDIBindingMBeansorg_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean _MgarbageCollectJNDIBindingMBeans;
    private boolean _MgetBaseNamejava_net_URL;

    private String _getdefaultPolicy() {
        if (!this._FdefaultPolicy) {
            return this.defaultPolicy;
        }
        return (String)this._cm.getterCallback("defaultPolicy");
    }

    private void _setdefaultPolicy(String string) {
        if (!this._FdefaultPolicy) {
            this.defaultPolicy = string;
            return;
        }
        this._cm.setterCallback("defaultPolicy", (Object)string);
    }

    private JmxService _getjmxService() {
        if (!this._FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this._cm.getterCallback("jmxService");
    }

    private void _setjmxService(JmxService jmxService) {
        if (!this._FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this._cm.setterCallback("jmxService", (Object)jmxService);
    }

    public VersioningServiceImpl(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setdefaultPolicy("Reserved");
        this._setjmxService(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this._setjmxService((JmxService)jmxService2);
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    public static ObjectName getObjectName(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=versioning");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get versioning service", e);
        }
    }

    protected void doStart() {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        VirtualJNDIBinding.initialize(this, this._getjmxService());
        this._getjmxService().registerMBean((Object)this, VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info((Object)"Versioning service management bean has been registered successfully", new Object[0]);
        Object var1_1 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var1_1);
        }
    }

    protected void doStop() {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        this._getjmxService().unregisterMBean(VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info((Object)"Versioning service management bean has been unregistered successfully", new Object[0]);
        Object var1_1 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var1_1);
        }
    }

    @Override
    public String[] getPolicies() {
        if (this._MgetPolicies) {
            this._cm.entryCallback("getPolicies");
        }
        String[] stringArray = VersioningServiceBase.POLICIES;
        if (this._MgetPolicies) {
            this._cm.exitCallback("getPolicies", (Object)stringArray);
        }
        return stringArray;
    }

    @Override
    public boolean isVersioningEnabled() {
        if (this._MisVersioningEnabled) {
            this._cm.entryCallback("isVersioningEnabled");
        }
        Boolean bl = new Boolean(this.isStarted());
        if (this._MisVersioningEnabled) {
            this._cm.exitCallback("isVersioningEnabled", (Object)bl);
        }
        return bl;
    }

    @Override
    public String getDefaultDeploymentPolicy() {
        if (this._MgetDefaultDeploymentPolicy) {
            this._cm.entryCallback("getDefaultDeploymentPolicy");
        }
        String string = this._getdefaultPolicy();
        if (this._MgetDefaultDeploymentPolicy) {
            this._cm.exitCallback("getDefaultDeploymentPolicy", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDefaultDeploymentPolicy(String string) {
        void defaultPolicy;
        if (this._MsetDefaultDeploymentPolicyjava_lang_String) {
            this._cm.entryCallback("setDefaultDeploymentPolicyjava_lang_String");
        }
        if (!("Default".equals(defaultPolicy) || "Disabled".equals(defaultPolicy) || "Reserved".equals(defaultPolicy) || "Private".equals(defaultPolicy))) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid policy : " + (String)defaultPolicy);
            if (this._MsetDefaultDeploymentPolicyjava_lang_String) {
                this._cm.exitCallback("setDefaultDeploymentPolicyjava_lang_String", (Object)illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        this._setdefaultPolicy((String)defaultPolicy);
        Object var3_3 = null;
        if (this._MsetDefaultDeploymentPolicyjava_lang_String) {
            this._cm.exitCallback("setDefaultDeploymentPolicyjava_lang_String", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getVersionID(File file) {
        String string;
        block4: {
            void file2;
            if (this._MgetVersionIDjava_io_File) {
                this._cm.entryCallback("getVersionIDjava_io_File");
            }
            try {
                IArchive archive = ArchiveManager.getInstance().getArchive((Object)file2);
                IDeployable deployable = DeployableHelper.getDeployable((IArchive)archive);
                string = this.getVersionID(deployable);
                if (!this._MgetVersionIDjava_io_File) break block4;
            }
            catch (DeployableHelperException e) {
                logger.info((Object)("Failed creating deployable for file " + file2), new Object[]{e});
                String string2 = null;
                if (this._MgetVersionIDjava_io_File) {
                    this._cm.exitCallback("getVersionIDjava_io_File", string2);
                }
                return string2;
            }
            this._cm.exitCallback("getVersionIDjava_io_File", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getVersionID(URL uRL) {
        void url;
        if (this._MgetVersionIDjava_net_URL) {
            this._cm.entryCallback("getVersionIDjava_net_URL");
        }
        String string = this.getVersionID(URLUtils.urlToFile((URL)url));
        if (this._MgetVersionIDjava_net_URL) {
            this._cm.exitCallback("getVersionIDjava_net_URL", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getVersionID(IDeployable<?> iDeployable) {
        void deployable;
        IDeployable<?> originalDeployable;
        String versionID;
        if (this._MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.entryCallback("getVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable");
        }
        if ((versionID = (originalDeployable = this.getOriginalDeployable((IDeployable<?>)deployable)).getArchive().getMetadata().get("Implementation-Version")) != null) {
            String allowedSpecialChars = "-_,.";
            boolean versionIDFiltered = false;
            StringBuffer versionIDFilter = new StringBuffer();
            for (char c : versionID.toCharArray()) {
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "-_,.".indexOf(c) >= 0) {
                    versionIDFilter.append(c);
                    continue;
                }
                versionIDFiltered = true;
                versionIDFilter.append('-');
            }
            if (versionIDFiltered) {
                versionID = versionIDFilter.toString();
                logger.debug((Object)("Invalid characters detected in version ID for archive " + originalDeployable.getArchive().getName() + ", setting version ID to " + versionID), new Object[0]);
            }
            versionID = "-version" + versionID;
        }
        String string = versionID;
        if (this._MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.exitCallback("getVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPrefix(File file) {
        String string;
        block4: {
            void file2;
            if (this._MgetPrefixjava_io_File) {
                this._cm.entryCallback("getPrefixjava_io_File");
            }
            try {
                IArchive archive = ArchiveManager.getInstance().getArchive((Object)file2);
                IDeployable deployable = DeployableHelper.getDeployable((IArchive)archive);
                string = this.getPrefix(deployable);
                if (!this._MgetPrefixjava_io_File) break block4;
            }
            catch (DeployableHelperException e) {
                logger.info((Object)("Failed creating deployable for file " + file2), new Object[]{e});
                String string2 = null;
                if (this._MgetPrefixjava_io_File) {
                    this._cm.exitCallback("getPrefixjava_io_File", string2);
                }
                return string2;
            }
            this._cm.exitCallback("getPrefixjava_io_File", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPrefix(URL uRL) {
        void url;
        if (this._MgetPrefixjava_net_URL) {
            this._cm.entryCallback("getPrefixjava_net_URL");
        }
        String string = this.getPrefix(URLUtils.urlToFile((URL)url));
        if (this._MgetPrefixjava_net_URL) {
            this._cm.exitCallback("getPrefixjava_net_URL", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPrefix(IDeployable<?> iDeployable) {
        String applicationName;
        void deployable;
        IDeployable<?> originalDeployable;
        String versionID;
        if (this._MgetPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.entryCallback("getPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable");
        }
        if ((versionID = this.getVersionID(originalDeployable = this.getOriginalDeployable((IDeployable<?>)deployable))) == null) {
            String string = null;
            if (this._MgetPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
                this._cm.exitCallback("getPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable", string);
            }
            return string;
        }
        String prefix = applicationName = originalDeployable.getModuleName();
        if (!applicationName.endsWith(versionID)) {
            prefix = prefix + versionID;
        }
        prefix = prefix + '/';
        String allowedSpecialChars = "_./";
        boolean jndiPrefixFiltered = false;
        StringBuffer jndiPrefixFilter = new StringBuffer();
        for (char c : prefix.toCharArray()) {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "_./".indexOf(c) >= 0) {
                jndiPrefixFilter.append(c);
                continue;
            }
            jndiPrefixFiltered = true;
            jndiPrefixFilter.append('_');
        }
        if (jndiPrefixFiltered) {
            prefix = jndiPrefixFilter.toString();
            logger.debug((Object)("Invalid characters detected in the JNDI prefix for application " + applicationName + ", setting JNDI prefix to " + prefix), new Object[0]);
        }
        String string = prefix;
        if (this._MgetPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.exitCallback("getPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private IDeployable<?> getOriginalDeployable(IDeployable<?> iDeployable) {
        void deployable;
        if (this._MgetOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.entryCallback("getOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable");
        }
        IDeployable originalDeployable = deployable;
        while (originalDeployable.getOriginalDeployable() != null) {
            originalDeployable = originalDeployable.getOriginalDeployable();
        }
        void var3_3 = originalDeployable;
        if (this._MgetOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.exitCallback("getOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)var3_3);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createJNDIBindingMBeans(IDeployable<?> iDeployable) {
        void deployable;
        IDeployable<?> originalDeployable;
        String versionID;
        if (this._McreateJNDIBindingMBeansorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.entryCallback("createJNDIBindingMBeansorg_ow2_util_ee_deploy_api_deployable_IDeployable");
        }
        if ((versionID = this.getVersionID(originalDeployable = this.getOriginalDeployable((IDeployable<?>)deployable))) == null) {
            logger.warn((Object)("IDeployable " + deployable.toString() + " is not versioned! Ignoring call to createJNDIBindingMBeans"), new Object[0]);
            Object var4_4 = null;
            if (this._McreateJNDIBindingMBeansorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
                this._cm.exitCallback("createJNDIBindingMBeansorg_ow2_util_ee_deploy_api_deployable_IDeployable", var4_4);
            }
            return;
        }
        String applicationName = originalDeployable.getModuleName();
        if (applicationName.endsWith(versionID)) {
            applicationName = applicationName.replace(versionID, "");
        }
        String prefix = this.getPrefix(originalDeployable);
        VirtualJNDIBinding.createJNDIBindingMBeans(applicationName, prefix);
        Object var7_7 = null;
        if (this._McreateJNDIBindingMBeansorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.exitCallback("createJNDIBindingMBeansorg_ow2_util_ee_deploy_api_deployable_IDeployable", var7_7);
        }
    }

    @Override
    public void garbageCollectJNDIBindingMBeans() {
        if (this._MgarbageCollectJNDIBindingMBeans) {
            this._cm.entryCallback("garbageCollectJNDIBindingMBeans");
        }
        VirtualJNDIBinding.garbageCollectJNDIBindingMBeans();
        Object var1_1 = null;
        if (this._MgarbageCollectJNDIBindingMBeans) {
            this._cm.exitCallback("garbageCollectJNDIBindingMBeans", var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getBaseName(URL uRL) {
        String string;
        block5: {
            void url;
            if (this._MgetBaseNamejava_net_URL) {
                this._cm.entryCallback("getBaseNamejava_net_URL");
            }
            File file = URLUtils.urlToFile((URL)url);
            try {
                IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
                IDeployable<?> originalDeployable = this.getOriginalDeployable(DeployableHelper.getDeployable((IArchive)archive));
                String moduleName = originalDeployable.getModuleName();
                String versionID = this.getVersionID(originalDeployable);
                if (versionID != null) {
                    moduleName = moduleName.replace(versionID, "");
                }
                string = moduleName;
                if (!this._MgetBaseNamejava_net_URL) break block5;
            }
            catch (DeployableHelperException e) {
                logger.info((Object)("Failed creating deployable for file " + file), new Object[]{e});
                String string2 = null;
                if (this._MgetBaseNamejava_net_URL) {
                    this._cm.exitCallback("getBaseNamejava_net_URL", string2);
                }
                return string2;
            }
            this._cm.exitCallback("getBaseNamejava_net_URL", (Object)string);
        }
        return string;
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("defaultPolicy")) {
                this._FdefaultPolicy = true;
            }
            if (set.contains("jmxService")) {
                this._FjmxService = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("getPolicies")) {
                this._MgetPolicies = true;
            }
            if (set.contains("isVersioningEnabled")) {
                this._MisVersioningEnabled = true;
            }
            if (set.contains("getDefaultDeploymentPolicy")) {
                this._MgetDefaultDeploymentPolicy = true;
            }
            if (set.contains("setDefaultDeploymentPolicyjava_lang_String")) {
                this._MsetDefaultDeploymentPolicyjava_lang_String = true;
            }
            if (set.contains("getVersionIDjava_io_File")) {
                this._MgetVersionIDjava_io_File = true;
            }
            if (set.contains("getVersionIDjava_net_URL")) {
                this._MgetVersionIDjava_net_URL = true;
            }
            if (set.contains("getVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this._MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("getPrefixjava_io_File")) {
                this._MgetPrefixjava_io_File = true;
            }
            if (set.contains("getPrefixjava_net_URL")) {
                this._MgetPrefixjava_net_URL = true;
            }
            if (set.contains("getPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this._MgetPrefixorg_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("getOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this._MgetOriginalDeployableorg_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("createJNDIBindingMBeansorg_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this._McreateJNDIBindingMBeansorg_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("garbageCollectJNDIBindingMBeans")) {
                this._MgarbageCollectJNDIBindingMBeans = true;
            }
            if (set.contains("getBaseNamejava_net_URL")) {
                this._MgetBaseNamejava_net_URL = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

