/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherAnycastTest
extends ChannelTestBase {
    RpcDispatcher disp;
    RpcDispatcher disp2;
    RpcDispatcher disp3;
    Channel ch;
    Channel ch2;
    Channel ch3;

    public void setUp() throws Exception {
        super.setUp();
        this.ch = this.createChannel("A");
        ServerObject obj = new ServerObject(null);
        this.disp = new RpcDispatcher(this.ch, null, null, obj);
        this.ch.connect("demo");
        obj.setAddress(this.ch.getLocalAddress());
        this.ch2 = this.createChannel("A");
        ServerObject obj2 = new ServerObject(null);
        this.disp2 = new RpcDispatcher(this.ch2, null, null, obj2);
        this.ch2.connect("demo");
        obj2.setAddress(this.ch2.getLocalAddress());
        this.ch3 = this.createChannel("A");
        ServerObject obj3 = new ServerObject(null);
        this.disp3 = new RpcDispatcher(this.ch3, null, null, obj3);
        this.ch3.connect("demo");
        obj3.setAddress(this.ch3.getLocalAddress());
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.ch3.close();
        this.disp3.stop();
        this.ch2.close();
        this.disp2.stop();
        this.ch.close();
        this.disp.stop();
    }

    public void testUnserializableValue() {
        Vector<Address> members = this.ch.getView().getMembers();
        System.out.println("members: " + members);
        RpcDispatcherAnycastTest.assertTrue((String)"we should have more than 1 member", (members.size() > 1 ? 1 : 0) != 0);
        Vector subset = Util.pickSubset(members, 0.2);
        System.out.println("subset: " + subset);
        Util.sleep(1000L);
        RspList rsps = this.disp.callRemoteMethods(subset, "foo", null, (Class[])null, 2, 0L, false);
        System.out.println("rsps (no anycast): " + rsps);
        rsps = this.disp.callRemoteMethods(subset, "foo", null, (Class[])null, 2, 0L, true);
        System.out.println("rsps (with anycast): " + rsps);
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherAnycastTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherAnycastTest.suite());
    }

    static class ServerObject {
        Address addr;

        public ServerObject(Address addr) {
            this.addr = addr;
        }

        public Address foo() {
            System.out.println("foo() - returning " + this.addr);
            return this.addr;
        }

        public void setAddress(Address localAddress) {
            this.addr = localAddress;
        }
    }
}

