/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.vendor;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InjectionException;
import com.sun.enterprise.InjectionManager;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.faces.spi.DiscoverableInjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishInjectionProvider
extends DiscoverableInjectionProvider {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private InjectionManager injectionManager;
    private Switch theSwitch = Switch.getSwitch();
    private InvocationManager invokeMgr = this.theSwitch.getInvocationManager();

    public GlassFishInjectionProvider() {
        this.injectionManager = this.theSwitch.getInjectionManager();
    }

    @Override
    public void inject(Object managedBean) throws InjectionProviderException {
        try {
            this.injectionManager.injectInstance(managedBean, this.getNamingEnvironment(), false);
        }
        catch (InjectionException ie) {
            throw new InjectionProviderException(ie);
        }
    }

    @Override
    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        try {
            this.injectionManager.invokeInstancePreDestroy(managedBean);
        }
        catch (InjectionException ie) {
            throw new InjectionProviderException(ie);
        }
    }

    @Override
    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        try {
            this.invokePostConstruct(managedBean, this.getNamingEnvironment());
        }
        catch (InjectionException ie) {
            throw new InjectionProviderException(ie);
        }
    }

    private JndiNameEnvironment getNamingEnvironment() throws InjectionException {
        ComponentInvocation inv = this.invokeMgr.getCurrentInvocation();
        if (inv != null) {
            JndiNameEnvironment componentEnv = (JndiNameEnvironment)this.theSwitch.getDescriptorFor(inv.getContainerContext());
            if (componentEnv != null) {
                return componentEnv;
            }
            throw new InjectionException("No descriptor registered for  current invocation : " + inv);
        }
        throw new InjectionException("null invocation context");
    }

    private void invokePostConstruct(Object instance, JndiNameEnvironment envDescriptor) throws InjectionException {
        LinkedList<Method> postConstructMethods = new LinkedList<Method>();
        for (Class<?> nextClass = instance.getClass(); !Object.class.equals(nextClass) && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass.getName());
            if (injInfo.getPostConstructMethodName() == null) continue;
            Method postConstructMethod = this.getPostConstructMethod(injInfo, nextClass);
            postConstructMethods.addFirst(postConstructMethod);
        }
        for (Method postConstructMethod : postConstructMethods) {
            this.invokeLifecycleMethod(postConstructMethod, instance);
        }
    }

    private Method getPostConstructMethod(InjectionInfo injInfo, Class<? extends Object> resourceClass) throws InjectionException {
        Method m = injInfo.getPostConstructMethod();
        if (m == null) {
            String postConstructMethodName = injInfo.getPostConstructMethodName();
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(postConstructMethodName) || next.getParameterTypes().length != 0) continue;
                m = next;
                injInfo.setPostConstructMethod(m);
                break;
            }
        }
        if (m == null) {
            throw new InjectionException("InjectionManager exception. PostConstruct method " + injInfo.getPostConstructMethodName() + " could not be found in class " + injInfo.getClassName());
        }
        return m;
    }

    private void invokeLifecycleMethod(final Method lifecycleMethod, final Object instance) throws InjectionException {
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Calling lifecycle method " + lifecycleMethod + " on class " + lifecycleMethod.getDeclaringClass());
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (!lifecycleMethod.isAccessible()) {
                        lifecycleMethod.setAccessible(true);
                    }
                    lifecycleMethod.invoke(instance, new Object[0]);
                    return null;
                }
            });
        }
        catch (Exception t) {
            String msg = "Exception attempting invoke lifecycle  method " + lifecycleMethod;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, msg, t);
            }
            InjectionException ie = new InjectionException(msg);
            Throwable cause = t instanceof InvocationTargetException ? t.getCause() : t;
            ie.initCause(cause);
            throw ie;
        }
    }
}

