/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Network;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.agent.ServiceManager;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNat;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.A3CMLService;
import fr.dyade.aaa.agent.conf.UnknownDomainException;
import fr.dyade.aaa.agent.conf.UnknownServerException;
import fr.dyade.aaa.util.Transaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ConfigController {
    public static final String ADMIN_SERVER = "fr.dyade.aaa.agent.ADMIN_SERVER";
    public static final String SERVER_COUNTER = "serverCounter";
    private static Logger logger = Debug.getLogger("fr.dyade.aaa.agent.ConfigController");
    private short serverCounter;
    private A3CMLConfig currentA3cmlConfig;
    private A3CMLConfig a3cmlConfig;
    private int status;
    private Vector newServers;
    private Vector stopScript;
    private Vector startScript;
    private Hashtable envProperties;

    ConfigController() throws Exception {
        Transaction transaction;
        Short counter;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ConfigController.<init>()");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> AgentServer.getServerId() = " + AgentServer.getServerId()));
        }
        this.serverCounter = AgentServer.getServerId() == 0 ? ((counter = (Short)(transaction = AgentServer.getTransaction()).load(SERVER_COUNTER)) != null ? counter : (short)1) : (short)-1;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> serverCounter = " + this.serverCounter));
        }
        this.setStatus(0);
    }

    private void setStatus(int status) {
        this.status = status;
    }

    public synchronized void beginConfig() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ConfigController.beginConfig()");
        }
        while (this.status != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException exc) {}
        }
        this.currentA3cmlConfig = AgentServer.getConfig();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.currentA3cmlConfig);
        oos.flush();
        oos.close();
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.a3cmlConfig = (A3CMLConfig)ois.readObject();
        this.newServers = new Vector();
        this.startScript = new Vector();
        this.stopScript = new Vector();
        this.envProperties = new Hashtable();
        this.setStatus(1);
    }

    public synchronized void commitConfig() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ConfigController.commitConfig()");
        }
        this.checkStatus(1);
        AgentServer.setConfig(this.a3cmlConfig, true);
        try {
            A3CMLServer root = this.a3cmlConfig.getServer(AgentServer.getServerId());
            this.a3cmlConfig.configure(root);
            this.stop();
            this.addNewServers();
            this.addEnvProperties();
            this.start();
            this.commit();
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            this.rollback();
            throw exc;
        }
        finally {
            this.setStatus(0);
            this.notify();
        }
    }

    private void addEnvProperties() {
        Enumeration keys = this.envProperties.keys();
        Enumeration values = this.envProperties.elements();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = (String)values.nextElement();
            System.setProperty(name, value);
        }
    }

    private void commit() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ConfigController.commit()");
        }
        try {
            Transaction transaction = AgentServer.getTransaction();
            transaction.begin();
            this.a3cmlConfig.save();
            transaction.save(new Short(this.serverCounter), SERVER_COUNTER);
            transaction.commit(true);
        }
        catch (Exception exc) {
            throw new Error(exc.toString());
        }
    }

    private void rollback() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ConfigController.rollback()");
        }
        for (int i = 0; i < this.newServers.size(); ++i) {
            ServerDesc sd = (ServerDesc)this.newServers.elementAt(i);
            AgentServer.removeServerDesc(sd.sid);
        }
        AgentServer.setConfig(this.currentA3cmlConfig, true);
    }

    public synchronized void release() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ConfigController.release()");
        }
        if (this.status == 1) {
            this.setStatus(0);
            this.notify();
        }
    }

    private void stop() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ConfigController.stop()");
        }
        for (int i = 0; i < this.stopScript.size(); ++i) {
            Object cmd = this.stopScript.elementAt(i);
            if (!(cmd instanceof StopNetworkCmd)) continue;
            this.exec((StopNetworkCmd)cmd);
        }
    }

    private void exec(StopNetworkCmd cmd) throws Exception {
        this.stopNetwork(cmd.domainName);
    }

    private void addNewServers() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ConfigController.addNewServers()");
        }
        for (int i = 0; i < this.newServers.size(); ++i) {
            ServerDesc sd = (ServerDesc)this.newServers.elementAt(i);
            AgentServer.addServerDesc(sd);
        }
    }

    private void start() throws Exception {
        Object cmd;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ConfigController.start()");
        }
        int i = 0;
        try {
            for (i = 0; i < this.startScript.size(); ++i) {
                cmd = this.startScript.elementAt(i);
                if (cmd instanceof StartNetworkCmd) {
                    this.exec((StartNetworkCmd)cmd);
                    continue;
                }
                if (cmd instanceof StartServiceCmd) {
                    this.exec((StartServiceCmd)cmd);
                    continue;
                }
                if (cmd instanceof ReconfigureClientNetworkCmd) {
                    this.exec((ReconfigureClientNetworkCmd)cmd);
                    continue;
                }
                if (!(cmd instanceof ReconfigureServerNetworkCmd)) continue;
                this.exec((ReconfigureServerNetworkCmd)cmd);
            }
        }
        catch (Exception exc) {
            int size = i + 1;
            for (int j = 0; j < size; ++j) {
                Object cmd2 = this.startScript.elementAt(j);
                if (cmd2 instanceof StartNetworkCmd) {
                    this.rollback((StartNetworkCmd)cmd2);
                    continue;
                }
                if (cmd2 instanceof StartServiceCmd) {
                    this.rollback((StartServiceCmd)cmd2);
                    continue;
                }
                if (cmd2 instanceof ReconfigureClientNetworkCmd) {
                    this.rollback((ReconfigureClientNetworkCmd)cmd2);
                    continue;
                }
                if (!(cmd2 instanceof ReconfigureServerNetworkCmd)) continue;
                this.rollback((ReconfigureServerNetworkCmd)cmd2);
            }
            throw exc;
        }
        try {
            for (i = 0; i < this.startScript.size(); ++i) {
                cmd = this.startScript.elementAt(i);
                if (!(cmd instanceof StartServerCmd)) continue;
                this.exec((StartServerCmd)cmd);
            }
        }
        catch (Exception exc) {
            int size = i + 1;
            for (int j = 0; j < size; ++j) {
                Object cmd3 = this.startScript.elementAt(j);
                if (!(cmd3 instanceof StartServerCmd)) continue;
                this.rollback((StartServerCmd)cmd3);
            }
        }
    }

    private void exec(StartServerCmd cmd) throws Exception {
        this.startServer(cmd.sid);
    }

    private void exec(StartNetworkCmd cmd) throws Exception {
        this.startNetwork(cmd.domainName);
    }

    private void exec(StartServiceCmd cmd) throws Exception {
        this.startService(cmd.serviceClassName, cmd.args);
    }

    private void exec(ReconfigureClientNetworkCmd cmd) throws Exception {
        this.reconfigureClientNetwork(cmd.sid, cmd.domainName, cmd.port);
    }

    private void exec(ReconfigureServerNetworkCmd cmd) throws Exception {
        this.reconfigureServerNetwork(cmd.domainName, cmd.port);
    }

    private void rollback(StartServerCmd cmd) throws Exception {
        ServerDesc servDesc = AgentServer.getServerDesc(cmd.sid);
        this.deleteServer(servDesc);
    }

    private void rollback(StartNetworkCmd cmd) throws Exception {
        this.stopNetwork(cmd.domainName);
    }

    private void rollback(StartServiceCmd cmd) throws Exception {
        this.stopService(cmd.serviceClassName);
    }

    private void rollback(ReconfigureClientNetworkCmd cmd) throws Exception {
    }

    private void rollback(ReconfigureServerNetworkCmd cmd) throws Exception {
    }

    private synchronized void checkStatus(int expectedStatus) throws Exception {
        if (this.status != expectedStatus) {
            throw new Exception("Illegal status: " + Status.toString(this.status) + " expected: " + Status.toString(expectedStatus));
        }
    }

    public void addDomain(String name, String className) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.addDomain(" + name + ',' + className + ')'));
        }
        this.checkStatus(1);
        try {
            this.a3cmlConfig.addDomain(new A3CMLDomain(name, className));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int addServer(String name, String hostName, short id) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.addServer(" + name + ',' + hostName + ',' + id + ')'));
        }
        this.checkStatus(1);
        if (!this.a3cmlConfig.containsServer(name)) {
            if (id < 0) {
                if (this.serverCounter > -1) {
                    short s = this.serverCounter;
                    this.serverCounter = (short)(s + 1);
                    id = s;
                } else {
                    throw new Exception("Missing server id");
                }
            }
            this.a3cmlConfig.addServer(new A3CMLServer(id, name, hostName));
            ServerDesc serverDesc = new ServerDesc(id, name, hostName, -1);
            serverDesc.gateway = id;
            this.newServers.addElement(serverDesc);
        }
        if (id != AgentServer.getServerId()) {
            this.startScript.addElement(new StartServerCmd(id));
        }
        return id;
    }

    public void addService(String serverName, String serviceClassName, String args) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.addService(" + serverName + ',' + serviceClassName + ',' + args + ')'));
        }
        this.checkStatus(1);
        A3CMLServer server = this.a3cmlConfig.getServer(serverName);
        A3CMLService newService = new A3CMLService(serviceClassName, args);
        try {
            server.addService(newService);
        }
        catch (Exception exc) {
            // empty catch block
        }
        short sid = this.a3cmlConfig.getServerIdByName(serverName);
        if (sid == AgentServer.getServerId()) {
            this.startScript.addElement(new StartServiceCmd(serviceClassName, args));
        }
    }

    public void addNetwork(String serverName, String domainName, int port) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.addNetwork(" + serverName + ',' + domainName + ',' + port + ')'));
        }
        short sid = this.a3cmlConfig.getServerIdByName(serverName);
        this.addNetwork(sid, domainName, port);
    }

    public void addNetwork(short serverId, String domainName, int port) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.addNetwork(" + serverId + ',' + domainName + ',' + port + ')'));
        }
        this.checkStatus(1);
        A3CMLServer server = this.a3cmlConfig.getServer(serverId);
        A3CMLNetwork newNetwork = new A3CMLNetwork(domainName, port);
        try {
            server.addNetwork(newNetwork);
            A3CMLDomain domain = this.a3cmlConfig.getDomain(domainName);
            domain.addServer(server);
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (serverId == AgentServer.getServerId()) {
            this.startScript.add(new StartNetworkCmd(domainName));
        }
    }

    public void setNetworkPort(String serverName, String domainName, int port) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.setNetworkPort(" + serverName + ',' + domainName + ',' + port + ')'));
        }
        this.checkStatus(1);
        A3CMLServer server = this.a3cmlConfig.getServer(serverName);
        A3CMLNetwork network = server.getNetwork(domainName);
        if (network == null) {
            throw new Exception("Unknown network");
        }
        network.port = port;
        if (server.sid == AgentServer.getServerId()) {
            this.startScript.add(new ReconfigureServerNetworkCmd(domainName, new Integer(port)));
        } else {
            this.startScript.add(new ReconfigureClientNetworkCmd(server.sid, domainName, new Integer(port)));
        }
    }

    public void setNetworkProperties(String serverName, String domainName, Integer port) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.setNetworkPort(" + serverName + ',' + domainName + ',' + port + ')'));
        }
        this.checkStatus(1);
        A3CMLServer server = this.a3cmlConfig.getServer(serverName);
        A3CMLNetwork network = server.getNetwork(domainName);
        if (port != null) {
            if (network != null) {
                network.port = port;
            } else {
                throw new Exception("Unknown network");
            }
        }
        if (server.sid == AgentServer.getServerId()) {
            this.startScript.add(new ReconfigureServerNetworkCmd(domainName, port));
        } else {
            this.startScript.add(new ReconfigureClientNetworkCmd(server.sid, domainName, port));
        }
    }

    public void setJVMArgs(String serverName, String jvmArgs) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.setJVMArgs(" + serverName + ',' + jvmArgs + ')'));
        }
        this.checkStatus(1);
        A3CMLServer server = this.a3cmlConfig.getServer(serverName);
        server.jvmArgs = jvmArgs;
    }

    public void setProperty(String propName, String value) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.setProperty(" + propName + ',' + value + ')'));
        }
        this.checkStatus(1);
        this.a3cmlConfig.addProperty(new A3CMLProperty(propName, value));
        this.envProperties.put(propName, value);
    }

    public void setServerProperty(String serverName, String propName, String value) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.setServerProperty(" + serverName + ',' + propName + ',' + value + ')'));
        }
        this.checkStatus(1);
        A3CMLServer server = this.a3cmlConfig.getServer(serverName);
        server.addProperty(new A3CMLProperty(propName, value));
        this.envProperties.put(propName, value);
    }

    public void setServerNat(String serverName, String translatedServerName, String translationHostName, int translationPort) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.setServerNat(" + serverName + ',' + translatedServerName + ',' + translationHostName + ',' + translationPort + ')'));
        }
        this.checkStatus(1);
        A3CMLServer server = this.a3cmlConfig.getServer(serverName);
        short sid = this.a3cmlConfig.getServerIdByName(translatedServerName);
        server.addNat(new A3CMLNat(sid, translationHostName, translationPort));
    }

    public void removeDomain(String domainName) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.removeDomain(" + domainName + ')'));
        }
        this.checkStatus(1);
        try {
            A3CMLServer server;
            int i;
            Vector<A3CMLServer> serversToRemove = new Vector<A3CMLServer>();
            A3CMLDomain domain = this.a3cmlConfig.getDomain(domainName);
            for (i = 0; i < domain.servers.size(); ++i) {
                server = (A3CMLServer)domain.servers.elementAt(i);
                if (server.networks.size() == 1) {
                    serversToRemove.addElement(server);
                    continue;
                }
                this.removeNetwork(server.name, domainName);
            }
            for (i = 0; i < serversToRemove.size(); ++i) {
                server = (A3CMLServer)serversToRemove.elementAt(i);
                if (server.sid != AgentServer.getServerId()) {
                    this.removeServer(server.name);
                    continue;
                }
                this.removeNetwork(server.name, domainName);
            }
            this.a3cmlConfig.removeDomain(domainName);
        }
        catch (UnknownDomainException unknownDomainException) {
            // empty catch block
        }
    }

    public void removeNetwork(String serverName, String domainName) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.removeNetwork(" + serverName + ',' + domainName + ')'));
        }
        this.checkStatus(1);
        A3CMLServer server = this.a3cmlConfig.getServer(serverName);
        server.removeNetwork(domainName);
        if (server.sid == AgentServer.getServerId()) {
            this.stopScript.addElement(new StopNetworkCmd(domainName));
        }
    }

    public void removeServer(String serverName) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.removeServer(" + serverName + ')'));
        }
        this.checkStatus(1);
        try {
            A3CMLServer server = this.a3cmlConfig.getServer(serverName);
            ServerDesc servDesc = AgentServer.getServerDesc(server.sid);
            this.removeServer(servDesc);
        }
        catch (UnknownServerException unknownServerException) {
            // empty catch block
        }
    }

    public void removeServer(short serverId) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.removeServer(" + serverId + ')'));
        }
        try {
            this.checkStatus(1);
            ServerDesc servDesc = AgentServer.getServerDesc(serverId);
            this.removeServer(servDesc);
        }
        catch (UnknownServerException unknownServerException) {
            // empty catch block
        }
    }

    private void removeServer(ServerDesc servDesc) throws Exception {
        if (servDesc.sid == AgentServer.getServerId()) {
            throw new Exception("Can't remove local server");
        }
        this.deleteServer(servDesc);
        this.a3cmlConfig.removeServer(servDesc.sid);
    }

    private void deleteServer(ServerDesc servDesc) throws Exception {
        if (servDesc.domain instanceof Network) {
            ((Network)servDesc.domain).delServer(servDesc.sid);
        }
        AgentServer.removeServerDesc(servDesc.sid);
        Enumeration e = AgentServer.elementsServerDesc();
        while (e.hasMoreElements()) {
            ServerDesc sd = (ServerDesc)e.nextElement();
            if (sd.gateway != servDesc.sid) continue;
            sd.gateway = (short)-1;
            sd.domain = null;
        }
    }

    public void removeService(String serverName, String serviceClassName) throws Exception {
        this.checkStatus(1);
        A3CMLServer server = this.a3cmlConfig.getServer(serverName);
        server.removeService(serviceClassName);
    }

    private void stopNetwork(String domainName) throws Exception {
        if (AgentServer.getConsumer(domainName) != null) {
            AgentServer.removeConsumer(domainName);
        }
    }

    private void stopService(String serviceClassName) throws Exception {
        ServiceManager.stop(serviceClassName);
    }

    private void startNetwork(String domainName) throws Exception {
        Network network;
        A3CMLServer a3cmlServer;
        A3CMLNetwork a3cmlNetwork;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.startNetwork(" + domainName + ')'));
        }
        if ((a3cmlNetwork = (a3cmlServer = this.a3cmlConfig.getServer(AgentServer.getServerId())).getNetwork(domainName)) == null) {
            throw new Exception("Unknown network " + domainName);
        }
        try {
            network = (Network)AgentServer.getConsumer(domainName);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            A3CMLDomain a3cmlDomain = this.a3cmlConfig.getDomain(domainName);
            network = (Network)Class.forName(a3cmlDomain.network).newInstance();
            short[] domainSids = new short[a3cmlDomain.servers.size()];
            for (int i = 0; i < domainSids.length; ++i) {
                domainSids[i] = ((A3CMLServer)a3cmlDomain.servers.elementAt((int)i)).sid;
            }
            AgentServer.addConsumer(domainName, network);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> init network " + a3cmlDomain.name + ',' + a3cmlNetwork.port));
            }
            network.init(a3cmlDomain.name, a3cmlNetwork.port, domainSids);
        }
        network.start();
    }

    private void reconfigureServerNetwork(String domainName, Integer port) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.reconfigureServerNetwork(" + domainName + ',' + port + ')'));
        }
        Network network = (Network)AgentServer.getConsumer(domainName);
        network.stop();
        if (port != null) {
            network.setPort(port);
        }
        network.setProperties();
        network.start();
    }

    private void reconfigureClientNetwork(short sid, String domainName, Integer port) throws Exception {
        Network network;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.reconfigureClientNetwork(" + sid + ',' + domainName + ',' + port + ')'));
        }
        A3CMLServer a3cmlServer = this.a3cmlConfig.getServer(sid);
        ServerDesc serverDesc = AgentServer.getServerDesc(sid);
        if (port != null && domainName.equals(serverDesc.getDomainName())) {
            serverDesc.updateSockAddr(serverDesc.getHostname(), port);
        }
        try {
            network = (Network)AgentServer.getConsumer(domainName);
        }
        catch (Exception exc) {
            network = null;
        }
        if (network != null) {
            network.setProperties();
        }
    }

    private void startService(String serviceClassName, String args) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.startService(" + serviceClassName + ',' + args + ')'));
        }
        A3CMLServer a3cmlServer = this.a3cmlConfig.getServer(AgentServer.getServerId());
        ServiceManager.register(serviceClassName, args);
        ServiceDesc desc = (ServiceDesc)ServiceManager.manager.registry.get(serviceClassName);
        if (desc.running) {
            return;
        }
        ServiceManager.start(desc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startServer(short sid) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ConfigController.startServer(" + sid + ')'));
        }
        A3CMLServer server = this.a3cmlConfig.getServer(sid);
        ServerDesc desc = AgentServer.getServerDesc(sid);
        AgentServer.initServerDesc(desc, server);
        if (desc.gateway == desc.sid) {
            if (!(desc.domain instanceof Network)) throw new Error("Unknown gateway type: " + desc.domain);
            ((Network)desc.domain).addServer(server.sid);
            return;
        } else {
            if (!logger.isLoggable(BasicLevel.DEBUG)) return;
            logger.log(BasicLevel.DEBUG, (Object)(" -> desc = " + desc));
        }
    }

    static class ReconfigureServerNetworkCmd {
        public String domainName;
        public Integer port;

        public ReconfigureServerNetworkCmd(String domainName, Integer port) {
            this.domainName = domainName;
            this.port = port;
        }
    }

    static class ReconfigureClientNetworkCmd {
        public short sid;
        public String domainName;
        public Integer port;

        public ReconfigureClientNetworkCmd(short sid, String domainName, Integer port) {
            this.sid = sid;
            this.domainName = domainName;
            this.port = port;
        }
    }

    static class StopNetworkCmd {
        public String domainName;

        public StopNetworkCmd(String domainName) {
            this.domainName = domainName;
        }
    }

    static class StartNetworkCmd {
        public String domainName;

        public StartNetworkCmd(String domainName) {
            this.domainName = domainName;
        }
    }

    static class StartServiceCmd {
        public String serviceClassName;
        public String args;

        public StartServiceCmd(String serviceClassName, String args) {
            this.serviceClassName = serviceClassName;
            this.args = args;
        }
    }

    static class StartServerCmd {
        public short sid;

        public StartServerCmd(short sid) {
            this.sid = sid;
        }
    }

    public static class Status {
        public static final int FREE = 0;
        public static final int CONFIG = 1;
        public static String[] names = new String[]{"FREE", "CONFIG"};

        public static String toString(int status) {
            return names[status];
        }
    }
}

