/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.HttpNetworkMBean;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.StreamNetwork;
import fr.dyade.aaa.util.Daemon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class HttpNetwork
extends StreamNetwork
implements HttpNetworkMBean {
    private InetAddress proxy = null;
    String proxyhost = null;
    int proxyport = 0;
    protected long activationPeriod = 10000L;
    int NbDaemon = 1;
    ServerDesc server = null;
    Daemon[] dmon = null;

    public String getProxyhost() {
        return this.proxyhost;
    }

    public long getProxyport() {
        return this.proxyport;
    }

    public long getActivationPeriod() {
        return this.activationPeriod;
    }

    public void setActivationPeriod(long activationPeriod) {
        this.activationPeriod = activationPeriod;
    }

    public long getNbDaemon() {
        return this.NbDaemon;
    }

    public void init(String name, int port, short[] servers) throws Exception {
        super.init(name, port, servers);
        this.activationPeriod = Long.getLong("ActivationPeriod", this.activationPeriod);
        this.activationPeriod = Long.getLong(name + ".ActivationPeriod", this.activationPeriod);
        this.NbDaemon = Integer.getInteger("NbDaemon", this.NbDaemon);
        this.NbDaemon = Integer.getInteger(name + ".NbDaemon", this.NbDaemon);
        this.proxyhost = System.getProperty("proxyhost");
        this.proxyhost = System.getProperty(name + ".proxyhost", this.proxyhost);
        if (this.proxyhost != null) {
            this.proxyport = Integer.getInteger("proxyport", 8080);
            this.proxyport = Integer.getInteger(name + ".proxyport", this.proxyport);
            this.proxy = InetAddress.getByName(this.proxyhost);
        }
    }

    public void start() throws Exception {
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", starting"));
        try {
            if (this.isRunning()) {
                return;
            }
            for (int i = 0; i < this.servers.length; ++i) {
                this.server = AgentServer.getServerDesc(this.servers[i]);
                if (this.server.getServerId() != AgentServer.getServerId() && this.server.getPort() > 0) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", server=" + this.server));
                    break;
                }
                this.server = null;
            }
            if (this.port != 0) {
                this.dmon = new Daemon[this.NbDaemon];
                ServerSocket listen = this.createServerSocket();
                for (int i = 0; i < this.NbDaemon; ++i) {
                    this.dmon[i] = new NetServerIn(this.getName() + '.' + i, listen, this.logmon);
                }
            } else {
                this.dmon = new Daemon[1];
                this.dmon[0] = new NetServerOut(this.getName(), this.logmon);
            }
            for (int i = 0; i < this.dmon.length; ++i) {
                this.dmon[i].start();
            }
        }
        catch (IOException exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't start"), (Throwable)exc);
            throw exc;
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", started"));
    }

    public void wakeup() {
    }

    public void stop() {
        if (this.dmon != null) {
            for (int i = 0; i < this.dmon.length; ++i) {
                this.dmon[i].stop();
            }
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stopped"));
    }

    public boolean isRunning() {
        if (this.dmon != null) {
            for (int i = 0; i < this.dmon.length; ++i) {
                if (!this.dmon[i].isRunning()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(super.toString()).append("\n\t");
        if (this.dmon != null) {
            for (int i = 0; i < this.dmon.length; ++i) {
                strbuf.append(this.dmon[i].toString()).append("\n\t");
            }
        }
        return strbuf.toString();
    }

    protected String readLine(InputStream is, byte[] buf) throws IOException {
        int i = 0;
        while ((buf[i++] = (byte)is.read()) != -1) {
            if (buf[i - 1] != 10 || buf[i - 2] != 13) continue;
            i -= 2;
            break;
        }
        if (i > 0) {
            return new String(buf, 0, i);
        }
        return null;
    }

    protected void sendRequest(Message msg, OutputStream os, MessageOutputStream nos, int ack, long currentTimeMillis) throws Exception {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("PUT ");
        if (this.proxy != null) {
            strbuf.append("http://").append(this.server.getHostname()).append(':').append(this.server.getPort());
        }
        strbuf.append("/msg?from=").append(AgentServer.getServerId());
        strbuf.append("&stamp=");
        if (msg != null) {
            strbuf.append(msg.getStamp());
        } else {
            strbuf.append("-1");
        }
        strbuf.append(" HTTP/1.1");
        nos.writeMessage(msg, ack, currentTimeMillis);
        if (this.proxy != null) {
            strbuf.append("\r\nHost: ").append(this.server.getHostname());
        }
        strbuf.append("\r\nUser-Agent: ScalAgent 1.0\r\nAccept: image/jpeg;q=0.2\r\nAccept-Language: fr, en-us;q=0.50\r\nAccept-Encoding: gzip;q=0.9\r\nAccept-Charset: ISO-8859-1, utf-8;q=0.66\r\nCache-Control: no-cache\r\nCache-Control: no-store\r\nKeep-Alive: 300\r\nConnection: keep-alive\r\nProxy-Connection: keep-alive\r\nPragma: no-cache\r\n");
        strbuf.append("Content-Length: ").append(nos.size());
        strbuf.append("\r\nContent-Type: image/jpeg\r\n");
        strbuf.append("\r\n");
        os.write(strbuf.toString().getBytes());
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.name + ", writes:" + nos.size()));
        }
        nos.writeTo(os);
        nos.reset();
        os.flush();
    }

    protected short getRequest(InputStream is, MessageInputStream nis, byte[] buf) throws Exception {
        String line = null;
        line = this.readLine(is, buf);
        if (line == null || !line.startsWith("GET ") && !line.startsWith("PUT ")) {
            throw new Exception("Bad request: " + line);
        }
        int idx1 = line.indexOf("?from=");
        if (idx1 == -1) {
            throw new Exception("Bad request: " + line);
        }
        int idx2 = line.indexOf("&", idx1);
        if (idx2 == -1) {
            throw new Exception("Bad request: " + line);
        }
        short from = Short.parseShort(line.substring(idx1 + 6, idx2));
        int length = 0;
        while (line != null) {
            line = this.readLine(is, buf);
            if (line == null || !line.startsWith("Content-Length: ")) continue;
            length = Integer.parseInt(line.substring(16));
            if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.name + ", length:" + length));
        }
        if (nis.readFrom(is) != length) {
            this.logmon.log(BasicLevel.WARN, (Object)(this.name + "Bad request length: " + length));
        }
        return from;
    }

    protected void sendReply(Message msg, OutputStream os, MessageOutputStream nos, int ack, long currentTimeMillis) throws Exception {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("HTTP/1.1 200 OK\r\n");
        nos.writeMessage(msg, ack, currentTimeMillis);
        strbuf.append("Date: ").append("Fri, 21 Feb 2003 14:30:51 GMT");
        strbuf.append("\r\nServer: ScalAgent 1.0\r\nLast-Modified: ").append("Wed, 19 Apr 2000 08:16:28 GMT");
        strbuf.append("\r\nCache-Control: no-cache\r\nCache-Control: no-store\r\nAccept-Ranges: bytes\r\nKeep-Alive: timeout=15, max=100\r\nConnection: Keep-Alive\r\nProxy-Connection: Keep-Alive\r\nPragma: no-cache\r\n");
        strbuf.append("Content-Length: ").append(nos.size());
        strbuf.append("\r\nContent-Type: image/gif\r\n");
        strbuf.append("\r\n");
        os.write(strbuf.toString().getBytes());
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.name + ", writes:" + nos.size()));
        }
        nos.writeTo(os);
        nos.reset();
        os.flush();
    }

    protected void getReply(InputStream is, MessageInputStream nis, byte[] buf) throws Exception {
        String line = null;
        line = this.readLine(is, buf);
        if (line == null || !line.equals("HTTP/1.1 200 OK") && !line.equals("HTTP/1.1 204 No Content")) {
            throw new Exception("Bad reply: " + line);
        }
        int length = 0;
        while (line != null) {
            line = this.readLine(is, buf);
            if (line == null || !line.startsWith("Content-Length: ")) continue;
            length = Integer.parseInt(line.substring(16));
            if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.name + ", length:" + length));
        }
        if (nis.readFrom(is) != length) {
            this.logmon.log(BasicLevel.WARN, (Object)(this.name + "Bad reply length: " + length));
        }
    }

    protected int handle(Message msgout, MessageInputStream nis) throws Exception {
        int ack = nis.getAckStamp();
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", handle: " + msgout + ", ack=" + ack));
        }
        if (msgout != null && msgout.stamp == ack) {
            AgentServer.getTransaction().begin();
            this.qout.removeMessage(msgout);
            msgout.delete();
            msgout.free();
            AgentServer.getTransaction().commit(true);
        }
        Message msg = nis.getMessage();
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", get: " + msg));
        }
        if (msg != null) {
            ack = msg.stamp;
            this.testBootTS(msg.getSource(), nis.getBootTS());
            this.deliver(msg);
            return ack;
        }
        return -1;
    }

    Socket createTunnelSocket(InetAddress host, int port, InetAddress proxy, int proxyport) throws IOException {
        return this.createSocket(proxy, proxyport);
    }

    final class MessageOutputStream
    extends ByteArrayOutputStream {
        private ObjectOutputStream oos;

        MessageOutputStream() throws IOException {
            super(256);
            this.oos = null;
            this.oos = new ObjectOutputStream(this);
            this.count = 0;
            this.buf[37] = -84;
            this.buf[38] = -19;
            this.buf[39] = 0;
            this.buf[40] = 5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeMessage(Message msg, int ack, long currentTimeMillis) throws IOException {
            this.buf[4] = (byte)(HttpNetwork.this.getBootTS() >>> 24);
            this.buf[5] = (byte)(HttpNetwork.this.getBootTS() >>> 16);
            this.buf[6] = (byte)(HttpNetwork.this.getBootTS() >>> 8);
            this.buf[7] = (byte)(HttpNetwork.this.getBootTS() >>> 0);
            this.buf[8] = (byte)(ack >>> 24);
            this.buf[9] = (byte)(ack >>> 16);
            this.buf[10] = (byte)(ack >>> 8);
            this.buf[11] = (byte)(ack >>> 0);
            this.count = 12;
            if (msg != null) {
                int idx = msg.writeToBuf(this.buf, 12);
                this.buf[idx++] = (byte)((msg.not.persistent ? 1 : 0) | (msg.not.detachable ? 16 : 0));
                this.count = 41;
                try {
                    if (msg.not.expiration > 0L) {
                        msg.not.expiration -= currentTimeMillis;
                    }
                    this.oos.writeObject(msg.not);
                    this.oos.reset();
                    this.oos.flush();
                }
                finally {
                    if (msg.not != null && msg.not.expiration > 0L) {
                        msg.not.expiration += currentTimeMillis;
                    }
                }
            }
            this.buf[0] = (byte)(this.count >>> 24);
            this.buf[1] = (byte)(this.count >>> 16);
            this.buf[2] = (byte)(this.count >>> 8);
            this.buf[3] = (byte)(this.count >>> 0);
        }
    }

    final class MessageInputStream
    extends ByteArrayInputStream {
        int msgLen;
        int msgBoot;
        int msgAck;
        Message msg;

        MessageInputStream() {
            super(new byte[256]);
            this.msg = null;
        }

        private void readFully(InputStream is, int length) throws IOException {
            this.count = 0;
            if (length > this.buf.length) {
                this.buf = new byte[length];
            }
            int nb = -1;
            do {
                nb = is.read(this.buf, this.count, length - this.count);
                if (HttpNetwork.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    HttpNetwork.this.logmon.log(BasicLevel.DEBUG, (Object)(HttpNetwork.this.getName() + ", reads:" + nb));
                }
                if (nb < 0) {
                    throw new EOFException();
                }
                this.count += nb;
            } while (this.count != length);
            this.pos = 0;
        }

        int readFrom(InputStream is) throws Exception {
            this.readFully(is, 12);
            this.msgLen = ((this.buf[0] & 0xFF) << 24) + ((this.buf[1] & 0xFF) << 16) + ((this.buf[2] & 0xFF) << 8) + ((this.buf[3] & 0xFF) << 0);
            this.msgBoot = ((this.buf[4] & 0xFF) << 24) + ((this.buf[5] & 0xFF) << 16) + ((this.buf[6] & 0xFF) << 8) + ((this.buf[7] & 0xFF) << 0);
            this.msgAck = ((this.buf[8] & 0xFF) << 24) + ((this.buf[9] & 0xFF) << 16) + ((this.buf[10] & 0xFF) << 8) + ((this.buf[11] & 0xFF) << 0);
            if (this.msgLen > 36) {
                this.msg = Message.alloc();
                this.readFully(is, 25);
                int idx = this.msg.readFromBuf(this.buf, 0);
                boolean persistent = (this.buf[idx] & 1) != 0;
                boolean detachable = (this.buf[idx] & 0x10) != 0;
                this.readFully(is, this.msgLen - 37);
                ObjectInputStream ois = new ObjectInputStream(this);
                this.msg.not = (Notification)ois.readObject();
                if (this.msg.not.expiration > 0L) {
                    this.msg.not.expiration += System.currentTimeMillis();
                }
                this.msg.not.persistent = persistent;
                this.msg.not.detachable = detachable;
                this.msg.not.detached = false;
                return this.msgLen;
            }
            this.msg = null;
            return 12;
        }

        int getLength() {
            return this.msgLen;
        }

        int getBootTS() {
            return this.msgBoot;
        }

        int getAckStamp() {
            return this.msgAck;
        }

        Message getMessage() {
            return this.msg;
        }
    }

    final class NetServerIn
    extends Daemon {
        ServerSocket listen;
        Socket socket;
        InputStream is;
        OutputStream os;
        MessageInputStream nis;
        MessageOutputStream nos;

        NetServerIn(String name, ServerSocket listen, Logger logmon) throws IOException {
            super(name + ".NetServerIn");
            this.listen = null;
            this.socket = null;
            this.is = null;
            this.os = null;
            this.nis = null;
            this.nos = null;
            this.listen = listen;
            this.logmon = logmon;
            this.nis = new MessageInputStream();
            this.nos = new MessageOutputStream();
        }

        protected void open(Socket socket) throws IOException {
            HttpNetwork.this.setSocketOption(socket);
            this.os = socket.getOutputStream();
            this.is = socket.getInputStream();
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connected"));
            }
        }

        protected void close() {
            try {
                this.os.close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.os = null;
            try {
                this.is.close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.is = null;
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }

        protected void shutdown() {
            this.close();
            try {
                this.listen.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listen = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message msgout = null;
            int ack = -1;
            byte[] buf = new byte[120];
            try {
                while (this.running) {
                    this.canStop = true;
                    try {
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting connection"));
                        }
                        this.socket = this.listen.accept();
                        this.open(this.socket);
                        msgout = null;
                        short from = HttpNetwork.this.getRequest(this.is, this.nis, buf);
                        long currentTimeMillis = System.currentTimeMillis();
                        do {
                            this.canStop = false;
                            ack = HttpNetwork.this.handle(msgout, this.nis);
                            this.canStop = true;
                            while ((msgout = HttpNetwork.this.qout.getMessageTo(from)) != null && msgout.not.expiration > 0L && msgout.not.expiration < currentTimeMillis) {
                                if (msgout.not.deadNotificationAgentId != null) {
                                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": forward expired notification " + msgout.from + ", " + msgout.not + " to " + msgout.not.deadNotificationAgentId));
                                    }
                                    ExpiredNot expiredNot = new ExpiredNot(msgout.not);
                                    AgentServer.getTransaction().begin();
                                    Channel.post(Message.alloc(AgentId.localId, msgout.not.deadNotificationAgentId, expiredNot));
                                    Channel.validate();
                                    AgentServer.getTransaction().commit(true);
                                } else if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": removes expired notification " + msgout.from + ", " + msgout.not));
                                }
                                HttpNetwork.this.qout.removeMessage(msgout);
                                msgout.delete();
                                msgout.free();
                            }
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", sendReply: " + msgout));
                            }
                            HttpNetwork.this.sendReply(msgout, this.os, this.nos, ack, currentTimeMillis);
                            HttpNetwork.this.getRequest(this.is, this.nis, buf);
                        } while (this.running);
                    }
                    catch (Exception exc) {
                        if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        this.logmon.log(BasicLevel.DEBUG, (Object)", connection closed", (Throwable)exc);
                    }
                    finally {
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)", connection ends");
                        }
                        this.close();
                    }
                }
            }
            finally {
                this.logmon.log(BasicLevel.WARN, (Object)", exited");
                this.finish();
            }
        }
    }

    final class NetServerOut
    extends Daemon {
        Socket socket;
        InputStream is;
        OutputStream os;
        MessageInputStream nis;
        MessageOutputStream nos;

        NetServerOut(String name, Logger logmon) throws IOException {
            super(name + ".NetServerOut");
            this.socket = null;
            this.is = null;
            this.os = null;
            this.nis = null;
            this.nos = null;
            this.logmon = logmon;
            this.nis = new MessageInputStream();
            this.nos = new MessageOutputStream();
        }

        protected void open() throws IOException {
            this.socket = null;
            if (HttpNetwork.this.proxy == null) {
                this.socket = HttpNetwork.this.createSocket(HttpNetwork.this.server);
            } else {
                try {
                    this.socket = HttpNetwork.this.createTunnelSocket(HttpNetwork.this.server.getAddr(), HttpNetwork.this.server.getPort(), HttpNetwork.this.proxy, HttpNetwork.this.proxyport);
                }
                catch (IOException exc) {
                    this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused, reset addr"));
                    HttpNetwork.this.server.resetAddr();
                    HttpNetwork.this.proxy = InetAddress.getByName(HttpNetwork.this.proxyhost);
                    this.socket = HttpNetwork.this.createTunnelSocket(HttpNetwork.this.server.getAddr(), HttpNetwork.this.server.getPort(), HttpNetwork.this.proxy, HttpNetwork.this.proxyport);
                }
            }
            HttpNetwork.this.setSocketOption(this.socket);
            this.os = this.socket.getOutputStream();
            this.is = this.socket.getInputStream();
        }

        protected void close() {
            try {
                this.os.close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.os = null;
            try {
                this.is.close();
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.is = null;
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }

        protected void shutdown() {
            this.thread.interrupt();
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message msgout = null;
            int ack = -1;
            byte[] buf = new byte[120];
            try {
                while (this.running) {
                    this.canStop = true;
                    try {
                        block20: {
                            try {
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                                }
                                msgout = HttpNetwork.this.qout.get(HttpNetwork.this.activationPeriod);
                            }
                            catch (InterruptedException exc) {
                                if (!this.logmon.isLoggable(BasicLevel.DEBUG)) break block20;
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", interrupted"));
                            }
                        }
                        this.open();
                        do {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", sendRequest: " + msgout + ", ack=" + ack));
                            }
                            long currentTimeMillis = System.currentTimeMillis();
                            while (msgout != null && msgout.not.expiration > 0L && msgout.not.expiration < currentTimeMillis) {
                                if (msgout.not.deadNotificationAgentId != null) {
                                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": forward expired notification " + msgout.from + ", " + msgout.not + " to " + msgout.not.deadNotificationAgentId));
                                    }
                                    ExpiredNot expiredNot = new ExpiredNot(msgout.not);
                                    AgentServer.getTransaction().begin();
                                    Channel.post(Message.alloc(AgentId.localId, msgout.not.deadNotificationAgentId, expiredNot));
                                    Channel.validate();
                                    AgentServer.getTransaction().commit(true);
                                } else if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": removes expired notification " + msgout.from + ", " + msgout.not));
                                }
                                HttpNetwork.this.qout.removeMessage(msgout);
                                msgout.delete();
                                msgout.free();
                                msgout = HttpNetwork.this.qout.get(0L);
                            }
                            HttpNetwork.this.sendRequest(msgout, this.os, this.nos, ack, currentTimeMillis);
                            HttpNetwork.this.getReply(this.is, this.nis, buf);
                            this.canStop = false;
                            ack = HttpNetwork.this.handle(msgout, this.nis);
                            this.canStop = true;
                            msgout = HttpNetwork.this.qout.get(0L);
                        } while (this.running && (msgout != null || ack != -1));
                    }
                    catch (Exception exc) {
                        if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection closed"), (Throwable)exc);
                    }
                    finally {
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection ends"));
                        }
                        this.close();
                    }
                }
            }
            finally {
                this.logmon.log(BasicLevel.WARN, (Object)", exited");
                this.finish();
            }
        }
    }
}

