/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.Repository;
import fr.dyade.aaa.util.StartWithFilter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

final class FileRepository
implements Repository {
    File dir = null;
    private int nbsaved = 0;
    private int nbdeleted = 0;
    private int baddeleted = 0;
    private int nbloaded = 0;

    public int getNbSavedObjects() {
        return this.nbsaved;
    }

    public int getNbDeletedObjects() {
        return this.nbdeleted;
    }

    public int getNbBadDeletedObjects() {
        return this.baddeleted;
    }

    public int getNbLoadedObjects() {
        return this.nbloaded;
    }

    FileRepository() {
    }

    public void init(File dir) throws IOException {
        this.dir = dir;
    }

    public String[] list(String prefix) throws IOException {
        return this.dir.list(new StartWithFilter(prefix));
    }

    public void save(String dirName, String name, byte[] content) throws IOException {
        File file;
        if (dirName == null) {
            file = new File(this.dir, name);
        } else {
            File parentDir = new File(this.dir, dirName);
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            file = new File(parentDir, name);
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(content);
        fos.getFD().sync();
        fos.close();
        ++this.nbsaved;
    }

    public byte[] load(String dirName, String name) throws IOException {
        int ret;
        File file;
        if (dirName == null) {
            file = new File(this.dir, name);
        } else {
            File parentDir = new File(this.dir, dirName);
            file = new File(parentDir, name);
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] buf = new byte[(int)file.length()];
        for (int nb = 0; nb < buf.length; nb += ret) {
            ret = fis.read(buf, nb, buf.length - nb);
            if (ret != -1) continue;
            throw new EOFException();
        }
        fis.close();
        ++this.nbloaded;
        return buf;
    }

    public void delete(String dirName, String name) throws IOException {
        if (dirName == null) {
            if (!new File(this.dir, name).delete()) {
                ++this.baddeleted;
            }
        } else {
            File parentDir = new File(this.dir, dirName);
            File file = new File(parentDir, name);
            if (!new File(parentDir, name).delete()) {
                ++this.baddeleted;
            }
            this.deleteDir(parentDir);
        }
        ++this.nbdeleted;
    }

    private final void deleteDir(File dir) {
        String[] children = dir.list();
        if (children != null && children.length == 0) {
            dir.delete();
            if (dir.getAbsolutePath().length() > this.dir.getAbsolutePath().length()) {
                this.deleteDir(dir.getParentFile());
            }
        }
    }

    public void commit() throws IOException {
    }

    public void close() throws IOException {
    }
}

