/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.util.HashMap;
import javax.security.jacc.HttpMethodSpec;
import javax.security.jacc.URLPatternSpec;
import javax.servlet.http.HttpServletRequest;

public final class WebUserDataPermission
extends Permission
implements Serializable {
    private static String[] transportKeys = new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"};
    private static HashMap transportHash = new HashMap();
    private static int TT_NONE;
    private static int TT_CONFIDENTIAL;
    private transient URLPatternSpec urlPatternSpec = null;
    private transient HttpMethodSpec methodSpec;
    private transient int transportType;
    private transient int hashCodeValue = 0;
    private static final transient String EMPTY_STRING = "";
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields;

    public WebUserDataPermission(String name, String actions2) {
        super(name);
        this.urlPatternSpec = new URLPatternSpec(name);
        this.parseActions(actions2);
    }

    public WebUserDataPermission(String urlPatternSpec, String[] HTTPMethods, String transportType) {
        super(urlPatternSpec);
        this.urlPatternSpec = new URLPatternSpec(urlPatternSpec);
        this.transportType = TT_NONE;
        if (transportType != null) {
            Integer bit = (Integer)transportHash.get(transportType);
            if (bit == null) {
                throw new IllegalArgumentException("illegal transport value");
            }
            this.transportType = bit;
        }
        this.methodSpec = HttpMethodSpec.getSpec(HTTPMethods);
    }

    public WebUserDataPermission(HttpServletRequest request) {
        super(WebUserDataPermission.getUriMinusContextPath(request));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
        this.transportType = request.isSecure() ? TT_CONFIDENTIAL : TT_NONE;
        this.methodSpec = HttpMethodSpec.getSpec(request.getMethod());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission that = (WebUserDataPermission)o;
        if (this.transportType != that.transportType) {
            return false;
        }
        if (!this.methodSpec.equals(that.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.equals(that.urlPatternSpec);
    }

    public String getActions() {
        String hActions = this.methodSpec.getActions();
        String result = this.transportType == TT_NONE && hActions == null ? null : (this.transportType == TT_NONE ? hActions : (hActions == null ? ":" + transportKeys[this.transportType] : hActions + ":" + transportKeys[this.transportType]));
        return result;
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String hashInput = new String(this.urlPatternSpec.toString() + " " + this.methodSpec.hashCode() + ":" + this.transportType);
            this.hashCodeValue = hashInput.hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission that = (WebUserDataPermission)permission;
        if (this.transportType != TT_NONE && this.transportType != that.transportType) {
            return false;
        }
        if (!this.methodSpec.implies(that.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.implies(that.urlPatternSpec);
    }

    private static String getUriMinusContextPath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (uri != null) {
            int contextLength;
            String contextPath = request.getContextPath();
            int n = contextLength = contextPath == null ? 0 : contextPath.length();
            if (contextLength > 0) {
                uri = uri.substring(contextLength);
            }
            if (uri.equals("/")) {
                uri = EMPTY_STRING;
            }
        } else {
            uri = EMPTY_STRING;
        }
        return uri;
    }

    private void parseActions(String actions2) {
        this.transportType = TT_NONE;
        if (actions2 == null || actions2.equals(EMPTY_STRING)) {
            this.methodSpec = HttpMethodSpec.getSpec((String)null);
        } else {
            int colon = actions2.indexOf(58);
            if (colon < 0) {
                this.methodSpec = HttpMethodSpec.getSpec(actions2);
            } else {
                this.methodSpec = colon == 0 ? HttpMethodSpec.getSpec((String)null) : HttpMethodSpec.getSpec(actions2.substring(0, colon));
                Integer bit = (Integer)transportHash.get(actions2.substring(colon + 1));
                if (bit == null) {
                    throw new IllegalArgumentException("illegal transport value");
                }
                this.transportType = bit;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.parseActions((String)s.readFields().get("actions", null));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.putFields().put("actions", this.getActions());
        s.writeFields();
    }

    static {
        for (int i = 0; i < transportKeys.length; ++i) {
            transportHash.put(transportKeys[i], new Integer(i));
        }
        TT_NONE = (Integer)transportHash.get("NONE");
        TT_CONFIDENTIAL = (Integer)transportHash.get("CONFIDENTIAL");
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
    }
}

