/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeletePublisher;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class DeletePublisherFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$function$DeletePublisherFunction == null ? (class$org$apache$juddi$function$DeletePublisherFunction = DeletePublisherFunction.class$("org.apache.juddi.function.DeletePublisherFunction")) : class$org$apache$juddi$function$DeletePublisherFunction);
    static /* synthetic */ Class class$org$apache$juddi$function$DeletePublisherFunction;

    public DeletePublisherFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        DeletePublisher request = (DeletePublisher)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector publisherIDVector = request.getPublisherIDVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            if (!dataStore.isAdministrator(publisherID)) {
                throw new RegistryException("Invalid Operation, You must have administrative priveledges to delete a publisher account.");
            }
            for (i = 0; i < publisherIDVector.size(); ++i) {
                String pubID = (String)publisherIDVector.elementAt(i);
                if (pubID.equalsIgnoreCase(publisherID)) {
                    throw new RegistryException("Invalid Operation, A publisher cannot delete it's own publisher account.");
                }
                dataStore.deletePublisher(pubID);
            }
            for (i = 0; i < publisherIDVector.size(); ++i) {
                String tModelKey = (String)publisherIDVector.elementAt(i);
                dataStore.deleteTModel(tModelKey);
                log.info("Publisher '" + publisherID + "' deleted TModel with key: " + tModelKey);
            }
            dataStore.commit();
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
        Result result = new Result(0);
        result.setErrCode(Result.lookupErrCode(0));
        DispositionReport dispRpt = new DispositionReport();
        dispRpt.setGeneric(generic);
        dispRpt.setOperator(Config.getOperator());
        dispRpt.addResult(result);
        return dispRpt;
    }

    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

