/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.response.ServiceInfo;
import org.apache.ws.scout.registry.RegistryServiceImpl;
import org.apache.ws.scout.registry.infomodel.AssociationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.EmailAddressImpl;
import org.apache.ws.scout.registry.infomodel.ExternalIdentifierImpl;
import org.apache.ws.scout.registry.infomodel.ExternalLinkImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.LocalizedStringImpl;
import org.apache.ws.scout.registry.infomodel.OrganizationImpl;
import org.apache.ws.scout.registry.infomodel.PersonNameImpl;
import org.apache.ws.scout.registry.infomodel.PostalAddressImpl;
import org.apache.ws.scout.registry.infomodel.ServiceBindingImpl;
import org.apache.ws.scout.registry.infomodel.ServiceImpl;
import org.apache.ws.scout.registry.infomodel.SlotImpl;
import org.apache.ws.scout.registry.infomodel.SpecificationLinkImpl;
import org.apache.ws.scout.registry.infomodel.TelephoneNumberImpl;
import org.apache.ws.scout.registry.infomodel.UserImpl;
import org.apache.ws.scout.util.ScoutUddiJaxrHelper;

public abstract class LifeCycleManagerImpl
implements LifeCycleManager {
    protected final RegistryServiceImpl registry;

    public LifeCycleManagerImpl(RegistryService registry) {
        this.registry = (RegistryServiceImpl)registry;
    }

    public RegistryService getRegistryService() {
        return this.registry;
    }

    public Object createObject(String interfaceName) throws JAXRException {
        if ("Association".equals(interfaceName)) {
            return new AssociationImpl(this);
        }
        if ("AuditableEvent".equals(interfaceName)) {
            throw new UnsupportedCapabilityException();
        }
        if ("Classification".equals(interfaceName)) {
            return new ClassificationImpl(this);
        }
        if ("ClassificationScheme".equals(interfaceName)) {
            return new ClassificationSchemeImpl(this);
        }
        if ("Concept".equals(interfaceName)) {
            return new ConceptImpl(this);
        }
        if ("EmailAddress".equals(interfaceName)) {
            return new EmailAddressImpl();
        }
        if ("ExternalIdentifier".equals(interfaceName)) {
            return new ExternalIdentifierImpl(this);
        }
        if ("ExternalLink".equals(interfaceName)) {
            return new ExternalLinkImpl(this);
        }
        if ("ExtrinsicObject".equals(interfaceName)) {
            throw new UnsupportedCapabilityException();
        }
        if ("InternationalString".equals(interfaceName)) {
            return new InternationalStringImpl();
        }
        if ("Key".equals(interfaceName)) {
            return new KeyImpl();
        }
        if ("LocalizedString".equals(interfaceName)) {
            return new LocalizedStringImpl();
        }
        if ("Organization".equals(interfaceName)) {
            return new OrganizationImpl(this);
        }
        if ("PersonName".equals(interfaceName)) {
            return new PersonNameImpl();
        }
        if ("PostalAddress".equals(interfaceName)) {
            return new PostalAddressImpl(this.registry.getDefaultPostalScheme());
        }
        if ("RegistryEntry".equals(interfaceName)) {
            throw new UnsupportedCapabilityException();
        }
        if ("RegistryPackage".equals(interfaceName)) {
            throw new UnsupportedCapabilityException();
        }
        if ("Service".equals(interfaceName)) {
            return new ServiceImpl(this);
        }
        if ("ServiceBinding".equals(interfaceName)) {
            return new ServiceBindingImpl(this);
        }
        if ("Slot".equals(interfaceName)) {
            return new SlotImpl();
        }
        if ("SpecificationLink".equals(interfaceName)) {
            return new SpecificationLinkImpl(this);
        }
        if ("TelephoneNumber".equals(interfaceName)) {
            return new TelephoneNumberImpl();
        }
        if ("User".equals(interfaceName)) {
            return new UserImpl(this);
        }
        if ("Versionable".equals(interfaceName)) {
            throw new UnsupportedCapabilityException();
        }
        throw new InvalidRequestException("Unknown interface: " + interfaceName);
    }

    public Association createAssociation(RegistryObject targetObject, Concept associationType) throws JAXRException {
        Association assoc2 = (Association)this.createObject("Association");
        assoc2.setTargetObject(targetObject);
        assoc2.setAssociationType(associationType);
        return assoc2;
    }

    public Classification createClassification(Concept concept) throws JAXRException, InvalidRequestException {
        if (concept.getClassificationScheme() == null) {
            throw new InvalidRequestException("Concept is not under classification scheme");
        }
        Classification classify = (Classification)this.createObject("Classification");
        classify.setConcept(concept);
        return classify;
    }

    public Classification createClassification(ClassificationScheme scheme, InternationalString name, String value) throws JAXRException {
        Classification cl = (Classification)this.createObject("Classification");
        cl.setClassificationScheme(scheme);
        cl.setName(name);
        cl.setValue(value);
        ((ClassificationImpl)cl).setExternal(true);
        return cl;
    }

    public Classification createClassification(ClassificationScheme scheme, String name, String value) throws JAXRException {
        return this.createClassification(scheme, this.createInternationalString(name), value);
    }

    public ClassificationScheme createClassificationScheme(Concept concept) throws JAXRException, InvalidRequestException {
        if (concept.getParentConcept() != null || concept.getClassificationScheme() != null) {
            throw new InvalidRequestException("Concept has classificationscheme or has a parent");
        }
        ClassificationSchemeImpl cs = new ClassificationSchemeImpl(this);
        cs.addChildConcept(concept);
        return cs;
    }

    public ClassificationScheme createClassificationScheme(InternationalString name, InternationalString des) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl cs = new ClassificationSchemeImpl(this);
        cs.setName(name);
        cs.setDescription(des);
        return cs;
    }

    public ClassificationScheme createClassificationScheme(String name, String desc) throws JAXRException, InvalidRequestException {
        return this.createClassificationScheme(this.createInternationalString(name), this.createInternationalString(desc));
    }

    public Concept createConcept(RegistryObject parent, InternationalString name, String value) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(this);
        concept.setClassificationScheme((ClassificationScheme)parent);
        concept.setParent(parent);
        concept.setName(name);
        concept.setValue(value);
        return concept;
    }

    public Concept createConcept(RegistryObject parent, String name, String value) throws JAXRException {
        return this.createConcept(parent, this.createInternationalString(name), value);
    }

    public EmailAddress createEmailAddress(String address) throws JAXRException {
        return new EmailAddressImpl(address);
    }

    public EmailAddress createEmailAddress(String address, String type) throws JAXRException {
        return new EmailAddressImpl(address, type);
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme ids, InternationalString name, String value) throws JAXRException {
        return new ExternalIdentifierImpl(this, ids, name, value);
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme ids, String name, String value) throws JAXRException {
        return this.createExternalIdentifier(ids, this.createInternationalString(name), value);
    }

    public ExternalLink createExternalLink(String uri, InternationalString desc) throws JAXRException {
        ExternalLinkImpl ext = new ExternalLinkImpl(this);
        ext.setExternalURI(uri);
        ext.setDescription(desc);
        return ext;
    }

    public ExternalLink createExternalLink(String uri, String desc) throws JAXRException {
        return this.createExternalLink(uri, this.createInternationalString(desc));
    }

    public InternationalString createInternationalString() throws JAXRException {
        return new InternationalStringImpl();
    }

    public InternationalString createInternationalString(String value) throws JAXRException {
        return new InternationalStringImpl(Locale.getDefault(), value, "UTF-8");
    }

    public InternationalString createInternationalString(Locale locale, String value) throws JAXRException {
        return new InternationalStringImpl(locale, value, "UTF-8");
    }

    public Key createKey(String id) {
        return new KeyImpl(id);
    }

    public LocalizedString createLocalizedString(Locale locale, String value) throws JAXRException {
        return new LocalizedStringImpl(locale, value, "UTF-8");
    }

    public LocalizedString createLocalizedString(Locale locale, String value, String charsetName) throws JAXRException {
        return new LocalizedStringImpl(locale, value, charsetName);
    }

    public Organization createOrganization(InternationalString name) throws JAXRException {
        Organization org = (Organization)this.createObject("Organization");
        org.setName(name);
        return org;
    }

    public Organization createOrganization(String name) throws JAXRException {
        Organization org = (Organization)this.createObject("Organization");
        org.setName(this.createInternationalString(name));
        return org;
    }

    public PersonName createPersonName(String fullName) throws JAXRException {
        PersonName pn = (PersonName)this.createObject("PersonName");
        pn.setFullName(fullName);
        return pn;
    }

    public PostalAddress createPostalAddress(String streetNumber, String street, String city, String stateOrProvince, String country, String postalCode, String type) throws JAXRException {
        PostalAddressImpl post = new PostalAddressImpl();
        post.setStreetNumber(streetNumber);
        post.setStreet(street);
        post.setCity(city);
        post.setStateOrProvince(stateOrProvince);
        post.setCountry(country);
        post.setPostalCode(postalCode);
        post.setType(type);
        return post;
    }

    public Service createService(InternationalString name) throws JAXRException {
        Service ser = (Service)this.createObject("Service");
        ser.setName(name);
        return ser;
    }

    public Service createService(String name) throws JAXRException {
        return this.createService(this.createInternationalString(name));
    }

    public ServiceBinding createServiceBinding() throws JAXRException {
        return (ServiceBinding)this.createObject("ServiceBinding");
    }

    public Slot createSlot(String name, String value, String slotType) throws JAXRException {
        ArrayList<String> col = new ArrayList<String>();
        col.add(value);
        Slot slot = (Slot)this.createObject("Slot");
        slot.setName(name);
        slot.setValues(col);
        slot.setSlotType(slotType);
        return slot;
    }

    public Slot createSlot(String name, Collection values, String slotType) throws JAXRException {
        Slot slot = (Slot)this.createObject("Slot");
        slot.setName(name);
        slot.setValues(values);
        slot.setSlotType(slotType);
        return slot;
    }

    public SpecificationLink createSpecificationLink() throws JAXRException {
        return (SpecificationLink)this.createObject("SpecificationLink");
    }

    public TelephoneNumber createTelephoneNumber() throws JAXRException {
        return (TelephoneNumber)this.createObject("TelephoneNumber");
    }

    public User createUser() throws JAXRException {
        return (User)this.createObject("User");
    }

    public abstract BulkResponse saveObjects(Collection var1) throws JAXRException;

    public abstract BulkResponse deleteObjects(Collection var1, String var2) throws JAXRException;

    public ExtrinsicObject createExtrinsicObject(DataHandler repositoryItem) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public PersonName createPersonName(String firstName, String middleName, String lastName) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public RegistryPackage createRegistryPackage(InternationalString name) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public RegistryPackage createRegistryPackage(String name) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse deprecateObjects(Collection keys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse unDeprecateObjects(Collection keys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse deleteObjects(Collection keys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    Organization createOrganization(BusinessInfo info) throws JAXRException {
        String key = info.getBusinessKey();
        Vector names = info.getNameVector();
        Vector descriptions = info.getDescriptionVector();
        Vector serviceInfos = info.getServiceInfos().getServiceInfoVector();
        OrganizationImpl org = new OrganizationImpl(this);
        org.setKey(this.createKey(key));
        if (names != null && !names.isEmpty()) {
            org.setName(this.createInternationalString(((Name)names.get(0)).getValue()));
        }
        if (descriptions != null && !descriptions.isEmpty()) {
            org.setDescription(this.createInternationalString(((Description)descriptions.get(0)).getValue()));
        }
        if (serviceInfos != null && !serviceInfos.isEmpty()) {
            ArrayList<Service> services = new ArrayList<Service>(serviceInfos.size());
            for (int i = 0; i < serviceInfos.size(); ++i) {
                ServiceInfo serviceInfo = (ServiceInfo)serviceInfos.elementAt(i);
                services.add(this.createService(serviceInfo));
            }
            org.addServices(services);
        }
        return org;
    }

    Organization createOrganization(BusinessDetail detail) throws JAXRException {
        return ScoutUddiJaxrHelper.getOrganization(detail, (LifeCycleManager)this);
    }

    Service createService(ServiceInfo info) throws JAXRException {
        String key = info.getServiceKey();
        Vector names = info.getNameVector();
        ServiceImpl service = new ServiceImpl(this);
        service.setKey(this.createKey(key));
        if (!names.isEmpty()) {
            service.setName(this.createInternationalString(((Name)names.get(0)).getValue()));
        }
        return service;
    }
}

