/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;

public class ReadOnlyCache
implements CacheConcurrencyStrategy {
    private Cache cache;
    private static final Log log = LogFactory.getLog(ReadOnlyCache.class);

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public synchronized Object get(Object key, long timestamp) throws CacheException {
        Object result = this.cache.get(key);
        if (result != null && log.isDebugEnabled()) {
            log.debug("Cache hit: " + key);
        }
        return result;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object key, Object version2) {
        log.error("Application attempted to edit read only item: " + key);
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public synchronized boolean put(Object key, Object value, long timestamp, Object version2, Comparator versionComparator, boolean minimalPut) throws CacheException {
        if (minimalPut && this.cache.get(key) != null) {
            if (log.isDebugEnabled()) {
                log.debug("item already cached: " + key);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Caching: " + key);
        }
        this.cache.put(key, value);
        return true;
    }

    public void release(Object key, CacheConcurrencyStrategy.SoftLock lock) {
        log.error("Application attempted to edit read only item: " + key);
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn("could not destroy cache", e);
        }
    }

    public boolean afterUpdate(Object key, Object value, Object version2, CacheConcurrencyStrategy.SoftLock lock) throws CacheException {
        log.error("Application attempted to edit read only item: " + key);
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public boolean afterInsert(Object key, Object value, Object version2) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Caching after insert: " + key);
        }
        this.cache.update(key, value);
        return true;
    }

    public void evict(Object key) throws CacheException {
    }

    public boolean insert(Object key, Object value, Object currentVersion) {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) {
        log.error("Application attempted to edit read only item: " + key);
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public String toString() {
        return this.cache + "(read-only)";
    }
}

