/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.DestinationMBean;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.TemporaryQueue;
import org.objectweb.joram.client.jms.TemporaryTopic;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdministeredObject;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.admin.XmlSerializer;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.admin.CreateDestinationReply;
import org.objectweb.joram.shared.admin.CreateDestinationRequest;
import org.objectweb.joram.shared.admin.DeleteDestination;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettings;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettingsRep;
import org.objectweb.joram.shared.admin.Monitor_GetFreeAccess;
import org.objectweb.joram.shared.admin.Monitor_GetFreeAccessRep;
import org.objectweb.joram.shared.admin.Monitor_GetReaders;
import org.objectweb.joram.shared.admin.Monitor_GetStat;
import org.objectweb.joram.shared.admin.Monitor_GetStatRep;
import org.objectweb.joram.shared.admin.Monitor_GetUsersRep;
import org.objectweb.joram.shared.admin.Monitor_GetWriters;
import org.objectweb.joram.shared.admin.SetDestinationDMQ;
import org.objectweb.joram.shared.admin.SetReader;
import org.objectweb.joram.shared.admin.SetWriter;
import org.objectweb.joram.shared.admin.UnsetDestinationDMQ;
import org.objectweb.joram.shared.admin.UnsetReader;
import org.objectweb.joram.shared.admin.UnsetWriter;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class Destination
extends AdministeredObject
implements javax.jms.Destination,
DestinationMBean {
    protected String agentId;
    protected String adminName;
    private String type;
    public static final String QUEUE = "org.objectweb.joram.mom.dest.Queue";
    public static final String TOPIC = "org.objectweb.joram.mom.dest.Topic";
    public static final String DEAD_MQUEUE = "org.objectweb.joram.mom.dest.DeadMQueue";
    public static final String CLUSTER_QUEUE = "org.objectweb.joram.mom.dest.ClusterQueue";
    public static final String BRIDGE_QUEUE = "org.objectweb.joram.mom.dest.BridgeQueue";
    public static final String BRIDGE_TOPIC = "org.objectweb.joram.mom.dest.BridgeTopic";
    public static final String MAIL_QUEUE = "com.scalagent.joram.mom.dest.mail.JavaMailQueue";
    public static final String MAIL_TOPIC = "com.scalagent.joram.mom.dest.mail.JavaMailTopic";
    public static final String SCHEDULER_QUEUE = "com.scalagent.joram.mom.dest.scheduler.SchedulerQueue";

    public Destination() {
    }

    public Destination(String type) {
        this.type = type;
    }

    protected Destination(String name, String type) {
        this.agentId = name;
        this.type = type;
    }

    public String getName() {
        return this.agentId;
    }

    public final String getAdminName() {
        return this.adminName;
    }

    public final String getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Destination)) {
            return false;
        }
        return this.getName().equals(((Destination)obj).getName());
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.type).append(this.agentId);
        if (this.adminName != null) {
            strbuf.append('(').append(this.adminName).append(')');
        }
        return strbuf.toString();
    }

    public String toXml(int indent, int serverId) throws ConnectException, AdminException {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(XmlSerializer.indent(indent));
        if (this.getType().equals("queue")) {
            strbuf.append("<Queue ");
        } else if (this.getType().equals("topic")) {
            strbuf.append("<Topic ");
        } else {
            return "";
        }
        strbuf.append(XmlSerializer.xmlAttribute(this.getAdminName(), "name"));
        strbuf.append(XmlSerializer.xmlAttribute(String.valueOf(serverId), "serverId"));
        DeadMQueue dmq = this.getDMQ();
        if (dmq != null) {
            strbuf.append(XmlSerializer.xmlAttribute(dmq.getAdminName(), "dmq"));
            strbuf.append(XmlSerializer.xmlAttribute(String.valueOf(dmq.getThreshold()), "threshold"));
        }
        strbuf.append(">\n");
        indent += 2;
        if (this.isFreelyReadable()) {
            strbuf.append(XmlSerializer.indent(indent));
            strbuf.append("<freeReader/>\n");
        }
        if (this.isFreelyWriteable()) {
            strbuf.append(XmlSerializer.indent(indent));
            strbuf.append("<freeWriter/>\n");
        }
        List readers = this.getReaders();
        ListIterator iterator = readers.listIterator();
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            strbuf.append(XmlSerializer.indent(indent));
            strbuf.append("<reader ");
            strbuf.append(XmlSerializer.xmlAttribute(user.getName(), "user"));
            strbuf.append("/>\n");
        }
        List writers = this.getWriters();
        ListIterator iterator2 = writers.listIterator();
        while (iterator2.hasNext()) {
            User user = (User)iterator2.next();
            strbuf.append(XmlSerializer.indent(indent));
            strbuf.append("<writer ");
            strbuf.append(XmlSerializer.xmlAttribute(user.getName(), "user"));
            strbuf.append("/>\n");
        }
        strbuf.append(XmlSerializer.indent(indent));
        strbuf.append("<jndi ");
        strbuf.append(XmlSerializer.xmlAttribute(this.getAdminName(), "name"));
        strbuf.append("/>\n");
        strbuf.append(XmlSerializer.indent(indent -= 2));
        if (this.getType().equals("queue")) {
            strbuf.append("</Queue>\n");
        } else if (this.getType().equals("topic")) {
            strbuf.append("</Topic>\n");
        }
        return strbuf.toString();
    }

    public boolean isQueue() {
        return this instanceof javax.jms.Queue;
    }

    protected static void doCreate(int serverId, String name, String className, Properties props, Destination dest, String expectedType) throws ConnectException, AdminException {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("Destination.doCreate(" + serverId + ',' + name + ',' + className + ',' + props + ',' + dest + ',' + expectedType + ')'));
        }
        CreateDestinationRequest cdr = new CreateDestinationRequest(serverId, name, className, props, expectedType);
        CreateDestinationReply reply = (CreateDestinationReply)AdminModule.doRequest(cdr);
        dest.agentId = reply.getId();
        dest.adminName = name;
        dest.type = reply.getType();
    }

    public void delete() throws ConnectException, AdminException, JMSException {
        block3: {
            AdminModule.doRequest(new DeleteDestination(this.getName()));
            if (MXWrapper.mxserver != null) {
                StringBuffer buff = new StringBuffer();
                buff.append("type=");
                buff.append(this.getType());
                buff.append(",name=");
                buff.append(this.getAdminName());
                try {
                    MXWrapper.unregisterMBean("joramClient", buff.toString());
                }
                catch (Exception e) {
                    if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block3;
                    JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"unregisterMBean", (Throwable)e);
                }
            }
        }
    }

    public void setFreeReading() throws ConnectException, AdminException {
        AdminModule.doRequest(new SetReader(null, this.getName()));
    }

    public void setFreeWriting() throws ConnectException, AdminException {
        AdminModule.doRequest(new SetWriter(null, this.getName()));
    }

    public void unsetFreeReading() throws ConnectException, AdminException {
        AdminModule.doRequest(new UnsetReader(null, this.getName()));
    }

    public void unsetFreeWriting() throws ConnectException, AdminException {
        AdminModule.doRequest(new UnsetWriter(null, this.getName()));
    }

    public void setReader(User user) throws ConnectException, AdminException {
        AdminModule.doRequest(new SetReader(user.getProxyId(), this.getName()));
    }

    public void addReader(String proxyId) throws ConnectException, AdminException {
        AdminModule.doRequest(new SetReader(proxyId, this.getName()));
    }

    public void setWriter(User user) throws ConnectException, AdminException {
        AdminModule.doRequest(new SetWriter(user.getProxyId(), this.getName()));
    }

    public void addWriter(String proxyId) throws ConnectException, AdminException {
        AdminModule.doRequest(new SetWriter(proxyId, this.getName()));
    }

    public void unsetReader(User user) throws ConnectException, AdminException {
        AdminModule.doRequest(new UnsetReader(user.getProxyId(), this.getName()));
    }

    public void removeReader(String proxyId) throws ConnectException, AdminException {
        AdminModule.doRequest(new UnsetReader(proxyId, this.getName()));
    }

    public void unsetWriter(User user) throws ConnectException, AdminException {
        AdminModule.doRequest(new UnsetWriter(user.getProxyId(), this.getName()));
    }

    public void removeWriter(String proxyId) throws ConnectException, AdminException {
        AdminModule.doRequest(new UnsetWriter(proxyId, this.getName()));
    }

    public void setDMQ(DeadMQueue dmq) throws ConnectException, AdminException {
        if (dmq != null) {
            this.setDMQId(dmq.getName());
        } else {
            this.setDMQId(null);
        }
    }

    public void setDMQId(String dmqId) throws ConnectException, AdminException {
        if (dmqId == null) {
            AdminModule.doRequest(new UnsetDestinationDMQ(this.getName()));
        } else {
            AdminModule.doRequest(new SetDestinationDMQ(this.getName(), dmqId));
        }
    }

    public List getReaders() throws ConnectException, AdminException {
        Monitor_GetReaders request = new Monitor_GetReaders(this.getName());
        Monitor_GetUsersRep reply = (Monitor_GetUsersRep)AdminModule.doRequest(request);
        Vector<User> list = new Vector<User>();
        Hashtable users = reply.getUsers();
        Enumeration names = users.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            list.add(new User(name, (String)users.get(name)));
        }
        return list;
    }

    public List getReaderList() throws ConnectException, AdminException {
        Vector<String> list = new Vector<String>();
        List readers = this.getReaders();
        ListIterator iterator = readers.listIterator();
        while (iterator.hasNext()) {
            list.add(iterator.next().toString());
        }
        return list;
    }

    public List getWriters() throws ConnectException, AdminException {
        Monitor_GetWriters request = new Monitor_GetWriters(this.getName());
        Monitor_GetUsersRep reply = (Monitor_GetUsersRep)AdminModule.doRequest(request);
        Vector<User> list = new Vector<User>();
        Hashtable users = reply.getUsers();
        Enumeration names = users.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            list.add(new User(name, (String)users.get(name)));
        }
        return list;
    }

    public List getWriterList() throws ConnectException, AdminException {
        Vector<String> list = new Vector<String>();
        List readers = this.getWriters();
        ListIterator iterator = readers.listIterator();
        while (iterator.hasNext()) {
            list.add(iterator.next().toString());
        }
        return list;
    }

    public boolean isFreelyReadable() throws ConnectException, AdminException {
        Monitor_GetFreeAccess request = new Monitor_GetFreeAccess(this.getName());
        Monitor_GetFreeAccessRep reply = (Monitor_GetFreeAccessRep)AdminModule.doRequest(request);
        return reply.getFreeReading();
    }

    public void setFreelyReadable(boolean b) throws ConnectException, AdminException {
        if (b) {
            this.setFreeReading();
        } else {
            this.unsetFreeReading();
        }
    }

    public boolean isFreelyWriteable() throws ConnectException, AdminException {
        Monitor_GetFreeAccess request = new Monitor_GetFreeAccess(this.getName());
        Monitor_GetFreeAccessRep reply = (Monitor_GetFreeAccessRep)AdminModule.doRequest(request);
        return reply.getFreeWriting();
    }

    public void setFreelyWriteable(boolean b) throws ConnectException, AdminException {
        if (b) {
            this.setFreeWriting();
        } else {
            this.unsetFreeWriting();
        }
    }

    public DeadMQueue getDMQ() throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(this.getName());
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)AdminModule.doRequest(request);
        if (reply.getDMQName() == null) {
            return null;
        }
        return new DeadMQueue(reply.getDMQName());
    }

    public String getDMQId() throws ConnectException, AdminException {
        DeadMQueue dmq = this.getDMQ();
        if (dmq != null) {
            return dmq.getName();
        }
        return null;
    }

    public static Destination newInstance(String id, String name, String type) throws AdminException {
        Destination dest;
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("Destination.newInstance(" + id + ',' + name + ',' + type + ')'));
        }
        if (Queue.isQueue(type)) {
            dest = TemporaryQueue.isTemporaryQueue(type) ? new TemporaryQueue(id, null) : (DeadMQueue.isDeadMQueue(type) ? new DeadMQueue(id) : new Queue(id));
        } else if (Topic.isTopic(type)) {
            dest = TemporaryTopic.isTemporaryTopic(type) ? new TemporaryTopic(id, null) : new Topic(id);
        } else {
            throw new AdminException("Unknown destination type");
        }
        dest.adminName = name;
        return dest;
    }

    public static boolean isAssignableTo(String realType, String resultingType) {
        return realType.startsWith(resultingType);
    }

    public Hashtable getStatistic() throws ConnectException, AdminException {
        Monitor_GetStat request = new Monitor_GetStat(this.agentId);
        Monitor_GetStatRep reply = (Monitor_GetStatRep)AdminModule.doRequest(request);
        return reply.getStats();
    }

    public void toReference(Reference ref) throws NamingException {
        ref.add(new StringRefAddr("dest.agentId", this.agentId));
        ref.add(new StringRefAddr("dest.adminName", this.adminName));
    }

    public void fromReference(Reference ref) throws NamingException {
        this.agentId = (String)ref.get("dest.agentId").getContent();
        this.adminName = (String)ref.get("dest.adminName").getContent();
    }

    public Hashtable code() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("agentId", this.getName());
        h.put("type", this.type);
        return h;
    }

    public void decode(Hashtable h) {
        this.agentId = (String)h.get("agentId");
        this.type = (String)h.get("type");
    }
}

