/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.util.Debug;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.AcknowledgeRequest;
import org.objectweb.joram.mom.notifications.BrowseReply;
import org.objectweb.joram.mom.notifications.BrowseRequest;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.DenyRequest;
import org.objectweb.joram.mom.notifications.QueueMsgReply;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.mom.notifications.SetDMQRequest;
import org.objectweb.joram.mom.notifications.SetThreshRequest;
import org.objectweb.joram.mom.notifications.TopicMsgsReply;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DeadMQueueImpl
extends QueueImpl {
    private static final long serialVersionUID = 1L;
    static AgentId id = null;
    static Integer threshold = null;
    public static Logger logger = Debug.getLogger(DeadMQueueImpl.class.getName());

    public DeadMQueueImpl(AgentId destId, AgentId adminId, Properties prop) {
        super(destId, adminId, prop);
        this.setFreeWriting(true);
    }

    public String toString() {
        return "DeadMQueueImpl:" + this.destId.toString();
    }

    public static AgentId getId() {
        return id;
    }

    public static Integer getDefaultThreshold() {
        return threshold;
    }

    public void setDMQRequest(AgentId from, SetDMQRequest req) throws AccessException {
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("Unexpected request: " + req));
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Preprocess on the dead message queue: " + not));
        }
        this.doMessages(not.getMessages());
        return null;
    }

    private void doMessages(Vector msgs) {
        Enumeration enu = msgs.elements();
        while (enu.hasMoreElements()) {
            org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)enu.nextElement());
            msg.setExpiration(0L);
            ++this.arrivalsCounter;
            msg.order = msg.order;
            this.messages.add(msg);
            ++this.nbMsgsReceiveSinceCreation;
            this.setMsgTxName(msg);
            msg.save();
        }
    }

    public void setThreshRequest(AgentId from, SetThreshRequest req) throws AccessException {
        if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("Unexpected request: " + req));
        }
    }

    public void browseRequest(AgentId from, BrowseRequest not) throws AccessException {
        if (!this.isReader(from)) {
            throw new AccessException("READ right not granted");
        }
        BrowseReply rep = new BrowseReply(not);
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
            if (!Selector.matches(message.msg, not.getSelector())) continue;
            rep.addMessage(message.msg);
        }
        this.forward(from, rep);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Request answered.");
        }
    }

    public void acknowledgeRequest(AgentId from, AcknowledgeRequest not) {
    }

    public void denyRequest(AgentId from, DenyRequest not) {
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        Notification not = uA.not;
        if (!(not instanceof QueueMsgReply)) {
            return;
        }
        Vector msgList = ((QueueMsgReply)not).getMessages();
        for (int i = 0; i < msgList.size(); ++i) {
            org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)msgList.elementAt(i);
            ++this.arrivalsCounter;
            msg.order = msg.order;
            this.messages.add(msg);
            this.setMsgTxName(msg);
            msg.save();
        }
        this.deliverMessages(0);
    }

    protected void deliverMessages(int index) {
        ReceiveRequest notRec = null;
        int j = 0;
        while (!this.messages.isEmpty() && index < this.requests.size()) {
            notRec = (ReceiveRequest)this.requests.get(index);
            boolean replied = false;
            QueueMsgReply notMsg = new QueueMsgReply(notRec);
            while (j < this.messages.size()) {
                org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.get(j);
                if (Selector.matches(message.msg, notRec.getSelector())) {
                    notMsg.addMessage(message.msg);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Message " + message.getIdentifier() + " sent to " + notRec.requester + " as a reply to " + notRec.getRequestId()));
                    }
                    this.messages.remove(j);
                    message.delete();
                    replied = true;
                    ++this.nbMsgsDeliverSinceCreation;
                    this.requests.remove(index);
                    break;
                }
                ++j;
            }
            if (notMsg.getSize() > 0) {
                this.forward(notRec.requester, notMsg);
            }
            j = 0;
            if (replied) continue;
            ++index;
        }
    }

    protected void sendToDMQ(Vector deadMessages, AgentId dmqId) {
    }

    protected void handleExpiredNot(AgentId from, ExpiredNot not) {
        Notification expiredNot = not.getExpiredNot();
        if (expiredNot instanceof ClientMessages) {
            this.doMessages(((ClientMessages)expiredNot).getMessages());
        } else if (expiredNot instanceof TopicMsgsReply) {
            this.doMessages(((TopicMsgsReply)expiredNot).getMessages());
        } else {
            this.doMessages(((QueueMsgReply)expiredNot).getMessages());
        }
    }
}

