/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest.jmsbridge;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.DeleteNot;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeAckNot;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeDeliveryNot;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeModule;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.QueueMsgReply;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;

public class JMSBridgeQueueImpl
extends QueueImpl {
    private static final long serialVersionUID = 1L;
    private JMSBridgeModule jmsModule;
    private Hashtable outTable = new Hashtable();

    public JMSBridgeQueueImpl(AgentId destId, AgentId adminId, Properties prop) {
        super(destId, adminId, prop);
        this.jmsModule = new JMSBridgeModule();
        this.jmsModule.init(destId, prop);
    }

    public String toString() {
        return "BridgeQueueImpl:" + this.destId.toString();
    }

    public void bridgeDelivery(AgentId from, JMSBridgeDeliveryNot not) {
        ClientMessages clientMessages = new ClientMessages();
        clientMessages.addMessage(not.getMessage());
        super.doClientMessages(this.destId, clientMessages);
    }

    public void bridgeAck(JMSBridgeAckNot not) {
        this.outTable.remove(not.getIdentifier());
    }

    public void receiveRequest(AgentId from, ReceiveRequest not) throws AccessException {
        block11: {
            if (!this.isReader(from)) {
                throw new AccessException("READ right not granted");
            }
            not.requester = from;
            not.setExpiration(System.currentTimeMillis());
            this.requests.add(not);
            int reqIndex = this.requests.size() - 1;
            this.deliverMessages(reqIndex);
            if (this.requests.size() - 1 == reqIndex) {
                if (not.getTimeOut() == -1L) {
                    Message message;
                    block10: {
                        this.requests.remove(reqIndex);
                        message = null;
                        try {
                            message = this.jmsModule.receiveNoWait();
                        }
                        catch (Exception exc) {
                            if (!JoramTracing.dbgDestination.isLoggable(BasicLevel.ERROR)) break block10;
                            JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)"Failing receive request on remote destination: ", (Throwable)exc);
                        }
                    }
                    if (message != null && !Selector.matches(message, not.getSelector())) {
                        message = null;
                    }
                    QueueMsgReply reply = new QueueMsgReply(not);
                    reply.addMessage(message);
                    this.forward(from, reply);
                    if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                        JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)"Receive answered.");
                    }
                } else {
                    try {
                        this.jmsModule.receive();
                    }
                    catch (Exception exc) {
                        if (!JoramTracing.dbgDestination.isLoggable(BasicLevel.ERROR)) break block11;
                        JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)"Failing receive request on remote destination: ", (Throwable)exc);
                    }
                }
            }
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages not) {
        if (this.destId.equals(from)) {
            return not;
        }
        Enumeration msgs = not.getMessages().elements();
        while (msgs.hasMoreElements()) {
            org.objectweb.joram.mom.messages.Message message = new org.objectweb.joram.mom.messages.Message((Message)msgs.nextElement());
            ++this.arrivalsCounter;
            message.order = message.order;
            this.outTable.put(message.getIdentifier(), message);
            try {
                this.jmsModule.send(message.msg);
            }
            catch (Exception exc) {
                if (JoramTracing.dbgDestination.isLoggable(BasicLevel.ERROR)) {
                    JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)"Failing sending to remote  destination: ", (Throwable)exc);
                }
                this.outTable.remove(message.getIdentifier());
                ClientMessages deadM = new ClientMessages(not.getClientContext(), not.getRequestId());
                deadM.addMessage(message.msg);
                this.sendToDMQ(deadM, not.getDMQId());
            }
        }
        return null;
    }

    protected void doDeleteNot(DeleteNot not) {
        this.jmsModule.close();
        super.doDeleteNot(not);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block11: {
            in.defaultReadObject();
            this.messages = new Vector();
            this.deliveredMsgs = new Hashtable();
            Vector persistedMsgs = null;
            if (persistedMsgs != null) {
                while (!persistedMsgs.isEmpty()) {
                    org.objectweb.joram.mom.messages.Message persistedMsg = (org.objectweb.joram.mom.messages.Message)persistedMsgs.remove(0);
                    AgentId consId = (AgentId)this.consumers.get(persistedMsg.getIdentifier());
                    if (consId == null) {
                        this.addMessage(persistedMsg);
                        continue;
                    }
                    if (this.isLocal(consId)) {
                        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)(" -> deny " + persistedMsg.getIdentifier()));
                        }
                        this.consumers.remove(persistedMsg.getIdentifier());
                        this.contexts.remove(persistedMsg.getIdentifier());
                        this.addMessage(persistedMsg);
                        continue;
                    }
                    this.deliveredMsgs.put(persistedMsg.getIdentifier(), persistedMsg);
                }
            }
            try {
                this.jmsModule.connect();
                for (int i = 0; i < this.requests.size(); ++i) {
                    this.jmsModule.receive();
                }
                Vector<org.objectweb.joram.mom.messages.Message> outMessages = new Vector<org.objectweb.joram.mom.messages.Message>();
                Enumeration keys = this.outTable.keys();
                while (keys.hasMoreElements()) {
                    int i;
                    org.objectweb.joram.mom.messages.Message momMsg = (org.objectweb.joram.mom.messages.Message)this.outTable.get(keys.nextElement());
                    for (i = 0; i < outMessages.size(); ++i) {
                        org.objectweb.joram.mom.messages.Message currentMsg = (org.objectweb.joram.mom.messages.Message)outMessages.get(i);
                        if (momMsg.order < currentMsg.order) break;
                    }
                    outMessages.insertElementAt(momMsg, i);
                }
                while (!outMessages.isEmpty()) {
                    org.objectweb.joram.mom.messages.Message momMsg = (org.objectweb.joram.mom.messages.Message)outMessages.remove(0);
                    this.jmsModule.send(momMsg.msg);
                }
            }
            catch (Exception exc) {
                if (!JoramTracing.dbgDestination.isLoggable(BasicLevel.ERROR)) break block11;
                JoramTracing.dbgDestination.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
        }
    }
}

