/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.lib;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PNameIterator;

public class MultiplePNameIterator
implements PNameIterator {
    private PClassMapping[] pcms;
    private Iterator currentIterator;
    private int pcmIdx;
    private Object connection;
    private Object txctx;
    private Object nextPName;
    private boolean prefetching;

    public MultiplePNameIterator(PClassMapping[] pcms, Object connection, boolean prefetching, Object txctx) throws PException {
        this(pcms, null, connection, prefetching, txctx);
    }

    public MultiplePNameIterator(PClassMapping[] pcms, Iterator currentIt, Object connection, boolean prefetching, Object txctx) throws PException {
        this.pcms = pcms;
        this.prefetching = prefetching;
        this.connection = connection;
        this.currentIterator = currentIt;
        this.txctx = txctx;
        this.pcmIdx = -1;
        this.calculateNext();
    }

    private void calculateNext() throws PException {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            this.nextPName = this.currentIterator.next();
        } else {
            this.nextPName = null;
            if (!this.prefetching && this.currentIterator instanceof PNameIterator) {
                ((PNameIterator)this.currentIterator).close();
            }
            ++this.pcmIdx;
            if (this.pcmIdx < this.pcms.length) {
                this.currentIterator = this.pcms[this.pcmIdx].getPNameIterator(this.connection, true, this.prefetching, this.txctx);
                this.calculateNext();
            }
        }
    }

    public boolean hasNext() {
        return this.nextPName != null;
    }

    public Object next() {
        if (this.nextPName == null) {
            throw new NoSuchElementException();
        }
        Object res = this.nextPName;
        try {
            this.calculateNext();
        }
        catch (PException e) {
            this.nextPName = null;
        }
        return res;
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove operation not supported");
    }

    public void close() throws PException {
        this.nextPName = null;
        if (!this.prefetching && this.currentIterator instanceof PNameIterator) {
            ((PNameIterator)this.currentIterator).close();
        }
    }
}

