/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.fos.lib;

import java.util.ArrayList;
import java.util.Iterator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.lib.AbstractPMapcluster;
import org.objectweb.jorm.mapper.fos.lib.FosPMappingStructuresManager;
import org.objectweb.perseus.fos.api.FosAccess;
import org.objectweb.perseus.fos.api.FosException;

public class FosPMapCluster
extends AbstractPMapcluster {
    private ArrayList directories;
    private FosPMappingStructuresManager manager;

    FosPMapCluster(String jcname, FosPMappingStructuresManager man) {
        this.jcNames.add(jcname);
        this.directories = new ArrayList(1);
        this.manager = man;
    }

    FosPMapCluster(String jcname, String basedir, FosPMappingStructuresManager man) {
        this(jcname, man);
        this.directories.add(basedir);
    }

    void addClass(String jcname) {
        this.addDependency(jcname);
    }

    void addDirName(String dirname) throws PException {
        String curd = null;
        Iterator it = this.directories.iterator();
        while (it.hasNext() && !(curd = (String)it.next()).equals(dirname)) {
            curd = null;
        }
        if (curd == null) {
            this.directories.add(dirname);
        }
    }

    boolean containDirectory(String dirname) throws PException {
        String curd = null;
        Iterator it = this.directories.iterator();
        while (it.hasNext()) {
            curd = (String)it.next();
            if (dirname.length() >= curd.length() && curd.equals(dirname.substring(0, curd.length()))) {
                return true;
            }
            if (dirname.length() < curd.length() && dirname.equals(curd.substring(0, dirname.length()))) {
                return true;
            }
            curd = null;
        }
        return false;
    }

    void merge(FosPMapCluster cl) {
        this.jcNames.addAll(cl.jcNames);
        this.directories.addAll(cl.directories);
    }

    public void createMappingStructures(boolean force) throws PException {
        if (this.structuresActive) {
            throw new PException("Cannot change mapping structures while they are under use");
        }
    }

    public void deleteData() throws PException {
        Object conn = this.manager.getConnection();
        String curd = null;
        try {
            Iterator it = this.directories.iterator();
            while (it.hasNext()) {
                curd = (String)it.next();
                if (!((FosAccess)conn).existDir(curd)) continue;
                Iterator it2 = ((FosAccess)conn).scan(curd);
                while (it2.hasNext()) {
                    String oid = (String)it2.next();
                    ((FosAccess)conn).delete(curd, oid);
                }
            }
        }
        catch (FosException e) {
            throw new PException((Exception)((Object)e), "PB while deteling data from FOS directory " + curd);
        }
        finally {
            this.manager.closeConnection(conn);
        }
    }

    public void deleteMappingStructures() throws PException {
        if (this.structuresActive) {
            throw new PException("Cannot change mapping structures while they are under use");
        }
        Object conn = this.manager.getConnection();
        String curd = null;
        try {
            Iterator it = this.directories.iterator();
            while (it.hasNext()) {
                curd = (String)it.next();
                if (!((FosAccess)conn).existDir(curd)) continue;
                ((FosAccess)conn).deleteDir(curd);
            }
        }
        catch (FosException e) {
            throw new PException((Exception)((Object)e), "PB while deteling FOS directory " + curd);
        }
        finally {
            this.manager.closeConnection(conn);
        }
    }
}

