/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.ReferenceMapping;
import org.objectweb.jorm.metainfo.lib.BasicCommonClassMapping;
import org.objectweb.jorm.metainfo.lib.BasicParentClassMapping;

public abstract class BasicClassMapping
extends BasicCommonClassMapping
implements ClassMapping {
    private List fieldNames;
    private List referenceMappings = new ArrayList();
    protected List parentClassMappings = new ArrayList();

    public BasicClassMapping(String ruleName, MetaObject linkedMO, MetaObject parent) {
        super(ruleName, linkedMO, parent);
        this.fieldNames = new ArrayList();
    }

    public Class getJormClass() {
        return (Class)this.linkedMO;
    }

    public void addReferenceMapping(ReferenceMapping refMapping) {
        Reference r = (Reference)refMapping.getLinkedMO().getParent();
        this.referenceMappings.add(refMapping);
        this.fieldNames.add(r.getName());
    }

    public ReferenceMapping createReferenceMapping(String ruleName, NameDef nd) {
        ReferenceMapping res = super.createReferenceMapping(ruleName, nd);
        this.addReferenceMapping(res);
        return res;
    }

    public ReferenceMapping getReferenceMapping(String referenceName) {
        int idx = this.fieldNames.indexOf(referenceName);
        ReferenceMapping res = null;
        if (idx == -1) {
            Iterator it = this.iterateParentClassMappings();
            while (it.hasNext()) {
                ParentClassMapping pcm = (ParentClassMapping)it.next();
                Class pc = pcm.getMOClass();
                ClassMapping cm = pc.getClassMapping(this.getProjectName(), this.getMapperName());
                res = cm.getReferenceMapping(referenceName);
                if (res == null) continue;
                return res;
            }
            return res;
        }
        return (ReferenceMapping)this.referenceMappings.get(idx);
    }

    public Iterator iterateReferenceMappings() {
        return this.referenceMappings.iterator();
    }

    public Collection getReferenceMappings() {
        return this.referenceMappings;
    }

    public void addParentClassMapping(ParentClassMapping pcm) {
        this.parentClassMappings.add(pcm);
    }

    public ParentClassMapping createParentClassMapping(String ruleName, Class superClass) {
        BasicParentClassMapping pcm = new BasicParentClassMapping(ruleName, superClass, this);
        this.addParentClassMapping(pcm);
        return pcm;
    }

    public Iterator iterateParentClassMappings() {
        return this.parentClassMappings.iterator();
    }

    public Collection getParentClassMappings() {
        return this.parentClassMappings;
    }

    public ParentClassMapping getParentClassMapping(String classFQName) {
        Iterator pcmIt = this.parentClassMappings.iterator();
        while (pcmIt.hasNext()) {
            ParentClassMapping pcm = (ParentClassMapping)pcmIt.next();
            if (!pcm.getFQName().equals(classFQName)) continue;
            return pcm;
        }
        return null;
    }

    protected Collection getChildren() {
        Collection al = super.getChildren();
        al.addAll(this.parentClassMappings);
        al.addAll(this.referenceMappings);
        return al;
    }
}

