/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.naming.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.naming.api.FilteredPNamingContext;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNameGetterConverter;
import org.objectweb.jorm.naming.lib.BasicPNamingContext;

public abstract class AbstractInheritFilteredPNamingContext
extends BasicPNamingContext
implements FilteredPNamingContext {
    private FilteredPNamingContext[] fpncs = new FilteredPNamingContext[0];
    protected PBinder binder;
    protected int codingType;
    private PName nullPName;
    protected PNameGetterConverter converter;

    public AbstractInheritFilteredPNamingContext() {
    }

    public AbstractInheritFilteredPNamingContext(int codingType) {
        this.codingType = codingType;
    }

    public AbstractInheritFilteredPNamingContext(int codingType, PNameGetterConverter converter) {
        this.codingType = codingType;
        this.converter = converter;
    }

    public PBinder getBinder() {
        return this.binder;
    }

    public void setBinder(PBinder binder) {
        this.binder = binder;
    }

    public void setCodingType(int codingType) {
        this.codingType = codingType;
    }

    public PNameGetterConverter getConverter() {
        return this.converter;
    }

    public void setConverter(PNameGetterConverter converter) {
        this.converter = converter;
    }

    public synchronized void bindSubFPNC(FilteredPNamingContext fpnc) {
        FilteredPNamingContext[] newfpncs = new FilteredPNamingContext[this.fpncs.length + 1];
        System.arraycopy(this.fpncs, 0, newfpncs, 0, this.fpncs.length);
        newfpncs[this.fpncs.length] = fpnc;
        this.fpncs = newfpncs;
    }

    public synchronized void unbindSubFPNC(FilteredPNamingContext fpnc) {
        int j = Arrays.binarySearch(this.fpncs, fpnc);
        if (j == -1) {
            return;
        }
        FilteredPNamingContext[] newfpncs = new FilteredPNamingContext[this.fpncs.length - 1];
        if (j > 0) {
            System.arraycopy(this.fpncs, 0, newfpncs, 0, j);
        }
        if (j < newfpncs.length) {
            System.arraycopy(this.fpncs, j + 1, newfpncs, j, this.fpncs.length - j);
        }
        this.fpncs = newfpncs;
    }

    public boolean codingSupported(int codingtype) {
        return codingtype == this.codingType || codingtype == 1024;
    }

    public PName getNull() {
        return this.nullPName;
    }

    public void setNullPName(Object o) throws PException {
        this.nullPName = (PName)o;
    }

    public PName resolve(Object conn, PName pn) throws PException {
        switch (this.codingType) {
            case 524288: {
                int i;
                Object o = pn.encodeAbstract();
                for (i = this.fpncs.length - 1; i >= 0 && !this.fpncs[i].match(o); --i) {
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeAbstract(o, null);
                }
                if (this.binder != null) {
                    return this.binder.decodeAbstract(o, null);
                }
                return pn;
            }
            case 2: {
                int i;
                char o = pn.encodeChar();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeChar(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeChar(o);
                }
                return pn;
            }
            case 64: {
                int i;
                Character o = pn.encodeOchar();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeOchar(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeOchar(o);
                }
                return pn;
            }
            case 1: {
                int i;
                byte o = pn.encodeByte();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeByte(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeByte(o);
                }
                return pn;
            }
            case 32: {
                int i;
                Byte o = pn.encodeObyte();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeObyte(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeObyte(o);
                }
                return pn;
            }
            case 4: {
                int i;
                short o = pn.encodeShort();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeShort(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeShort(o);
                }
                return pn;
            }
            case 128: {
                int i;
                Short o = pn.encodeOshort();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeOshort(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeOshort(o);
                }
                return pn;
            }
            case 8: {
                int i;
                int o = pn.encodeInt();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeInt(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeInt(o);
                }
                return pn;
            }
            case 256: {
                int i;
                Integer o = pn.encodeOint();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeOint(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeOint(o);
                }
                return pn;
            }
            case 16: {
                int i;
                long o = pn.encodeLong();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeLong(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeLong(o);
                }
                return pn;
            }
            case 512: {
                int i;
                Long o = pn.encodeOlong();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeOlong(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeOlong(o);
                }
                return pn;
            }
            case 1024: {
                int i;
                String o = pn.encodeString();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeString(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeString(o);
                }
                return pn;
            }
            case 8192: {
                int i;
                byte[] o = pn.encode();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decode(o);
                }
                if (this.binder != null) {
                    return this.binder.decode(o);
                }
                return pn;
            }
            case 4096: {
                int i;
                char[] o = pn.encodeCharArray();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeCharArray(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeCharArray(o);
                }
                return pn;
            }
            case 2048: {
                int i;
                Date o = pn.encodeDate();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeDate(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeDate(o);
                }
                return pn;
            }
            case 32768: {
                int i;
                BigDecimal o = pn.encodeBigDecimal();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeBigDecimal(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeBigDecimal(o);
                }
                return pn;
            }
            case 16384: {
                int i;
                BigInteger o = pn.encodeBigInteger();
                while (i >= 0 && !this.fpncs[i].match(o)) {
                    --i;
                }
                if (i >= 0) {
                    return this.fpncs[i].decodeBigInteger(o);
                }
                if (this.binder != null) {
                    return this.binder.decodeBigInteger(o);
                }
                return pn;
            }
        }
        return this.getNull();
    }

    public PName export(Object conn, Object infoitem) throws PException {
        return this.export(conn, infoitem, null);
    }

    public PName export(Object conn, Object infoitem, Object hints) throws PException {
        if (infoitem instanceof PName) {
            return (PName)infoitem;
        }
        return this.decodeAbstract(infoitem, hints);
    }

    public void unexport(Object conn, PName pn) throws PException {
    }

    public void unexport(Object conn, PName pn, Object hints) throws PException {
    }

    public String encodeString(PName pn) throws PExceptionNaming {
        throw new UnsupportedOperationException("String coding not supported");
    }
}

