/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.persistence.lib;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.perseus.persistence.api.ConnectionHolder;
import org.objectweb.perseus.persistence.api.PersistenceException;
import org.objectweb.perseus.persistence.api.State;
import org.objectweb.perseus.persistence.api.TransactionalWorkingSet;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class BasicWorkingSet
implements TransactionalWorkingSet,
BindingController {
    protected Logger logger = null;
    protected Map oid2state = new LinkedHashMap();
    protected byte status = 1;
    protected Object userObject = null;
    protected ConnectionHolder connectionHolder = null;
    protected boolean retainValues = true;
    protected boolean restoreValues = false;
    protected boolean rollBackOnly = false;
    protected boolean objectSharing = true;

    public String[] listFc() {
        return new String[0];
    }

    public Object lookupFc(String c) {
        return null;
    }

    public void bindFc(String c, Object s) {
        if ("logger".equals(c)) {
            this.logger = (Logger)s;
        }
    }

    public void unbindFc(String c) {
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte s) throws PersistenceException {
        this.status = s;
    }

    public State lookup(Object oid) {
        return (State)this.oid2state.get(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State bind(State state, Object oid, byte mode) {
        State old;
        Map map = this.oid2state;
        synchronized (map) {
            old = this.oid2state.put(oid, state);
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            if (old == null) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Bind (" + oid + ", " + state + ") to the context"));
            } else {
                this.logger.log(BasicLevel.DEBUG, (Object)("Change the state in the context\n-oid=" + oid + "\n-old state=" + old + "\n- new state=" + state));
            }
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbind(Object oid) {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("UnBind " + oid + " from the context"));
        }
        Map map = this.oid2state;
        synchronized (map) {
            return this.oid2state.remove(oid) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.oid2state;
        synchronized (map) {
            this.oid2state.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entries() {
        Map map = this.oid2state;
        synchronized (map) {
            return new LinkedHashSet(this.oid2state.values());
        }
    }

    public Set oids() {
        return this.oid2state.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getOid2Entry() {
        Map map = this.oid2state;
        synchronized (map) {
            return this.oid2state;
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public ConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    public boolean getWSRetainValues() {
        return this.retainValues;
    }

    public void setWSRetainValues(boolean val) {
        this.retainValues = val;
    }

    public boolean getWSRestoreValues() {
        return this.restoreValues;
    }

    public void setWSRestoreValues(boolean val) {
        this.restoreValues = val;
    }

    public boolean getWSRollBackOnly() {
        return this.rollBackOnly;
    }

    public void setWSRollBackOnly(boolean val) {
        this.rollBackOnly = val;
    }

    public boolean getWSObjectSharing() {
        return this.objectSharing;
    }

    public void setWSObjectSharing(boolean v) {
        this.objectSharing = v;
    }
}

