/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.io.Serializable;
import java.rmi.Remote;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.ow2.carol.jndi.spi.AbsContext;
import org.ow2.carol.jndi.wrapping.JNDIResourceWrapper;
import org.ow2.carol.jndi.wrapping.UnicastJNDIReferenceWrapper;
import org.ow2.carol.rmi.exception.NamingExceptionHelper;
import org.ow2.carol.rmi.util.PortNumber;
import org.ow2.carol.util.configuration.ConfigurationRepository;

public class JRMPContext
extends AbsContext
implements Context {
    public JRMPContext(Context jrmpContext) {
        super(jrmpContext);
    }

    protected int getObjectPort() {
        Properties prop = ConfigurationRepository.getProperties();
        if (prop != null) {
            String propertyName = "carol.jrmp.server.port";
            return PortNumber.strToint(prop.getProperty(propertyName, "0"), propertyName);
        }
        return 0;
    }

    protected Object unwrapObject(Object o, Name name) throws NamingException {
        return super.defaultUnwrapObject(o, name);
    }

    protected Object wrapObject(Object o, Name name, boolean replace) throws NamingException {
        try {
            if (!(o instanceof Remote) && o instanceof Referenceable) {
                return new UnicastJNDIReferenceWrapper(((Referenceable)o).getReference(), this.getObjectPort());
            }
            if (!(o instanceof Remote) && o instanceof Reference) {
                return new UnicastJNDIReferenceWrapper((Reference)o, this.getObjectPort());
            }
            if (!(o instanceof Remote) && !(o instanceof Referenceable) && !(o instanceof Reference) && o instanceof Serializable) {
                JNDIResourceWrapper irw = new JNDIResourceWrapper((Serializable)o);
                PortableRemoteObjectDelegate proDelegate = ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject();
                proDelegate.exportObject((Remote)irw);
                Remote oldObj = (Remote)this.addToExported(name, irw);
                if (oldObj != null) {
                    if (replace) {
                        proDelegate.unexportObject(oldObj);
                    } else {
                        proDelegate.unexportObject((Remote)irw);
                        this.addToExported(name, oldObj);
                        throw new NamingException("Object '" + o + "' with name '" + name + "' is already bind");
                    }
                }
                return irw;
            }
            return o;
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot wrap object '" + o + "' with name '" + name + "' : " + e.getMessage(), e);
        }
    }
}

