/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.osgi.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.controller.server.IPolicyStrategyManager;
import org.ow2.cmi.lb.loader.ArchiveId;
import org.ow2.cmi.lb.loader.ArchiveWrapper;
import org.ow2.cmi.loader.IArchiveWrapper;
import org.ow2.cmi.loader.IDefaultPolicyStrategyLoader;
import org.ow2.cmi.osgi.loader.LoaderUtil;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DefaultPolicyStrategyLoader
implements IDefaultPolicyStrategyLoader {
    private HashMap<String, String> deployedBundles = new HashMap();
    private static IPolicyStrategyManager policyStrategyManager = null;
    private static BundleContext bundleContext;
    private static final Log LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadArchive(IArchiveWrapper archive) {
        LOGGER.debug(" Trying to load classes from archive with id : " + archive.getArchiveId(), new Object[0]);
        ArchiveWrapper arch = (ArchiveWrapper)archive;
        LOGGER.debug("Getting new archive for load balancing policies/strategies, previously broadcast in the cluster ", new Object[0]);
        ArchiveId archiveId = LoaderUtil.buildArchiveIdFromFormattedId((String)arch.getArchiveId());
        LOGGER.debug("Archive host:{0} archive location:{1}", archiveId.getHost(), archiveId.getName());
        if (((ArchiveWrapper)archive).toBeInstalled()) {
            InputStream is = null;
            File archiveTmp = null;
            try {
                archiveTmp = LoaderUtil.createTempJarFile(archiveId.getName(), archive.getData());
                is = archiveTmp.toURL().openStream();
                String deployedLocation = CMIConfig.getDeployDirectory() + archiveTmp.getName();
                Bundle archiveBundle = bundleContext.installBundle(deployedLocation, is);
                this.deployedBundles.put(archiveId.toString(), deployedLocation);
            }
            catch (Exception e) {
                LOGGER.debug("Unable to install policy/strategy bundle with Id:{0}, name:{1} ", archiveId.getHost(), archiveId.getName());
            }
            finally {
                if (archiveTmp != null) {
                    archiveTmp.delete();
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to close input stream for load balancing archive", new Object[0]);
                    }
                }
            }
        }
        LOGGER.debug("archive successfully loaded", new Object[0]);
    }

    public static IPolicyStrategyManager getPolicyStrategyManager() {
        return policyStrategyManager;
    }

    public void setPolicyStrategyManager(IPolicyStrategyManager poClusterViewManager) {
        policyStrategyManager = poClusterViewManager;
    }

    public void unLoadClasses(IArchiveWrapper archive) {
    }

    public void unLoadArchive(Object archiveId) {
        String archiveLocation = this.deployedBundles.get(archiveId);
        LOGGER.debug("Removing bundle with Id '" + archiveId + "' installed at : '" + archiveLocation + "' ", new Object[0]);
        File f = new File(archiveLocation);
        if (f.delete()) {
            LOGGER.debug("The bundle was successfully removed", new Object[0]);
        }
        this.deployedBundles.remove(archiveId);
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static void setBundleContext(BundleContext bc) {
        bundleContext = bc;
    }

    public void loadArchive(String deployDir, IArchiveWrapper archive) {
    }

    static {
        LOGGER = LogFactory.getLog(DefaultPolicyStrategyLoader.class);
    }
}

