/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.reference.util;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class ProviderURLParser {
    private static final int URL_HOSTPORT_INDEX = 2;
    private static final Map<String, String> MAPPING = new HashMap<String, String>();
    private final String protocol;
    private final String providerURL;
    private String scheme;
    private String hostName;
    private int port;

    public ProviderURLParser(String protocol, String providerURL) {
        if (protocol == null) {
            throw new IllegalArgumentException("The protocol name is null");
        }
        this.protocol = protocol;
        this.providerURL = providerURL;
    }

    public ProviderURLParser(String providerURL) {
        this.protocol = null;
        this.providerURL = providerURL;
    }

    private void parseScheme(String protocol, String inputscheme) throws MalformedURLException {
        if (inputscheme.length() == 0) {
            throw new MalformedURLException("Scheme cannot be empty");
        }
        if (inputscheme.length() <= 1 || !inputscheme.endsWith(":")) {
            throw new MalformedURLException("badly formed scheme");
        }
        this.scheme = inputscheme.substring(0, inputscheme.length() - 1);
        if (!this.isConsistent(protocol, this.scheme)) {
            throw new MalformedURLException("Invalid scheme : " + this.scheme);
        }
    }

    private boolean isConsistent(String protocol, String scheme) throws MalformedURLException {
        String sch = MAPPING.get(protocol);
        if (sch == null) {
            throw new MalformedURLException("Invalid protocol: " + protocol);
        }
        return sch.equals(scheme);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseHostPort(String inputhostport) throws MalformedURLException {
        String inputhost = "";
        String inputport = "";
        int m = inputhostport.indexOf(58);
        if (m == -1) {
            inputhost = inputhostport;
        } else if (m == 0) {
            if (inputhostport.length() <= 1) throw new MalformedURLException("non-empty port expected after :");
            inputport = inputhostport.substring(1);
        } else {
            inputhost = inputhostport.substring(0, m);
            if (inputhostport.length() <= m + 1) throw new MalformedURLException("non-empty port expected after :");
            inputport = inputhostport.substring(m + 1);
        }
        if (!inputhost.equals("")) {
            this.hostName = inputhost;
        }
        if (inputport.equals("")) return;
        try {
            this.port = Integer.parseInt(inputport);
            return;
        }
        catch (NumberFormatException e) {
            throw new MalformedURLException("port must be a number");
        }
    }

    public void parse() throws MalformedURLException {
        if (this.providerURL == null || this.providerURL.length() == 0) {
            throw new MalformedURLException("null or empty registry URL");
        }
        if (this.providerURL.indexOf("//") == -1) {
            throw new MalformedURLException("badly formed registry URL " + this.providerURL);
        }
        try {
            if (this.protocol != null) {
                this.parseScheme(this.protocol, this.providerURL.substring(0, this.providerURL.indexOf("//")));
            }
            this.parseHostPort(this.providerURL.substring(this.providerURL.indexOf("//") + 2));
        }
        catch (Exception e) {
            throw new MalformedURLException("badly formed registry URL " + this.providerURL);
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    static {
        MAPPING.put("jrmp", "rmi");
        MAPPING.put("irmi", "rmi");
        MAPPING.put("iiop", "iiop");
    }
}

