/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.rpc;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.client.ClientClusterViewManager;
import org.ow2.cmi.controller.common.AbsClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.lb.NoLoadBalanceableException;
import org.ow2.cmi.lb.decision.DecisionManager;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.reference.CMIProxyHandle;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.rpc.CMIInvocationHandlerException;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class CMIInvocationHandler<T>
implements InvocationHandler,
Serializable {
    private static final Log LOGGER = LogFactory.getLog(CMIInvocationHandler.class);
    private transient ClassLoader classLoader;
    protected final String objectName;
    protected final String protocolName;
    protected transient ClusterViewManager clusterViewManager;
    private CMIReferenceable<T> currentRef;
    protected transient Class<? extends T> itf;
    private boolean keepCurrentRef;
    protected transient CMIProxyHandle cmiProxyHandle = null;
    private long lastInvocDuration;

    protected CMIInvocationHandler(ClusterViewManager clusterViewManager, String objectName, String protocolName, boolean keepCurrentRef, Class<? extends T> itf) {
        this.clusterViewManager = clusterViewManager;
        this.protocolName = protocolName;
        this.objectName = objectName;
        this.keepCurrentRef = keepCurrentRef;
        this.itf = itf;
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.clusterViewManager == null) {
            this.clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        }
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (this.itf == null) {
            try {
                this.itf = this.clusterViewManager.getInterface(this.objectName);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error("Cannot retrieve the interface for object with name " + this.objectName, e);
                throw new CMIInvocationHandlerException("Cannot retrieve the interface for object with name " + this.objectName, e);
            }
        }
        this.checkInitialized();
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        String methodName = method.getName();
        if (methodName.endsWith("_CMI")) {
            return this.invokeCMIProxy(methodName.substring(0, methodName.length() - 4), proxy);
        }
        return this.invokeRemoteMethod(proxy, method, args);
    }

    private Object invokeCMIProxy(String methodName, Object proxy) {
        if (methodName.equals("getObjectName")) {
            return this.objectName;
        }
        if (methodName.equals("getInterface")) {
            return this.itf;
        }
        if (methodName.equals("getProtocolName")) {
            return this.protocolName;
        }
        if (methodName.equals(this.getHandleMethodName())) {
            return this.getHandle((CMIProxy)proxy);
        }
        if (methodName.equals("getCurrentCMIRef")) {
            return this.currentRef;
        }
        if (methodName.equals("isCMIRefKept")) {
            return this.keepCurrentRef;
        }
        throw new UnsupportedOperationException("CMIProxy doesn't define the method " + methodName);
    }

    protected abstract void checkInitialized() throws CMIInvocationHandlerException;

    private Object invokeObjectMethod(Object proxy, Method method, Object ... args) {
        String name = method.getName();
        if (name.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (name.equals("equals")) {
            Object obj = args[0];
            boolean b = proxy == obj || obj != null && Proxy.isProxyClass(obj.getClass()) && this.equals(Proxy.getInvocationHandler(obj));
            return b;
        }
        if (name.equals("toString")) {
            return this.proxyToString(proxy);
        }
        LOGGER.error("unexpected Object method: {0}", method);
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    protected String proxyToString(Object proxy) {
        return "object:" + this.objectName + ", protocol:" + this.protocolName + ", object:" + this.currentRef + ", keepCurrentRef:" + this.keepCurrentRef + ", itf:" + this.itf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeRemoteMethod(Object proxy, Method method, Object ... args) throws Throwable {
        IPolicy<CMIReference> policy;
        ArrayList<CMIReference> cmiReferences;
        String methodName;
        block38: {
            methodName = method.getName();
            cmiReferences = null;
            policy = null;
            try {
                cmiReferences = new ArrayList<CMIReference>(this.clusterViewManager.getCMIReferences(this.objectName, this.protocolName));
                LOGGER.debug("Object: {0} - Invoke:{1} > CMIReferences: {2}", this.objectName, methodName, cmiReferences);
                policy = this.clusterViewManager.getPolicy(this.objectName);
                LOGGER.debug("Object: {0} - Invoke: {1} > Policy: {2}", this.objectName, methodName, policy);
            }
            catch (ObjectNotFoundException e) {
                if (!(this.clusterViewManager instanceof ServerClusterViewManager)) break block38;
                LOGGER.error("Object: {0} - Invoke:{1} > Cannot retrieve data", this.objectName, method, e);
                throw new CMIInvocationHandlerException("Object: " + this.objectName + " - Invoke: " + methodName + " > Cannot retrieve data", e);
            }
        }
        if (this.clusterViewManager instanceof ClientClusterViewManager) {
            CMIInvocationHandler e = this;
            synchronized (e) {
                if (cmiReferences == null || policy == null) {
                    LOGGER.debug("Object: {0} - Invoke: {1} > Forcing an update...", this.objectName, methodName);
                    ((ClientClusterViewManager)this.clusterViewManager).pullAndUpdateObjectInfos(this.objectName);
                    cmiReferences = new ArrayList<CMIReference>(this.clusterViewManager.getCMIReferences(this.objectName, this.protocolName));
                    LOGGER.debug("Object: {0} - Invoke: {1} > CMIReferences is now: {2}", this.objectName, methodName, cmiReferences);
                    policy = this.clusterViewManager.getPolicy(this.objectName);
                    LOGGER.debug("Object: {0} - Invoke: {1 } > LBPolicy is now: {2}", this.objectName, methodName, policy);
                }
            }
        }
        DecisionManager<Object> decisionManagerOnReturn = null;
        do {
            DecisionManager.Decision decision;
            DecisionManager<Void> decisionManager;
            CMIReference cmiReference = null;
            CMIReferenceable<T> cmiReferenceable = null;
            if (this.keepCurrentRef && this.currentRef != null) {
                cmiReference = this.currentRef.getReference();
                cmiReferenceable = this.currentRef;
            }
            if (cmiReferenceable == null) {
                DecisionManager<CMIReferenceable<T>> decisionManagerOnChoose;
                LOGGER.debug("Object:{0} - Invoke: {1} > Choosing a node...", this.objectName, methodName);
                try {
                    cmiReference = policy.choose(cmiReferences);
                }
                catch (NoLoadBalanceableException e) {
                    LOGGER.error("Object: {0} - Invoke: {1} > Cannot get a CMIReference for protocol {2}", this.objectName, methodName, this.protocolName, e);
                    throw new CMIInvocationHandlerException("Object: " + this.objectName + " - Invoke: " + methodName + " > Cannot get a CMIReference for protocol " + this.protocolName, e);
                }
                LOGGER.debug("Object: {0} - Invoke: {1} > Trying to get a CMIReferenceable for {2}...", this.objectName, methodName, cmiReference);
                try {
                    cmiReferenceable = this.getCMIReferenceable(cmiReference);
                    LOGGER.debug("Object: {0} - Invoke: {1} > CMIReferenceable successfully retrieved: {2}", this.objectName, methodName, cmiReferenceable);
                    decisionManagerOnChoose = policy.onChoose(method, args, cmiReferenceable);
                }
                catch (Exception e) {
                    LOGGER.debug("Object:{0} - Invoke: {1} > onLookupException.", this.objectName, methodName, e);
                    decisionManager = policy.onLookupException(cmiReference, e);
                    if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                        LOGGER.debug("Object: {0} - Invoke: {1} > onLookupException=THROW", this.objectName, methodName, decisionManager.getThrowable());
                        throw decisionManager.getThrowable();
                    }
                    LOGGER.debug("Object: {0} - Invoke: {1} > onLookupException=RETRY, Removing node {2}", this.objectName, methodName, cmiReference);
                    cmiReferences.remove(cmiReference);
                    this.currentRef = null;
                    continue;
                }
                decision = decisionManagerOnChoose.getDecision();
                if (decision.equals((Object)DecisionManager.Decision.RETRY)) {
                    LOGGER.debug("Object:{0} - Invoke: {1} > onChoose=RETRY!", this.objectName, method);
                    cmiReferences.remove(cmiReference);
                    continue;
                }
                if (decision.equals((Object)DecisionManager.Decision.RETURN)) {
                    LOGGER.debug("Object: {0} - Invoke: {1} > onChoose=RETURN!", this.objectName, method);
                    cmiReferenceable = decisionManagerOnChoose.getRetVal();
                } else if (decision.equals((Object)DecisionManager.Decision.THROW)) {
                    LOGGER.error("Object: {0} - Invoke: {1} > onChoose=THROW!", this.objectName, method, decisionManagerOnChoose.getThrowable());
                    throw decisionManagerOnChoose.getThrowable();
                }
                this.currentRef = cmiReferenceable;
            }
            if (cmiReferenceable == null) {
                LOGGER.error("Object: {0} - Invoke: {1} > The current manadatory for reference {2} should not be null !", this.objectName, methodName, cmiReference);
                throw new CMIInvocationHandlerException("Object: " + this.objectName + " - Invoke: " + methodName + " > The current manadatory for reference " + cmiReference + "should not be null !");
            }
            this.preInvokeHook(cmiReferenceable);
            ClassLoader oldClassLoader = null;
            if (this.classLoader != null) {
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            LOGGER.debug("Object: {0} - Invoke: {1} > Invocation with args: {2}", this.objectName, methodName, args);
            try {
                Object result;
                long timeBefore = System.currentTimeMillis();
                try {
                    result = method.invoke(cmiReferenceable.getReferencedObject(), args);
                    long timeAfter = System.currentTimeMillis();
                    this.lastInvocDuration = timeAfter - timeBefore;
                }
                finally {
                    if (this.classLoader != null) {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
                this.postInvokeHook();
                decisionManagerOnReturn = policy.onReturn(method, args, cmiReference, result);
            }
            catch (Exception e) {
                LOGGER.debug("Object: {0} - Invoke: {1} > onInvokeException.", this.objectName, methodName, e);
                decisionManager = policy.onInvokeException(method, args, cmiReference, e);
                if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                    LOGGER.debug("Object: {0} - Invoke: {1} > onInvokeException=THROW!", this.objectName, methodName, decisionManager.getThrowable());
                    throw decisionManager.getThrowable();
                }
                if (this.clusterViewManager instanceof ClientClusterViewManager && !this.itf.equals(ClientClusterViewProvider.class)) {
                    CMIInvocationHandler cMIInvocationHandler = this;
                    synchronized (cMIInvocationHandler) {
                        LOGGER.debug("Object: {0} - Invoke: {1} > onInvokeException=RETRY, Forcing an update...", this.objectName, methodName);
                        ((ClientClusterViewManager)this.clusterViewManager).pullAndUpdateObjectInfos(this.objectName);
                    }
                }
                cmiReferences = new ArrayList<CMIReference>(this.clusterViewManager.getCMIReferences(this.objectName, this.protocolName));
                LOGGER.debug("Object: {0} - Invoke: {1} > onInvokeException=RETRY, CMIReferences is now: {2}", this.objectName, methodName, cmiReferences);
                LOGGER.debug("Object: {0} - Invoke: {1} > onInvokeException=RETRY, Removing node {2}", this.objectName, methodName, cmiReference);
                cmiReferences.remove(cmiReference);
                this.currentRef = null;
                this.onExceptionHook(this.objectName, cmiReferenceable);
            }
            finally {
                this.onFinallyHook(this.objectName, cmiReferenceable);
            }
            if (decisionManagerOnReturn == null) continue;
            decision = decisionManagerOnReturn.getDecision();
            if (decision.equals((Object)DecisionManager.Decision.RETRY)) {
                LOGGER.debug("Object: {0} - Invoke: {1} > onReturn=RETRY!", this.objectName, method);
                cmiReferences.remove(cmiReference);
                this.currentRef = null;
                decisionManagerOnReturn = null;
                continue;
            }
            if (decision.equals((Object)DecisionManager.Decision.RETURN)) {
                LOGGER.debug("Object: {0} - Invoke: {1} > onReturn=RETURN!", this.objectName, method);
                continue;
            }
            if (!decision.equals((Object)DecisionManager.Decision.THROW)) continue;
            LOGGER.error("Object: {0} - Invoke: {1} > onReturn=THROW!", this.objectName, method, decisionManagerOnReturn.getThrowable());
            throw decisionManagerOnReturn.getThrowable();
        } while (decisionManagerOnReturn == null);
        if (this.cmiProxyHandle != null) {
            this.cmiProxyHandle = this.cmiProxyHandle.updateHttpSession();
        }
        return decisionManagerOnReturn.getRetVal();
    }

    public CMIReferenceable<T> getCurrentRef() {
        return this.currentRef;
    }

    public void setCurrentRef(CMIReferenceable<T> currentRef) {
        this.currentRef = currentRef;
    }

    protected String getHandleMethodName() {
        return "getHandle";
    }

    protected abstract CMIProxyHandle getHandle(CMIProxy var1);

    public void setCmiProxyHandle(CMIProxyHandle cmiProxyHandle) {
        this.cmiProxyHandle = cmiProxyHandle;
    }

    protected abstract CMIReferenceable<T> getCMIReferenceable(CMIReference var1) throws Exception;

    public long getLastInvocDuration() {
        return this.lastInvocDuration;
    }

    protected void preInvokeHook(CMIReferenceable<T> cmiReferenceable) {
    }

    protected void postInvokeHook() {
    }

    protected abstract void onExceptionHook(String var1, CMIReferenceable<T> var2) throws Throwable;

    protected abstract void onFinallyHook(String var1, CMIReferenceable<T> var2);
}

