/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.cmi;

import java.util.List;
import java.util.Properties;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.cmi.CmiComponentProperty;
import org.ow2.easybeans.component.cmi.CmiConfigurationExtension;
import org.ow2.easybeans.server.ServerConfig;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmiComponent
implements EZBComponent {
    private Log logger = LogFactory.getLog(CmiComponent.class);
    private ServerConfig config;
    private boolean lifecycleManaged = true;
    private ServerClusterViewManager clusterViewManager;
    private String mode = CmiComponentProperty.SERVER_MODE_VALUE.getPropertyName();
    private List<String> protocols = null;
    private Properties cmiProperties = new Properties();
    private String contextFactory = CmiComponentProperty.DEFAULT_CMI_INITIAL_CONTEXT_FACTORY.getPropertyName();
    private String cmiPropertiesSetter = CmiComponentProperty.DEFAULT_CMI_PROPERTIES_SETTER_METHOD.getPropertyName();
    private Object cmiMBeanSetter = CmiComponentProperty.DEFAULT_CMI_MBEAN_SETTER_METHOD.getPropertyName();
    private boolean replicationEnabled = true;

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    @Override
    public void init() throws EZBComponentException {
        this.initProperties();
    }

    private void initProperties() {
        this.cmiProperties.put(CmiComponentProperty.SERVER_MODE_KEY.getPropertyName(), (Object)this.mode.equalsIgnoreCase(CmiComponentProperty.SERVER_MODE_VALUE.getPropertyName()));
        this.cmiProperties.put(CmiComponentProperty.CMI_INITIAL_CONTEXT_FACTORY_KEY.getPropertyName(), this.contextFactory);
        this.cmiProperties.put(CmiComponentProperty.CMI_PROPERTIES_SETTER_METHOD_KEY.getPropertyName(), this.cmiPropertiesSetter);
        this.cmiProperties.put(CmiComponentProperty.CMI_MBEAN_SETTER_METHOD_KEY.getPropertyName(), this.cmiMBeanSetter);
        this.cmiProperties.put(CmiComponentProperty.CMI_ENABLE_REPLICATION_KEY.getPropertyName(), (Object)this.replicationEnabled);
        if (this.protocols != null) {
            for (String protocol : this.protocols) {
                String key = CmiComponentProperty.CMI.getPropertyName() + CmiComponentProperty.SEPARATOR.getPropertyName() + protocol + CmiComponentProperty.SEPARATOR.getPropertyName() + CmiComponentProperty.ENABLE.getPropertyName();
                this.cmiProperties.put(key, (Object)true);
            }
        }
    }

    @Override
    public void start() throws EZBComponentException {
        if (this.lifecycleManaged) {
            try {
                ConfigurationRepository.getServerConfiguration().enableCMI(this.cmiProperties);
            }
            catch (Exception e) {
                this.logger.error("Cannot configure Carol to use CMI", e);
                throw new EZBComponentException("Cannot configure Carol to use CMI", e);
            }
            try {
                this.clusterViewManager = AbsServerClusterViewManager.start();
            }
            catch (Exception e) {
                this.logger.error("Cannot start the server-side manager", e);
                throw new EZBComponentException("Cannot start the server-side manager", e);
            }
        }
        this.config.addExtensionFactory(new CmiConfigurationExtension());
        this.logger.debug("The CMI configuration extension has been added.", new Object[0]);
    }

    @Override
    public void stop() throws EZBComponentException {
        if (this.lifecycleManaged) {
            try {
                ConfigurationRepository.getServerConfiguration().disableCMI();
            }
            catch (Exception e) {
                this.logger.error("Cannot disable CMI in Carol", e);
            }
            if (this.clusterViewManager != null) {
                try {
                    ((AbsServerClusterViewManager)this.clusterViewManager).stop();
                }
                catch (Exception e) {
                    this.logger.error("Cannot stop the server-side manager", e);
                    throw new EZBComponentException("Cannot stop the server-side manager", e);
                }
            }
        }
    }

    public ServerConfig getServerConfig() {
        return this.config;
    }

    public void setServerConfig(ServerConfig config) {
        this.config = config;
    }

    public boolean isLifecycleManaged() {
        return this.lifecycleManaged;
    }

    public void setLifecycleManaged(boolean lifecycleManaged) {
        this.lifecycleManaged = lifecycleManaged;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public ServerClusterViewManager getClusterViewManager() {
        return this.clusterViewManager;
    }

    public void setClusterViewManager(ServerClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    public String getInitialContextFactory() {
        return this.contextFactory;
    }

    public void setInitialContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getCmiPropertiesSetter() {
        return this.cmiPropertiesSetter;
    }

    public void setCmiPropertiesSetter(String cmiPropertiesSetter) {
        this.cmiPropertiesSetter = cmiPropertiesSetter;
    }

    public Object getCmiMBeanSetter() {
        return this.cmiMBeanSetter;
    }

    public void setCmiMBeanSetter(String cmiMBeanSetter) {
        this.cmiMBeanSetter = cmiMBeanSetter;
    }

    public void setEnableReplication(String enableReplication) {
        this.replicationEnabled = enableReplication.equalsIgnoreCase("true");
    }

    public boolean isReplicationEnabled() {
        return this.replicationEnabled;
    }
}

