/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.mdb;

import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansMDB;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.container.AbsFactory;
import org.ow2.easybeans.container.info.MessageDrivenInfo;
import org.ow2.easybeans.container.mdb.EasyBeansMDBContext;
import org.ow2.easybeans.rpc.api.EJBRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MDBFactory
extends AbsFactory<EasyBeansMDB>
implements PoolFactory<EasyBeansMDB, Long> {
    private static Log logger = LogFactory.getLog(MDBFactory.class);
    private MessageDrivenInfo messageDrivenInfo = null;

    public MDBFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        this.setPool(new JPool<EasyBeansMDB, Long>(this));
    }

    @Override
    public EJBResponse rpcInvoke(EJBRequest request) {
        return null;
    }

    @Override
    public EJBResponse localCall(long hash, Object[] methodArgs, Long beanId) {
        return null;
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.getPool().stop();
        }
        catch (PoolException e) {
            logger.error("Problem when stopping the factory", e);
        }
    }

    @Override
    public IBeanInfo getBeanInfo() {
        return this.messageDrivenInfo;
    }

    public MessageDrivenInfo getMessageDrivenInfo() {
        return this.messageDrivenInfo;
    }

    public void setMessageDrivenInfo(MessageDrivenInfo messageDrivenInfo) {
        this.messageDrivenInfo = messageDrivenInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EasyBeansMDB create(Long clue) throws PoolException {
        EasyBeansMDB instance = null;
        try {
            instance = (EasyBeansMDB)this.getBeanClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new PoolException("Cannot create a new instance", e);
        }
        catch (IllegalAccessException e) {
            throw new PoolException("Cannot create a new instance", e);
        }
        instance.setEasyBeansFactory(this);
        EasyBeansMDBContext mdbContext = new EasyBeansMDBContext(instance);
        instance.setEasyBeansContext(mdbContext);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            this.injectResources(instance);
            instance.postConstructEasyBeansLifeCycle();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return instance;
    }

    @Override
    public boolean isMatching(EasyBeansMDB object, Long clue) {
        return true;
    }

    @Override
    public boolean validate(EasyBeansMDB object, PoolEntryStatistics stats) {
        return true;
    }
}

