/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.mdb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.ow2.easybeans.api.bean.EasyBeansMDB;
import org.ow2.easybeans.container.mdb.MDBMessageEndPoint;
import org.ow2.easybeans.container.mdb.MDBMessageEndPointFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class MDBMessageListenerEndPoint
extends MDBMessageEndPoint
implements MessageListener {
    private static Log logger = LogFactory.getLog(MDBMessageListenerEndPoint.class);
    private boolean useReflection = false;
    private Method onMessageMethod = null;

    public MDBMessageListenerEndPoint(MDBMessageEndPointFactory mdbMessageEndPointFactory, EasyBeansMDB easyBeansMDB) {
        super(mdbMessageEndPointFactory, easyBeansMDB);
        if (!(easyBeansMDB instanceof MessageListener)) {
            logger.debug("Use reflection for message delivery as instance {0} is not implementing the interface", easyBeansMDB);
            this.useReflection = true;
            try {
                this.onMessageMethod = easyBeansMDB.getClass().getMethod("onMessage", Message.class);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Cannot get the onMessage method on instance '" + easyBeansMDB + "'.", e);
            }
            catch (NoSuchMethodException e) {
                logger.error("No onMessage method found on bean named {0}", easyBeansMDB);
                throw new IllegalArgumentException("Cannot get the onMessage method on instance '" + easyBeansMDB + "'.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block8: {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getEasyBeansFactory().getContainer().getClassLoader());
            try {
                if (!this.useReflection) {
                    ((MessageListener)((Object)this.getEasyBeansMDB())).onMessage(message);
                    break block8;
                }
                try {
                    this.onMessageMethod.invoke((Object)this.getEasyBeansMDB(), message);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Cannot deliver the message", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Cannot deliver the message", e);
                }
                catch (InvocationTargetException e) {
                    logger.error("Cannot deliver the message", e.getTargetException());
                    throw new IllegalStateException("Cannot deliver the message", e.getTargetException());
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }
}

