/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.helper.ResolverHelper;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarDeployableFactory;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.metadata.ejbjar.impl.EjbJarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.EJB3DeploymentDescException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.ScanException;
import org.ow2.util.scan.api.classlocator.ArchiveClassesLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployment {
    private static Log logger = LogFactory.getLog(Deployment.class);
    private IArchive archive = null;
    private List<IArchive> extraArchives = null;
    private EjbJarArchiveMetadata ejbJarArchiveMetadata;
    private EZBContainerConfig configuration;

    public Deployment(IArchive archive) {
        this.archive = archive;
        this.reset();
    }

    public Deployment(EZBContainerConfig configuration) {
        this(configuration.getArchive());
        this.configuration = configuration;
    }

    public void reset() {
        this.ejbJarArchiveMetadata = null;
    }

    public void analyze() throws ScanException, EJB3DeploymentDescException, ResolverException, DeployableHelperException, DeployableMetadataException {
        EjbJarDeployableMetadataFactory<EJB3Deployable> metadataFactory = new EjbJarDeployableMetadataFactory<EJB3Deployable>();
        EjbJarDeployableFactory deployableFactory = new EjbJarDeployableFactory();
        ArrayList<ArchiveClassesLocator> lib = null;
        if (this.extraArchives != null) {
            lib = new ArrayList<ArchiveClassesLocator>();
            for (IArchive archive : this.extraArchives) {
                lib.add(new ArchiveClassesLocator(archive));
            }
        }
        metadataFactory.createDeployableMetadata((EJB3Deployable)DeployableHelper.getDeployable(this.archive, false), lib, Arrays.asList(deployableFactory));
        this.ejbJarArchiveMetadata = deployableFactory.getEzbSpecificWarDeployableMetadata();
        long tResolverStart = System.currentTimeMillis();
        ResolverHelper.resolve(this.ejbJarArchiveMetadata);
        if (logger.isDebugEnabled()) {
            long tResolverEnd = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Resolver on metadata from {0} took {1} ms.'", this.archive.getName(), tResolverEnd - tResolverStart);
            }
        }
        if (logger.isDebugEnabled()) {
            for (EjbJarClassMetadata classAnnotationMetadata : this.ejbJarArchiveMetadata.getEjbJarClassMetadataCollection()) {
                logger.debug("Result for class = " + classAnnotationMetadata, new Object[0]);
            }
        }
    }

    public EjbJarArchiveMetadata getEjbJarArchiveMetadata() {
        return this.ejbJarArchiveMetadata;
    }

    public void setExtraArchives(List<IArchive> extraArchives) {
        this.extraArchives = extraArchives;
    }

    public IArchive getArchive() {
        return this.archive;
    }

    public EZBContainerConfig getConfiguration() {
        return this.configuration;
    }
}

