/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JRemove;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EJB21Finder {
    private static final JMethod REMOVE_METHOD = new JMethod(1, "remove", "()V", null, new String[]{"javax/ejb/RemoveException"});
    private static final JMethod ISIDENTICAL_METHOD = new JMethod(1, "isIdentical", "(Ljavax/ejb/EJBObject;)Z", null, new String[]{"java/rmi/RemoteException"});
    private static final JMethod ISIDENTICAL_LOCAL_METHOD = new JMethod(1, "isIdentical", "(Ljavax/ejb/EJBLocalObject;)Z", null, new String[]{"javax/ejb/EJBException"});
    private static final JMethod GETHANDLE_METHOD = new JMethod(1, "getHandle", "()Ljavax/ejb/Handle;", null, new String[]{"java/rmi/RemoteException"});
    private static final JMethod GETPRIMARYKEY_METHOD = new JMethod(1, "getPrimaryKey", "()Ljava/lang/Object;", null, null);

    private EJB21Finder() {
    }

    public static void resolve(EjbJarClassMetadata bean) {
        String remoteHome = bean.getRemoteHome();
        String localHome = bean.getLocalHome();
        if (remoteHome == null && localHome == null) {
            return;
        }
        EjbJarArchiveMetadata ejbJarAnnotationMetadata = bean.getEjbJarArchiveMetadata();
        ArrayList<String> interfacesList = new ArrayList<String>();
        if (remoteHome != null) {
            EJB21Finder.getInterfacesFromHome(remoteHome, interfacesList, ejbJarAnnotationMetadata);
        }
        if (localHome != null) {
            EJB21Finder.getInterfacesFromHome(localHome, interfacesList, ejbJarAnnotationMetadata);
        }
        for (String itf : interfacesList) {
            EjbJarClassMetadata interfaceUsed = ejbJarAnnotationMetadata.getEjbJarClassMetadata(itf);
            if (interfaceUsed == null) {
                throw new IllegalStateException("Cannot find the metadata for the class '" + itf + "' referenced in the home/localhome of the bean '" + bean.getClassName() + "'.");
            }
            for (EjbJarMethodMetadata methodData : interfaceUsed.getSpecificMethodMetadataCollection()) {
                JMethod itfMethod = methodData.getJMethod();
                if (itfMethod.getName().equals("<clinit>") || itfMethod.getName().equals("<init>")) continue;
                EjbJarMethodMetadata beanMethod = (EjbJarMethodMetadata)bean.getSpecificMethodMetadata(itfMethod);
                if (beanMethod == null) {
                    throw new IllegalStateException("No method was found for method " + itfMethod + " in class " + bean.getClassName());
                }
                beanMethod.setBusinessMethod(true);
            }
        }
        EjbJarMethodMetadata metadataRemove = (EjbJarMethodMetadata)bean.getSpecificMethodMetadata(REMOVE_METHOD);
        if (metadataRemove == null) {
            metadataRemove = new EjbJarMethodMetadata(REMOVE_METHOD, bean);
            bean.addSpecificMethodMetadata(metadataRemove);
        }
        metadataRemove.setRemove(new JRemove());
        metadataRemove.setBusinessMethod(true);
        bean.addSpecificMethodMetadata(new EjbJarMethodMetadata(ISIDENTICAL_METHOD, bean));
        bean.addSpecificMethodMetadata(new EjbJarMethodMetadata(ISIDENTICAL_LOCAL_METHOD, bean));
        bean.addSpecificMethodMetadata(new EjbJarMethodMetadata(GETHANDLE_METHOD, bean));
        bean.addSpecificMethodMetadata(new EjbJarMethodMetadata(GETPRIMARYKEY_METHOD, bean));
    }

    private static void getInterfacesFromHome(String home, List<String> interfacesList, EjbJarArchiveMetadata ejbJarAnnotationMetadata) {
        String encodedname = home.replace(".", "/");
        EjbJarClassMetadata homeMetadata = ejbJarAnnotationMetadata.getEjbJarClassMetadata(encodedname);
        if (homeMetadata == null) {
            throw new IllegalStateException("Cannot find the class '" + home + "' referenced as an home/localhome interface");
        }
        for (EjbJarMethodMetadata method : homeMetadata.getSpecificMethodMetadataCollection()) {
            JMethod jMethod;
            Type returnType;
            String returnTypeClassname;
            if (!method.getMethodName().startsWith("create") || interfacesList.contains(returnTypeClassname = (returnType = Type.getReturnType((jMethod = method.getJMethod()).getDescriptor())).getClassName())) continue;
            interfacesList.add(returnTypeClassname.replace(".", "/"));
        }
        String[] interfaces = homeMetadata.getInterfaces();
        if (interfaces != null) {
            for (String itf : interfaces) {
                if ("javax/ejb/EJBHome".equals(itf) || "javax/ejb/EJBLocalHome".equals(itf)) continue;
                EJB21Finder.getInterfacesFromHome(itf, interfacesList, ejbJarAnnotationMetadata);
            }
        }
    }
}

