/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.metadata.ejbjar;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ow2.easybeans.deployment.annotations.exceptions.InterceptorsValidationException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarFieldMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarMethodMetadata;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarClassMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarFieldMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.InterceptorType;
import org.ow2.util.ee.metadata.ejbjar.impl.specific.SpecificEjbJarClassMetadata;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.IPoolMetadata;
import org.ow2.util.scan.api.metadata.IClassMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarClassMetadata
extends SpecificEjbJarClassMetadata<EJB3Deployable, EjbJarClassMetadata, EjbJarMethodMetadata, EjbJarFieldMetadata>
implements IPoolMetadata {
    private EjbJarArchiveMetadata ejbJarArchiveMetadata;
    private List<String> inheritedInterfaces = null;
    private List<EjbJarMethodMetadata> aroundInvokeMethodsMetadata = null;
    private LinkedList<EjbJarMethodMetadata> postConstructMethodsMetadata = new LinkedList();
    private LinkedList<EjbJarMethodMetadata> preDestroyMethodsMetadata = new LinkedList();
    private LinkedList<EjbJarMethodMetadata> postActivateMethodsMetadata = new LinkedList();
    private LinkedList<EjbJarMethodMetadata> prePassivateMethodsMetadata = new LinkedList();
    private IPoolConfiguration poolConfiguration;

    public EjbJarClassMetadata(IEjbJarClassMetadata<EJB3Deployable> warClassMetadata) {
        super(warClassMetadata);
        this.inheritedInterfaces = new ArrayList<String>();
    }

    public EjbJarArchiveMetadata getEjbJarArchiveMetadata() {
        return this.ejbJarArchiveMetadata;
    }

    public boolean isAroundInvokeMethodMetadata() {
        return this.aroundInvokeMethodsMetadata != null;
    }

    public List<EjbJarMethodMetadata> getAroundInvokeMethodMetadatas() {
        return this.aroundInvokeMethodsMetadata;
    }

    public void addAroundInvokeMethodMetadata(EjbJarMethodMetadata aroundInvokeMethodMetadata) {
        if (this.aroundInvokeMethodsMetadata == null) {
            this.aroundInvokeMethodsMetadata = new ArrayList<EjbJarMethodMetadata>();
        }
        this.aroundInvokeMethodsMetadata.add(aroundInvokeMethodMetadata);
    }

    public LinkedList<EjbJarMethodMetadata> getPostConstructMethodsMetadata() {
        return this.postConstructMethodsMetadata;
    }

    public void addPostConstructMethodMetadata(EjbJarMethodMetadata postConstructMethodMetadata) {
        this.checkLifeCycleDuplicate(postConstructMethodMetadata, InterceptorType.POST_CONSTRUCT, this.getPostConstructMethodsMetadata());
        this.postConstructMethodsMetadata.addFirst(postConstructMethodMetadata);
    }

    private void checkLifeCycleDuplicate(EjbJarMethodMetadata postConstructMethodMetadata, InterceptorType itcType, List<EjbJarMethodMetadata> existingList) {
        EjbJarClassMetadata wantToAddClassMetadata = postConstructMethodMetadata.getSpecificClassMetadata();
        if (postConstructMethodMetadata.isInherited()) {
            wantToAddClassMetadata = postConstructMethodMetadata.getOriginalClassMetadata();
        }
        for (EjbJarMethodMetadata method : existingList) {
            IClassMetadata<IEjbJarClassMetadata<EJB3Deployable>, IEjbJarMethodMetadata<EJB3Deployable>, IEjbJarFieldMetadata<EJB3Deployable>> compareMetaData = method.isInherited() ? method.getOriginalClassMetadata() : method.getClassMetadata();
            if (!compareMetaData.equals(wantToAddClassMetadata)) continue;
            throw new InterceptorsValidationException("Class " + this.getClassName() + " has already a " + (Object)((Object)itcType) + " method which is " + method.getMethodName() + ", cannot set new method " + postConstructMethodMetadata.getMethodName());
        }
    }

    public LinkedList<EjbJarMethodMetadata> getPreDestroyMethodsMetadata() {
        return this.preDestroyMethodsMetadata;
    }

    public void addPreDestroyMethodMetadata(EjbJarMethodMetadata preDestroyMethodMetadata) {
        this.checkLifeCycleDuplicate(preDestroyMethodMetadata, InterceptorType.PRE_DESTROY, this.getPreDestroyMethodsMetadata());
        this.preDestroyMethodsMetadata.addFirst(preDestroyMethodMetadata);
    }

    public LinkedList<EjbJarMethodMetadata> getPostActivateMethodsMetadata() {
        return this.postActivateMethodsMetadata;
    }

    public void addPostActivateMethodMetadata(EjbJarMethodMetadata postActivateMethodMetadata) {
        this.checkLifeCycleDuplicate(postActivateMethodMetadata, InterceptorType.POST_ACTIVATE, this.getPostActivateMethodsMetadata());
        this.postActivateMethodsMetadata.addFirst(postActivateMethodMetadata);
    }

    public LinkedList<EjbJarMethodMetadata> getPrePassivateMethodsMetadata() {
        return this.prePassivateMethodsMetadata;
    }

    public void addPrePassivateMethodMetadata(EjbJarMethodMetadata prePassivateMethodMetadata) {
        this.checkLifeCycleDuplicate(prePassivateMethodMetadata, InterceptorType.PRE_PASSIVATE, this.getPrePassivateMethodsMetadata());
        this.prePassivateMethodsMetadata.addFirst(prePassivateMethodMetadata);
    }

    public boolean isInterceptor() {
        return this.aroundInvokeMethodsMetadata != null && this.aroundInvokeMethodsMetadata.size() > 0 || this.postConstructMethodsMetadata != null && this.postConstructMethodsMetadata.size() > 0 || this.preDestroyMethodsMetadata != null && this.preDestroyMethodsMetadata.size() > 0 || this.prePassivateMethodsMetadata != null && this.prePassivateMethodsMetadata.size() > 0 || this.postActivateMethodsMetadata != null && this.postActivateMethodsMetadata.size() > 0;
    }

    @Override
    public IPoolConfiguration getPoolConfiguration() {
        return this.poolConfiguration;
    }

    @Override
    public void setPoolConfiguration(IPoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
    }

    public void setSpecificDeployableMetadata(EjbJarArchiveMetadata warDeployableMetadata) {
        this.ejbJarArchiveMetadata = warDeployableMetadata;
    }

    @Override
    public void addStandardMethodMetadata(IEjbJarMethodMetadata<EJB3Deployable> methodAnnotationMetadata) {
        throw new IllegalStateException("please use add Specific method metadata");
    }

    @Override
    public void addStandardFieldMetadata(IEjbJarFieldMetadata<EJB3Deployable> fieldAnnotationMetadata) {
        throw new IllegalStateException("please use add Specific method metadata");
    }

    public List<String> getInheritedInterfaces() {
        return this.inheritedInterfaces;
    }

    public void setInheritedInterfaces(List<String> inheritedInterfaces) {
        this.inheritedInterfaces = inheritedInterfaces;
    }
}

