/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.transaction.interceptors;

import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.ow2.easybeans.api.EasyBeansInterceptor;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.easybeans.transaction.JTransactionManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.api.PoolException;

public abstract class AbsTransactionInterceptor
implements EasyBeansInterceptor {
    private Log logger = LogFactory.getLog(AbsTransactionInterceptor.class);
    private TransactionManager transactionManager = JTransactionManager.getTransactionManager();

    public abstract Object intercept(EasyBeansInvocationContext var1) throws Exception;

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected ApplicationException getApplicationException(EasyBeansInvocationContext invocationContext, Exception e) {
        Class<?>[] exceptions;
        Map<String, ApplicationException> applicationExceptions = invocationContext.getFactory().getBeanInfo().getApplicationExceptions();
        ApplicationException appException = applicationExceptions.get(e.getClass().getName());
        if (appException != null) {
            return appException;
        }
        if (e instanceof RuntimeException) {
            return null;
        }
        Method method = invocationContext.getMethod();
        if (method != null && (exceptions = method.getExceptionTypes()) != null) {
            for (Class<?> clazz : exceptions) {
                if (!clazz.isInstance(e) || e instanceof RuntimeException) continue;
                return applicationExceptions.get("DEFAULT");
            }
        }
        return null;
    }

    protected void discard(EasyBeansInvocationContext invocationContext) throws PoolException {
        Object target = invocationContext.getTarget();
        if (target instanceof EasyBeansSFSB) {
            Factory factory = invocationContext.getFactory();
            Pool pool = factory.getPool();
            EasyBeansSFSB bean = (EasyBeansSFSB)invocationContext.getTarget();
            pool.discard(bean);
        } else {
            this.logger.debug("Instance not discarded as it is not a stateful bean", new Object[0]);
        }
    }

    protected void markTransactionRollback() {
        Transaction transaction;
        try {
            transaction = this.getTransactionManager().getTransaction();
        }
        catch (SystemException se) {
            throw new EJBException("Cannot get the current transaction on transaction manager.", se);
        }
        if (transaction != null) {
            try {
                this.transactionManager.setRollbackOnly();
            }
            catch (IllegalStateException e) {
                this.logger.warn("Cannot mark transaction as rollbackOnly", e);
            }
            catch (SystemException e) {
                this.logger.warn("Cannot mark transaction as rollbackOnly", e);
            }
        }
    }

    protected boolean isMarkedRollbackOnly() {
        try {
            return 1 == this.transactionManager.getStatus();
        }
        catch (SystemException e) {
            this.logger.warn("Cannot get transaction status", e);
            return false;
        }
    }

    protected void rollback() {
        try {
            this.transactionManager.rollback();
        }
        catch (IllegalStateException e) {
            this.logger.warn("Cannot rollback the transaction", e);
        }
        catch (SecurityException e) {
            this.logger.warn("Cannot rollback the transaction", e);
        }
        catch (SystemException e) {
            this.logger.warn("Cannot rollback the transaction", e);
        }
    }

    protected void commit() {
        try {
            this.transactionManager.commit();
        }
        catch (IllegalStateException e) {
            this.logger.warn("Cannot commit the transaction", e);
        }
        catch (SecurityException e) {
            this.logger.warn("Cannot commit the transaction", e);
        }
        catch (HeuristicMixedException e) {
            this.logger.warn("Cannot commit the transaction", e);
        }
        catch (HeuristicRollbackException e) {
            this.logger.warn("Cannot commit the transaction", e);
        }
        catch (RollbackException e) {
            this.logger.warn("Cannot commit the transaction", e);
        }
        catch (SystemException e) {
            this.logger.warn("Cannot commit the transaction", e);
        }
    }

    protected void handleBeanManagedException(EasyBeansInvocationContext invocationContext, Exception e) throws Exception {
        ApplicationException applicationException = this.getApplicationException(invocationContext, e);
        if (applicationException != null) {
            throw e;
        }
        this.logger.error("Bean Managed Transaction : Exception (not application exception) in business method", e);
        this.markTransactionRollback();
        try {
            this.discard(invocationContext);
        }
        catch (PoolException pe) {
            throw new EJBException("Cannot discard the bean", pe);
        }
        throw new EJBException("Bean Managed Transaction : Business exception which is not an application exception", e);
    }

    protected void handleUnspecifiedTransactionContext(EasyBeansInvocationContext invocationContext, Exception e) throws Exception {
        ApplicationException applicationException = this.getApplicationException(invocationContext, e);
        if (applicationException != null) {
            throw e;
        }
        this.logger.error("Exception (not application exception) in business method", e);
        try {
            this.discard(invocationContext);
        }
        catch (PoolException pe) {
            throw new EJBException("Cannot discard the bean", pe);
        }
        throw new EJBException("Business exception which is not an application exception", e);
    }

    protected void handleContextClientTransaction(EasyBeansInvocationContext invocationContext, Exception e) throws Exception {
        ApplicationException applicationException = this.getApplicationException(invocationContext, e);
        if (applicationException != null) {
            if (applicationException.rollback()) {
                this.markTransactionRollback();
            }
            throw e;
        }
        this.logger.error("Exception (not application exception) in business method", e);
        this.markTransactionRollback();
        try {
            this.discard(invocationContext);
        }
        catch (PoolException pe) {
            throw new EJBException("Cannot discard the bean", pe);
        }
        EJBTransactionRolledbackException transactionException = new EJBTransactionRolledbackException("System exception, The transaction has been marked for rollback only");
        transactionException.initCause(e);
        throw transactionException;
    }

    protected void handleContextContainerTransaction(EasyBeansInvocationContext invocationContext, Exception e) throws Exception {
        ApplicationException applicationException = this.getApplicationException(invocationContext, e);
        if (applicationException != null) {
            if (this.isMarkedRollbackOnly()) {
                this.rollback();
                throw e;
            }
            if (applicationException.rollback()) {
                this.rollback();
            } else {
                this.commit();
            }
            throw e;
        }
        this.logger.error("Exception (not application exception) in business method", e);
        this.rollback();
        try {
            this.discard(invocationContext);
        }
        catch (PoolException pe) {
            throw new EJBException("Cannot discard the bean", pe);
        }
        throw new EJBException("Exception in a business interface with REQUIRED TX attribute", e);
    }
}

