/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ear.lib;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.common.lib.AbsDeploymentDescManager;
import org.ow2.jonas.deployment.ear.EarDTDs;
import org.ow2.jonas.deployment.ear.EarDeploymentDesc;
import org.ow2.jonas.deployment.ear.EarDeploymentDescException;
import org.ow2.jonas.deployment.ear.EarSchemas;
import org.ow2.jonas.deployment.ear.JonasEarSchemas;
import org.ow2.jonas.deployment.ear.rules.ApplicationRuleSet;
import org.ow2.jonas.deployment.ear.rules.JonasApplicationRuleSet;
import org.ow2.jonas.deployment.ear.xml.Application;
import org.ow2.jonas.deployment.ear.xml.JonasApplication;
import org.ow2.jonas.deployment.ear.xml.Module;
import org.ow2.jonas.deployment.ear.xml.Web;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;

public final class EarDeploymentDescManager
extends AbsDeploymentDescManager {
    public static final String APPLICATION_FILE_NAME = "META-INF/application.xml";
    public static final String JONAS_APPLICATION_FILE_NAME = "META-INF/jonas-application.xml";
    private static JDigester earDigester = null;
    private static JDigester jonasEarDigester = null;
    private static ApplicationRuleSet appRuleSet = new ApplicationRuleSet();
    private static JonasApplicationRuleSet jonasApplicationRuleSet = new JonasApplicationRuleSet();
    private static Logger logger = Log.getLogger("org.ow2.jonas.ear");
    private static boolean parsingWithValidation = true;

    private EarDeploymentDescManager() {
    }

    public static EarDeploymentDesc getDeploymentDesc(EARDeployable earDeployable, ClassLoader classLoaderForCls) throws EarDeploymentDescException {
        URL jonasApplicationXMLURL;
        URL applicationXMLURL;
        Reader appReader = null;
        Reader jonasApplicationReader = null;
        Application application = null;
        JonasApplication jonasApplication = null;
        String xmlContent = "";
        String jonasXmlContent = "";
        IArchive archive = earDeployable.getArchive();
        try {
            applicationXMLURL = archive.getResource(APPLICATION_FILE_NAME);
        }
        catch (ArchiveException e) {
            throw new EarDeploymentDescException("Cannot get entry 'META-INF/application.xml' from the archive '" + archive + "'.", e);
        }
        if (applicationXMLURL != null) {
            URLConnection urlConnection = null;
            try {
                urlConnection = applicationXMLURL.openConnection();
            }
            catch (IOException e) {
                throw new EarDeploymentDescException("Unable to open connection on URL '" + applicationXMLURL + "'.", e);
            }
            urlConnection.setDefaultUseCaches(false);
            try {
                xmlContent = EarDeploymentDescManager.xmlContent(urlConnection.getInputStream());
                appReader = new StringReader(xmlContent);
            }
            catch (IOException e) {
                throw new EarDeploymentDescException("Unable to get Stream on URL '" + applicationXMLURL + "'.", e);
            }
        }
        try {
            jonasApplicationXMLURL = archive.getResource(JONAS_APPLICATION_FILE_NAME);
        }
        catch (ArchiveException e) {
            throw new EarDeploymentDescException("Cannot get entry 'META-INF/jonas-application.xml' from the archive '" + archive + "'.", e);
        }
        if (jonasApplicationXMLURL != null) {
            URLConnection urlConnection = null;
            try {
                urlConnection = jonasApplicationXMLURL.openConnection();
            }
            catch (IOException e) {
                throw new EarDeploymentDescException("Unable to open connection on URL '" + applicationXMLURL + "'.", e);
            }
            urlConnection.setDefaultUseCaches(false);
            try {
                jonasXmlContent = EarDeploymentDescManager.xmlContent(urlConnection.getInputStream());
                jonasApplicationReader = new StringReader(jonasXmlContent);
            }
            catch (IOException e) {
                throw new EarDeploymentDescException("Unable to get Stream on URL '" + applicationXMLURL + "'.", e);
            }
        }
        if (appReader != null) {
            application = EarDeploymentDescManager.loadApplication(appReader, APPLICATION_FILE_NAME);
            try {
                appReader.close();
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot close InputStream for META-INF/application.xml in '" + earDeployable + "'"));
            }
        } else {
            application = new Application();
            URL earDeployableURL = null;
            try {
                earDeployableURL = earDeployable.getArchive().getURL();
            }
            catch (ArchiveException e) {
                throw new EarDeploymentDescException("Cannot get URL for the deployable for the archive '" + archive + "'", e);
            }
            if (earDeployable != null) {
                Module m;
                for (CARDeployable cARDeployable : earDeployable.getCARDeployables()) {
                    m = new Module();
                    try {
                        m.setJava(cARDeployable.getArchive().getURL().toExternalForm().substring(earDeployableURL.toExternalForm().length()));
                    }
                    catch (ArchiveException e) {
                        throw new EarDeploymentDescException("Cannot get URL for the deployable for the deployable '" + cARDeployable + "'", e);
                    }
                    application.addModule(m);
                }
                for (WARDeployable wARDeployable : earDeployable.getWARDeployables()) {
                    Web web = new Web();
                    web.setContextRoot(wARDeployable.getContextRoot());
                    try {
                        web.setWebUri(wARDeployable.getArchive().getURL().toExternalForm().substring(earDeployableURL.toExternalForm().length()));
                    }
                    catch (ArchiveException e) {
                        throw new EarDeploymentDescException("Cannot get URL for the deployable for the deployable '" + wARDeployable + "'", e);
                    }
                    Module m2 = new Module();
                    m2.setWeb(web);
                    application.addModule(m2);
                }
                for (EJBDeployable eJBDeployable : earDeployable.getEJBDeployables()) {
                    m = new Module();
                    try {
                        m.setEjb(eJBDeployable.getArchive().getURL().toExternalForm().substring(earDeployableURL.toExternalForm().length()));
                    }
                    catch (ArchiveException e) {
                        throw new EarDeploymentDescException("Cannot get URL for the deployable for the deployable '" + eJBDeployable + "'", e);
                    }
                    application.addModule(m);
                }
                for (RARDeployable rARDeployable : earDeployable.getRARDeployables()) {
                    m = new Module();
                    try {
                        m.setEjb(rARDeployable.getArchive().getURL().toExternalForm().substring(earDeployableURL.toExternalForm().length()));
                    }
                    catch (ArchiveException e) {
                        throw new EarDeploymentDescException("Cannot get URL for the deployable for the deployable '" + rARDeployable + "'", e);
                    }
                    application.addModule(m);
                }
            }
        }
        if (jonasApplicationReader != null) {
            jonasApplication = EarDeploymentDescManager.loadJonasApplication(jonasApplicationReader, JONAS_APPLICATION_FILE_NAME);
            try {
                jonasApplicationReader.close();
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot close InputStream for '" + earDeployable + "'"));
            }
        } else {
            jonasApplication = new JonasApplication();
        }
        EarDeploymentDesc earDD = new EarDeploymentDesc(classLoaderForCls, application, jonasApplication);
        earDD.setXmlContent(xmlContent);
        earDD.setJonasXmlContent(jonasXmlContent);
        return earDD;
    }

    public static Application loadApplication(Reader reader, String fileName) throws EarDeploymentDescException {
        Application app = new Application();
        if (earDigester == null) {
            try {
                earDigester = new JDigester(appRuleSet, EarDeploymentDescManager.getParsingWithValidation(), true, new EarDTDs(), new EarSchemas());
            }
            catch (DeploymentDescException e) {
                throw new EarDeploymentDescException(e);
            }
        }
        try {
            earDigester.parse(reader, fileName, app);
        }
        catch (DeploymentDescException e) {
            throw new EarDeploymentDescException(e);
        }
        finally {
            earDigester.push(null);
        }
        return app;
    }

    public static JonasApplication loadJonasApplication(Reader reader, String fileName) throws EarDeploymentDescException {
        JonasApplication ja = new JonasApplication();
        if (jonasEarDigester == null) {
            try {
                jonasEarDigester = new JDigester(jonasApplicationRuleSet, EarDeploymentDescManager.getParsingWithValidation(), true, null, new JonasEarSchemas());
            }
            catch (DeploymentDescException e) {
                throw new EarDeploymentDescException(e);
            }
        }
        try {
            jonasEarDigester.parse(reader, fileName, ja);
        }
        catch (DeploymentDescException e) {
            throw new EarDeploymentDescException(e);
        }
        finally {
            jonasEarDigester.push(null);
        }
        return ja;
    }

    public static boolean getParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean validation) {
        parsingWithValidation = validation;
    }
}

