/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import java.util.jar.Manifest;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.AbsArchive;

public class FileArchive
extends AbsArchive {
    public FileArchive(File archive) throws GenBaseException {
        super(archive);
        try {
            File mf = new File(archive, "META-INF" + File.separator + "MANIFEST.MF");
            if (mf.exists()) {
                FileInputStream is = new FileInputStream(mf);
                this.setManifest(new Manifest(is));
                ((InputStream)is).close();
            } else {
                this.setManifest(new Manifest());
            }
        }
        catch (Exception e) {
            String err = FileArchive.getI18n().getMessage("FileArchive.constr.manifest", this.getRootFile());
            throw new GenBaseException(err, e);
        }
    }

    public InputStream getInputStream(String filename) throws IOException {
        File file = (File)this.getFiles().get(filename);
        if (file == null && !(file = new File(this.getRootFile(), filename)).exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    public List getContainedFiles() {
        Vector list = new Vector(this.getFiles().keySet());
        FileArchive.traverse("", this.getRootFile(), list);
        return list;
    }

    private static void traverse(String dirName, File base, List map) {
        File[] childs = base.listFiles();
        if (childs != null) {
            for (int i = 0; i < childs.length; ++i) {
                if (childs[i].isFile()) {
                    map.add(dirName + childs[i].getName());
                    continue;
                }
                FileArchive.traverse(dirName + childs[i].getName() + File.separator, childs[i], map);
            }
        }
    }

    public boolean isPacked() {
        return false;
    }
}

