/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.bootstrap;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.util.StringTokenizer;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;

public class RemoteClassLoaderSpi
extends RMIClassLoaderSpi {
    private static boolean carolIsInitialized = false;
    private static boolean carolIsOptimized = false;
    private final RMIClassLoaderSpi defaultProvider = RMIClassLoader.getDefaultProviderInstance();

    public Class loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        return this.defaultProvider.loadClass(RemoteClassLoaderSpi.normalizeCodebase(codebase), name, defaultLoader);
    }

    public Class loadProxyClass(String codebase, String[] interfaces, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        return this.defaultProvider.loadProxyClass(RemoteClassLoaderSpi.normalizeCodebase(codebase), interfaces, defaultLoader);
    }

    public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        return this.defaultProvider.getClassLoader(RemoteClassLoaderSpi.normalizeCodebase(codebase));
    }

    public String getClassAnnotation(Class cl) {
        String sValue;
        ClassLoader loader = cl.getClassLoader();
        if (!carolIsInitialized && !(sValue = System.getProperty("rmi.local.registry", "init")).equals("init")) {
            carolIsOptimized = new Boolean(sValue);
            carolIsInitialized = true;
        }
        if (loader instanceof JClassLoader) {
            return null;
        }
        if (loader instanceof URLClassLoader && carolIsOptimized) {
            return null;
        }
        return this.defaultProvider.getClassAnnotation(cl);
    }

    static String normalizeCodebase(String input) throws MalformedURLException {
        if (input == null) {
            return null;
        }
        StringBuffer codebase = new StringBuffer();
        StringBuffer current = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(input, " \t\n\r\f", false);
        while (stok.hasMoreTokens()) {
            String item = stok.nextToken();
            if (item.length() < 1) continue;
            if (item.indexOf(58) != -1) {
                RemoteClassLoaderSpi.onGotURL(current, codebase);
            } else {
                current.append(' ');
            }
            current.append(item);
        }
        RemoteClassLoaderSpi.onGotURL(current, codebase);
        if (codebase.length() > 0) {
            return codebase.toString();
        }
        return null;
    }

    static void onGotURL(StringBuffer current, StringBuffer codebase) throws MalformedURLException {
        URL url;
        if (current.length() < 1) {
            return;
        }
        String currentToString = current.toString();
        try {
            url = new URI(new URL(currentToString).toString()).toURL();
        }
        catch (URISyntaxException e) {
            try {
                url = new URI(new URL(currentToString.replaceAll("\\ ", "%20")).toString()).toURL();
            }
            catch (URISyntaxException ie) {
                url = null;
            }
        }
        if (url != null) {
            if (codebase.length() > 0) {
                codebase.append(' ');
            }
            codebase.append(url.toString());
            current.setLength(0);
        }
    }
}

