/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.TimerService;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.lib.ejb21.JContext;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntityLocal;
import org.ow2.jonas.lib.ejb21.JEntityRemote;
import org.ow2.jonas.lib.ejb21.JEntitySwitch;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public class JEntityContext
extends JContext
implements EntityContext,
Synchronization {
    private boolean dirty = false;
    private boolean initialized = false;
    Transaction beanCoord = null;
    private boolean mustnotifywriting = false;
    private JEntitySwitch bs = null;
    boolean ismarkedremoved;
    boolean isnewinstance = false;

    public Transaction getMyTx() {
        return this.beanCoord;
    }

    public JEntityContext(JEntityFactory bf, EntityBean eb) {
        super(bf, eb);
    }

    public TimerService getTimerService() throws IllegalStateException {
        int mystate = this.getState();
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("" + mystate));
        }
        switch (mystate) {
            case 0: {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"not allowed here");
                throw new IllegalStateException("getTimerService not allowed here");
            }
            case 4: {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"not allowed here");
                throw new IllegalStateException("getTimerService not allowed here");
            }
            case 1: {
                return this.bf.getTimerService();
            }
        }
        return this.bs == null ? this.bf.getTimerService() : this.bs.getEntityTimerService();
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.ismarkedremoved) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"marked removed");
            throw new IllegalStateException("EJB is removed");
        }
        if (this.bs == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("no EntitySwitch for " + this));
            throw new IllegalStateException("no EntitySwitch");
        }
        JEntityRemote ejbobject = this.bs.getRemote();
        if (ejbobject == null) {
            throw new IllegalStateException("No Remote Interface for " + this);
        }
        return ejbobject;
    }

    private EJBLocalObject getEJBLocalObject(boolean check) throws IllegalStateException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (check && !this.bf.dd.hasDefinedLocalInterface()) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"No Local Interface declared for this bean");
            throw new IllegalStateException("No Local Interface declared for this bean");
        }
        if (this.ismarkedremoved) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("marked removed: " + this));
            throw new IllegalStateException("EJB is removed");
        }
        if (this.bs == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("no EntitySwitch for " + this));
            throw new IllegalStateException("no EntitySwitch");
        }
        JEntityLocal ejblocalobject = this.bs.getLocal();
        if (ejblocalobject == null) {
            throw new IllegalStateException("No Local Object for " + this);
        }
        return ejblocalobject;
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        return this.getEJBLocalObject(true);
    }

    public EJBLocalObject get2EJBLocalObject() throws IllegalStateException {
        return this.getEJBLocalObject(false);
    }

    public Object getPrimaryKey() throws IllegalStateException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.ismarkedremoved) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("marked removed : " + this));
            throw new IllegalStateException("EJB is removed");
        }
        if (this.bs == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("no EntitySwitch : " + this));
            throw new IllegalStateException("no EntitySwitch");
        }
        return this.bs.getPrimaryKey();
    }

    public void beforeCompletion() {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.ismarkedremoved) {
            if (TraceEjb.isDebugContext()) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)"ismarkedremoved -> no ejbStore");
            }
            return;
        }
        if (this.beanCoord == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("no tx for " + this.bs.getPrimaryKey()));
            return;
        }
        if (this.isnewinstance) {
            try {
                if (this.getPrimaryKey() == null) {
                    return;
                }
            }
            catch (IllegalStateException e) {
                return;
            }
        }
        try {
            this.storeIfModified();
        }
        catch (EJBException e) {
            this.abortTransaction();
        }
    }

    public void afterCompletion(int status) {
        boolean committed;
        boolean bl = committed = status == 3;
        if (TraceEjb.isDebugContext()) {
            if (committed) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)("committed:" + this.bs.getPrimaryKey()));
            } else {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)("rolledback:" + this.bs.getPrimaryKey()));
            }
        }
        if (this.beanCoord == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("no tx for " + this.bs.getPrimaryKey()));
            return;
        }
        if (this.bs == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("Context without EntitySwitch reference: " + this));
            throw new EJBException("Context with no Entity Switch");
        }
        this.bs.txCompleted(this.beanCoord, committed);
    }

    public void razEntityContext() {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bs = null;
        this.beanCoord = null;
        this.ismarkedremoved = false;
        this.isnewinstance = false;
        this.initialized = false;
    }

    public void detachTx() {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        this.beanCoord = null;
        this.ismarkedremoved = false;
        this.isnewinstance = false;
    }

    public boolean initEntityContext(JEntitySwitch bs) {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        this.setEntitySwitch(bs);
        this.initialized = true;
        return this.dirty;
    }

    public boolean setRunningTx(Transaction tx) {
        TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        if (tx != null && this.beanCoord != null) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"Already associated");
            return false;
        }
        if (this.bs == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("no Entity Switch for " + this));
            throw new EJBException("No Entity Switch for this EJBContext");
        }
        this.beanCoord = tx;
        return true;
    }

    public void reuseEntityContext(boolean newtrans) {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.ismarkedremoved) {
            TraceEjb.context.log(BasicLevel.WARN, (Object)"Try to access a deleted object");
            throw new NoSuchObjectLocalException("Instance has been removed");
        }
        if (newtrans) {
            this.isnewinstance = false;
        }
        if (this.bs == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("no Entity Switch for " + this));
            throw new EJBException("Internal Error");
        }
    }

    public void setNewInstance() {
        this.isnewinstance = true;
    }

    public void setRemoved() throws RemoteException, RemoveException {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        EntityBean eb = (EntityBean)this.myinstance;
        if (this.myinstance == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"null instance!");
            return;
        }
        this.setDirty(true);
        eb.ejbRemove();
        this.ismarkedremoved = true;
    }

    public boolean isMarkedRemoved() {
        return this.ismarkedremoved;
    }

    public boolean isNewInstance() {
        return this.isnewinstance;
    }

    public EntityBean getInstance() throws RemoteException {
        if (this.myinstance == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"null!");
            throw new RemoteException("No instance available");
        }
        return (EntityBean)this.myinstance;
    }

    public JEntityFactory getEntityFactory() {
        return (JEntityFactory)this.bf;
    }

    public JEntitySwitch getEntitySwitch() {
        if (this.bs == null) {
            TraceEjb.logger.log(BasicLevel.WARN, (Object)("no ES for ctx:" + this));
        }
        return this.bs;
    }

    public boolean isInitialized() {
        return this.bs != null;
    }

    public void setEntitySwitch(JEntitySwitch bs) {
        this.bs = bs;
        TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        if (this.ismarkedremoved) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"ismarkedremoved WAS SET");
            Thread.dumpStack();
            this.ismarkedremoved = false;
        }
        this.mustnotifywriting = bs.getPolicy() != 4 && bs.lazyRegistering();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean d) {
        if (d) {
            HaService haService;
            if (!this.dirty && this.bs != null && this.bs.bf != null && this.bs.bf.dd != null && this.bs.bf.dd.isClusterReplicated() && (haService = this.bs.bf.cont.getHaService()) != null && haService.isStarted()) {
                haService.addEntityBean(this);
            }
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"true");
            if (this.mustnotifywriting && this.initialized) {
                Transaction tx = null;
                try {
                    tx = this.tm.getTransaction();
                }
                catch (SystemException e) {
                    TraceEjb.context.log(BasicLevel.ERROR, (Object)"getTransaction failed", (Throwable)e);
                }
                if (tx == null) {
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)"You should not modify the bean without a transactional context");
                } else {
                    this.bs.notifyWriting(tx, this);
                }
            } else if (!this.initialized) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)"not initialized");
            }
        }
        this.dirty = d;
    }

    public void storeIfModified() {
        EntityBean eb = (EntityBean)this.myinstance;
        if (this.ismarkedremoved) {
            if (TraceEjb.isDebugContext()) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)"marked removed");
            }
            return;
        }
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            eb.ejbStore();
        }
        catch (RemoteException e) {
            throw new EJBException("Exception while storing data", e);
        }
        catch (EJBException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"raised EJBException ", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"runtime exception: ", (Throwable)e);
            throw new EJBException("Exception while storing data", e);
        }
        catch (Error e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"error: ", (Throwable)e);
            throw new EJBException("Error while storing data");
        }
    }

    public boolean passivate() {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        EntityBean eb = (EntityBean)this.myinstance;
        this.setState(1);
        try {
            eb.ejbPassivate();
        }
        catch (Exception e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"ejbPassivate failed", (Throwable)e);
        }
        catch (Error e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"ejbPassivate error", (Throwable)e);
        }
        return true;
    }

    public void activate(boolean doactivate) {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        EntityBean eb = (EntityBean)this.myinstance;
        try {
            if (doactivate) {
                this.setState(1);
                eb.ejbActivate();
            }
            this.setState(2);
            eb.ejbLoad();
        }
        catch (RemoteException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"remote exception: ", (Throwable)e);
            throw new EJBException("Cannot activate bean", e);
        }
        catch (RuntimeException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"runtime exception: ", (Throwable)e);
            throw new EJBException("Cannot activate bean", e);
        }
        catch (Error e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"error: ", (Throwable)e);
            throw new EJBException("Cannot activate bean");
        }
    }

    private void abortTransaction() {
        if (TraceEjb.isDebugContext()) {
            TraceEjb.context.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.beanCoord != null) {
            try {
                this.beanCoord.setRollbackOnly();
            }
            catch (SystemException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot setRollbackOnly", (Throwable)e);
            }
        }
    }
}

