/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.service.manager;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.lib.management.javaee.J2EEServiceState;
import org.ow2.jonas.lib.service.manager.ServiceItem;
import org.ow2.jonas.lib.service.manager.ServiceTracker;
import org.ow2.jonas.lib.service.manager.ServiceUtil;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerImpl
implements ServiceManager {
    private Log logger = LogFactory.getLog(J2EEServerService.class);
    private Map<String, ServiceItem> servicesState = null;
    private BundleContext bc;
    private ConfigurationManager configurationManager = null;
    private J2EEServerService j2eeServer;

    public ServiceManagerImpl(BundleContext bc) {
        this.bc = bc;
        this.servicesState = new Hashtable<String, ServiceItem>();
    }

    public void start() {
        try {
            this.update();
        }
        catch (Exception e) {
            this.logger.error("Cannot initialize the service states", new Object[0]);
        }
        ServiceTracker listener = new ServiceTracker(this);
        this.bc.addServiceListener((ServiceListener)listener);
    }

    public void addService(ServiceItem serviceItem) {
        this.servicesState.put(serviceItem.getName(), serviceItem);
    }

    public void setMandatoryService(String serviceName) {
        ServiceItem serviceItem = this.servicesState.get(serviceName);
        if (serviceItem != null) {
            serviceItem.setMandatory(true);
        }
    }

    public void deleteAllServices() {
        this.servicesState.clear();
    }

    @Override
    public List<String> getServices() {
        ArrayList<String> sl = new ArrayList<String>();
        for (ServiceItem serviceItem : this.servicesState.values()) {
            sl.add(serviceItem.getName());
        }
        return sl;
    }

    public J2EEServiceState setServiceState(String serviceName, J2EEServiceState state) {
        if (this.servicesState == null) {
            this.logger.error("setServiceState called but servicesState table null", new Object[0]);
            return null;
        }
        ServiceItem serviceItem = this.servicesState.get(serviceName);
        if (serviceItem == null) {
            this.logger.error("setServiceState called but service " + serviceName + " not known", new Object[0]);
            return null;
        }
        J2EEServiceState prevState = serviceItem.getState();
        if (prevState != null && prevState.equals((Object)state)) {
            return prevState;
        }
        serviceItem.setState(state);
        if (this.servicesState.get(serviceName) != null) {
            this.checkServerState(serviceName);
        }
        return state;
    }

    @Override
    public String getServiceState(String serviceName) {
        ServiceItem serviceItem = this.servicesState.get(serviceName);
        if (serviceItem != null) {
            return serviceItem.getState().toString();
        }
        this.logger.error("getServiceState called but service " + serviceName + " not known", new Object[0]);
        return null;
    }

    @Override
    public String getServiceDescription(String serviceName) {
        ServiceItem serviceItem = this.servicesState.get(serviceName);
        if (serviceItem != null) {
            return serviceItem.getDescription();
        }
        this.logger.error("getServiceDescription called but service " + serviceName + " not known", new Object[0]);
        return null;
    }

    private boolean allServicesRunning() {
        boolean servicesRunning = true;
        for (ServiceItem serviceItem : this.servicesState.values()) {
            J2EEServiceState state = serviceItem.getState();
            if (state.equals((Object)J2EEServiceState.RUNNING)) continue;
            servicesRunning = false;
            break;
        }
        return servicesRunning;
    }

    private boolean allServicesStopped() {
        boolean servicesStopped = true;
        for (ServiceItem serviceItem : this.servicesState.values()) {
            J2EEServiceState state = serviceItem.getState();
            if (state.equals((Object)J2EEServiceState.STOPPED) || serviceItem.isMandatory()) continue;
            servicesStopped = false;
            break;
        }
        return servicesStopped;
    }

    protected void checkServerState(String serviceName) {
        if (this.j2eeServer != null) {
            if (this.j2eeServer.isStarting() && this.allServicesRunning() && !this.startMonitoring()) {
                this.j2eeServer.setRunning();
            }
            if (this.j2eeServer.isRunning() && "depmonitor".equals(serviceName) && this.depMonitorRunning()) {
                this.startMonitoring();
            }
            if ((this.j2eeServer.isRunning() || this.j2eeServer.isStopping()) && this.allServicesStopped()) {
                this.j2eeServer.setStopped();
            }
        }
    }

    private boolean startMonitoring() {
        ServiceReference reference = this.depMonitorReference();
        if (reference != null) {
            MonitoringService monitoringService = (MonitoringService)this.bc.getService(reference);
            monitoringService.startMonitoring();
            return true;
        }
        return false;
    }

    private boolean depMonitorRunning() {
        return this.depMonitorReference() != null;
    }

    private ServiceReference depMonitorReference() {
        return this.bc.getServiceReference(MonitoringService.class.getName());
    }

    @Override
    public synchronized void update() throws Exception {
        this.deleteAllServices();
        for (String service : this.configurationManager.getMandatoryServices()) {
            this.addService(this.createServiceItem(service, Boolean.TRUE));
        }
        for (String service : this.configurationManager.getOptionalServices()) {
            this.addService(this.createServiceItem(service, Boolean.FALSE));
        }
        List<String> runningServices = ServiceUtil.runningServices(this.bc);
        for (String service : runningServices) {
            this.setServiceState(service, J2EEServiceState.RUNNING);
        }
    }

    @Override
    public void startService(String service) {
        if (this.servicesState.get(service) == null || this.servicesState.get(service).getState() != J2EEServiceState.RUNNING) {
            try {
                this.addService(this.createServiceItem(service, false));
                this.configurationManager.updateServiceConfiguration(service);
            }
            catch (Exception e) {
                this.logger.error("Cannot create configuration for the ''{0 }}' service", service);
            }
        } else {
            this.logger.debug("Service ''{0 }}' is already running", service);
        }
    }

    @Override
    public void stopService(String service) {
        if (this.servicesState.get(service) != null && this.servicesState.get(service).getState() == J2EEServiceState.RUNNING) {
            try {
                this.configurationManager.deleteServiceConfiguration(service);
            }
            catch (Exception e) {
                this.logger.error("Cannot delete configuration for the ''{0 }}' service", service);
            }
        } else {
            this.logger.debug("Service ''0}'' is not running", service);
        }
    }

    private ServiceItem createServiceItem(String service, boolean mandatory) {
        ServiceItem serviceItem = new ServiceItem();
        serviceItem.setName(service);
        serviceItem.setDescription(service + " description ...");
        serviceItem.setState(J2EEServiceState.STOPPED);
        serviceItem.setMandatory(mandatory);
        return serviceItem;
    }

    public void bindJ2EEServer(J2EEServerService j2eeServer) {
        this.j2eeServer = j2eeServer;
    }

    public void unbindJ2EEServer(J2EEServerService j2eeServer) {
        this.j2eeServer = null;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

