/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.tm.jotm;

import java.util.EmptyStackException;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionRecovery;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.tm.Enlistable;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.jonas.tm.TxResourceManager;
import org.ow2.jonas.tm.jotm.JOTMTransactionResourceManager;
import org.ow2.jonas.tm.jotm.UserTransactionFactory;

public class JOTMTransactionManager
extends Current
implements TransactionManager {
    private static Logger logger = Log.getLogger("org.ow2.jonas.server");
    private static transient JOTMTransactionManager unique = null;
    private transient ThreadLocal connectionListStack = new ThreadLocal();

    public JOTMTransactionManager(TransactionFactory tmfact) {
        super(tmfact);
        unique = this;
    }

    public JOTMTransactionManager() {
        unique = this;
    }

    public static JOTMTransactionManager getUnique() {
        return unique;
    }

    public Reference getReference() throws NamingException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        Reference ref = new Reference(this.getClass().getName(), UserTransactionFactory.class.getName(), null);
        int i = this.getDefaultTimeout();
        ref.add(new StringRefAddr("jotm.timeout", new String("" + i)));
        return ref;
    }

    public void begin() throws NotSupportedException, SystemException {
        super.begin();
        Stack curStack = (Stack)this.connectionListStack.get();
        if (curStack != null) {
            try {
                List list = (List)curStack.peek();
                if (list != null) {
                    Vector templist = new Vector(list);
                    for (Enlistable mce : templist) {
                        mce.enlistConnection(this.getTransaction());
                    }
                } else {
                    logger.log(BasicLevel.DEBUG, (Object)"Current.begin called with null list");
                }
            }
            catch (EmptyStackException e) {
                logger.log(BasicLevel.DEBUG, (Object)"Current.begin called with empty stack");
            }
        }
    }

    public void notifyConnectionOpen(Enlistable mce) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        Stack<Vector<Enlistable>> curStack = (Stack<Vector<Enlistable>>)this.connectionListStack.get();
        if (curStack == null) {
            curStack = new Stack<Vector<Enlistable>>();
            this.connectionListStack.set(curStack);
        }
        Vector<Enlistable> list = null;
        try {
            list = (Vector<Enlistable>)curStack.pop();
        }
        catch (EmptyStackException e) {
            // empty catch block
        }
        if (list == null) {
            list = new Vector<Enlistable>(1);
        }
        list.add(mce);
        curStack.push(list);
    }

    public void notifyConnectionClose(Enlistable mce) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.removeFromCurrentStack(mce);
    }

    public void notifyConnectionError(Enlistable mce) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.removeFromCurrentStack(mce);
    }

    private void removeFromCurrentStack(Enlistable mce) {
        Stack curStack = (Stack)this.connectionListStack.get();
        if (curStack == null) {
            return;
        }
        try {
            List list = (List)curStack.peek();
            if (list != null) {
                list.remove(mce);
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void pushConnectionList(List cl) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        Stack<List> curStack = (Stack<List>)this.connectionListStack.get();
        if (curStack == null) {
            curStack = new Stack<List>();
            this.connectionListStack.set(curStack);
        }
        curStack.push(cl);
    }

    public List popConnectionList() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        Stack curStack = (Stack)this.connectionListStack.get();
        return (List)curStack.pop();
    }

    public boolean nonJotmTransactionContext() {
        TransactionContext transContext = this.getPropagationContext(false);
        if (transContext == null) {
            return false;
        }
        return !transContext.isJotmCtx();
    }

    public void registerResourceManager(String rmName, XAResource xares, String info, Properties p, TxResourceManager trm) throws XAException {
        TransactionRecovery tr = JOTMTransactionManager.getTransactionRecovery();
        JOTMTransactionResourceManager mytrm = null;
        if (trm != null) {
            mytrm = new JOTMTransactionResourceManager(trm);
        }
        if (p != null) {
            tr.registerResourceManager(rmName, xares, info, p, mytrm);
        } else {
            tr.registerResourceManager(rmName, xares, info, mytrm);
        }
    }
}

