/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.versioning.internal;

import java.io.File;
import java.net.URL;
import javax.management.ObjectName;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.versioning.VersioningServiceBase;
import org.ow2.jonas.versioning.contexts.VirtualJNDIBinding;
import org.ow2.jonas.versioning.internal.VersioningServiceImplMBean;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningServiceImpl
extends AbsServiceImpl
implements VersioningService,
VersioningServiceImplMBean {
    private static Log logger = LogFactory.getLog(VersioningService.class);
    private String defaultPolicy = "Reserved";
    private JmxService jmxService = null;

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public static ObjectName getObjectName(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=versioning");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get versioning service", e);
        }
    }

    @Override
    protected void doStart() {
        VirtualJNDIBinding.initialize(this, this.jmxService);
        this.jmxService.registerMBean((Object)this, VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info("Versioning service management bean has been registered successfully", new Object[0]);
    }

    @Override
    protected void doStop() {
        this.jmxService.unregisterMBean(VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info("Versioning service management bean has been unregistered successfully", new Object[0]);
    }

    @Override
    public String[] getPolicies() {
        return VersioningServiceBase.POLICIES;
    }

    @Override
    public boolean isVersioningEnabled() {
        return this.isStarted();
    }

    @Override
    public String getDefaultDeploymentPolicy() {
        return this.defaultPolicy;
    }

    @Override
    public void setDefaultDeploymentPolicy(String defaultPolicy) {
        if (!("Default".equals(defaultPolicy) || "Disabled".equals(defaultPolicy) || "Reserved".equals(defaultPolicy) || "Private".equals(defaultPolicy))) {
            throw new IllegalArgumentException("Invalid policy : " + defaultPolicy);
        }
        this.defaultPolicy = defaultPolicy;
    }

    @Override
    public String getVersionID(File file) {
        try {
            IArchive archive = ArchiveManager.getInstance().getArchive(file);
            IDeployable<?> deployable = DeployableHelper.getDeployable(archive);
            return this.getVersionID(deployable);
        }
        catch (DeployableHelperException e) {
            logger.info("Failed creating deployable for file " + file, e);
            return null;
        }
    }

    @Override
    public String getVersionID(URL url) {
        return this.getVersionID(URLUtils.urlToFile(url));
    }

    @Override
    public String getVersionID(IDeployable<?> deployable) {
        IDeployable<?> originalDeployable = this.getOriginalDeployable(deployable);
        String versionID = originalDeployable.getArchive().getMetadata().get("Implementation-Version");
        if (versionID != null) {
            String allowedSpecialChars = "-_,.";
            boolean versionIDFiltered = false;
            StringBuffer versionIDFilter = new StringBuffer();
            for (char c : versionID.toCharArray()) {
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "-_,.".indexOf(c) >= 0) {
                    versionIDFilter.append(c);
                    continue;
                }
                versionIDFiltered = true;
                versionIDFilter.append('-');
            }
            if (versionIDFiltered) {
                versionID = versionIDFilter.toString();
                logger.debug("Invalid characters detected in version ID for archive " + originalDeployable.getArchive().getName() + ", setting version ID to " + versionID, new Object[0]);
            }
            versionID = "-version" + versionID;
        }
        return versionID;
    }

    @Override
    public String getPrefix(File file) {
        try {
            IArchive archive = ArchiveManager.getInstance().getArchive(file);
            IDeployable<?> deployable = DeployableHelper.getDeployable(archive);
            return this.getPrefix(deployable);
        }
        catch (DeployableHelperException e) {
            logger.info("Failed creating deployable for file " + file, e);
            return null;
        }
    }

    @Override
    public String getPrefix(URL url) {
        return this.getPrefix(URLUtils.urlToFile(url));
    }

    @Override
    public String getPrefix(IDeployable<?> deployable) {
        String applicationName;
        IDeployable<?> originalDeployable = this.getOriginalDeployable(deployable);
        String versionID = this.getVersionID(originalDeployable);
        if (versionID == null) {
            return null;
        }
        String prefix = applicationName = originalDeployable.getModuleName();
        if (!applicationName.endsWith(versionID)) {
            prefix = prefix + versionID;
        }
        prefix = prefix + '/';
        String allowedSpecialChars = "_./";
        boolean jndiPrefixFiltered = false;
        StringBuffer jndiPrefixFilter = new StringBuffer();
        for (char c : prefix.toCharArray()) {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "_./".indexOf(c) >= 0) {
                jndiPrefixFilter.append(c);
                continue;
            }
            jndiPrefixFiltered = true;
            jndiPrefixFilter.append('_');
        }
        if (jndiPrefixFiltered) {
            prefix = jndiPrefixFilter.toString();
            logger.debug("Invalid characters detected in the JNDI prefix for application " + applicationName + ", setting JNDI prefix to " + prefix, new Object[0]);
        }
        return prefix;
    }

    private IDeployable<?> getOriginalDeployable(IDeployable<?> deployable) {
        IDeployable<?> originalDeployable = deployable;
        while (originalDeployable.getOriginalDeployable() != null) {
            originalDeployable = originalDeployable.getOriginalDeployable();
        }
        return originalDeployable;
    }

    @Override
    public void createJNDIBindingMBeans(IDeployable<?> deployable) {
        IDeployable<?> originalDeployable = this.getOriginalDeployable(deployable);
        String versionID = this.getVersionID(originalDeployable);
        if (versionID == null) {
            logger.warn("IDeployable " + deployable.toString() + " is not versioned! Ignoring call to createJNDIBindingMBeans", new Object[0]);
            return;
        }
        String applicationName = originalDeployable.getModuleName();
        if (applicationName.endsWith(versionID)) {
            applicationName = applicationName.replace(versionID, "");
        }
        String prefix = this.getPrefix(originalDeployable);
        VirtualJNDIBinding.createJNDIBindingMBeans(applicationName, prefix);
    }

    @Override
    public void garbageCollectJNDIBindingMBeans() {
        VirtualJNDIBinding.garbageCollectJNDIBindingMBeans();
    }

    @Override
    public String getBaseName(URL url) {
        File file = URLUtils.urlToFile(url);
        try {
            IArchive archive = ArchiveManager.getInstance().getArchive(file);
            IDeployable<?> originalDeployable = this.getOriginalDeployable(DeployableHelper.getDeployable(archive));
            String moduleName = originalDeployable.getModuleName();
            String versionID = this.getVersionID(originalDeployable);
            if (versionID != null) {
                moduleName = moduleName.replace(versionID, "");
            }
            return moduleName;
        }
        catch (DeployableHelperException e) {
            logger.info("Failed creating deployable for file " + file, e);
            return null;
        }
    }
}

