/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.ejbjar.impl.EjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.impl.configurator.EjbJarDeployableMetadataConfigurator;
import org.ow2.util.ee.metadata.ejbjar.impl.specific.ISpecificEjbJarDeployableFactory;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.EJB3DeploymentDesc;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.EJB3DeploymentDescException;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.helper.ExtractUsefullClasses;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.helper.MetadataMerge;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EJB3;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.IClassesLocator;
import org.ow2.util.scan.api.IScanner;
import org.ow2.util.scan.api.ScanException;
import org.ow2.util.scan.api.classlocator.ArchiveClassesLocator;
import org.ow2.util.scan.api.classlocator.ClassLoaderClassesLocator;
import org.ow2.util.scan.api.configurator.IArchiveConfigurator;
import org.ow2.util.scan.impl.ASMScannerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarDeployableMetadataFactory<E extends EJBDeployable<E>>
implements IEjbJarDeployableMetadataFactory<E> {
    private static final Log LOGGER = LogFactory.getLog(EjbJarDeployableMetadataFactory.class);
    private static final String CLASS_SUFFIX = ".class";
    private IScanner scanner;

    public EjbJarDeployableMetadataFactory() throws ScanException {
        this.scanner = new ASMScannerImpl();
    }

    public EjbJarDeployableMetadataFactory(IScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public IEjbJarDeployableMetadata<E> createDeployableMetadata(E ejb3Deployable) throws DeployableMetadataException {
        return this.createDeployableMetadata(ejb3Deployable, null, null);
    }

    @Override
    public IEjbJarDeployableMetadata<E> createDeployableMetadata(E deployable, ClassLoader classLoader) throws DeployableMetadataException {
        List<ClassLoaderClassesLocator> classesLocatorList = null;
        if (classLoader != null) {
            classesLocatorList = Arrays.asList(new ClassLoaderClassesLocator(classLoader));
        }
        return this.createDeployableMetadata(deployable, classesLocatorList, null);
    }

    private void completeClassList(EJB3 ejb3, Set<String> classNames) {
        for (String className : ExtractUsefullClasses.extract(ejb3)) {
            classNames.add(className.replace('.', '/'));
        }
    }

    public IEjbJarDeployableMetadata<E> createDeployableMetadata(E ejb3Deployable, List<? extends IClassesLocator> ejbJarExternLibraries, List<? extends ISpecificEjbJarDeployableFactory<E>> specificDeployableFactoryList) throws DeployableMetadataException {
        EJB3 ejb3;
        long tAnalyzeStart = System.currentTimeMillis();
        IArchive archive = ejb3Deployable.getArchive();
        try {
            ejb3 = EJB3DeploymentDesc.getEjb3(archive);
        }
        catch (EJB3DeploymentDescException e) {
            throw new DeployableMetadataException(e);
        }
        EjbJarDeployableMetadataConfigurator<E> ejbJarArchiveMetadataConfigurator = new EjbJarDeployableMetadataConfigurator<E>(ejb3Deployable);
        HashSet<String> classNameSet = new HashSet<String>();
        if (specificDeployableFactoryList != null) {
            for (ISpecificEjbJarDeployableFactory<E> specificEjbJarDeployableFactory : specificDeployableFactoryList) {
                ejbJarArchiveMetadataConfigurator.addSpecificMetadataConfigurator(specificEjbJarDeployableFactory.beforeScan(ejb3Deployable, classNameSet));
            }
        }
        if (ejb3 != null && ejb3.isMetadataComplete()) {
            ejbJarArchiveMetadataConfigurator.setAnnotationParsingDesactived(true);
        } else {
            Iterator<String> entryIterator;
            ejbJarArchiveMetadataConfigurator.setAnnotationParsingDesactived(false);
            try {
                entryIterator = archive.getEntries();
            }
            catch (ArchiveException e) {
                throw new DeployableMetadataException(e);
            }
            while (entryIterator.hasNext()) {
                String entry = entryIterator.next();
                if (!entry.endsWith(CLASS_SUFFIX)) continue;
                classNameSet.add(entry.substring(0, entry.length() - CLASS_SUFFIX.length()));
            }
        }
        this.completeClassList(ejb3, classNameSet);
        List<IArchiveConfigurator> archiveConfiguratorList = Arrays.asList(ejbJarArchiveMetadataConfigurator);
        ArchiveClassesLocator ejb3ClassesLocator = new ArchiveClassesLocator(archive);
        ArrayList<String> scannedClasses = new ArrayList<String>();
        ArrayList<String> nextClassNameToScan = new ArrayList<String>();
        nextClassNameToScan.addAll(classNameSet);
        try {
            while (nextClassNameToScan.size() != 0) {
                classNameSet.clear();
                for (String className : nextClassNameToScan) {
                    URL url = ejb3ClassesLocator.getClassURL(className);
                    if (url == null && ejbJarExternLibraries != null) {
                        IClassesLocator classesLocator;
                        Iterator<? extends IClassesLocator> i$ = ejbJarExternLibraries.iterator();
                        while (i$.hasNext() && (url = (classesLocator = i$.next()).getClassURL(className)) == null) {
                        }
                    }
                    if (url != null) {
                        this.scanner.scanClass(url, classNameSet, archiveConfiguratorList);
                    }
                    scannedClasses.add(className);
                }
                nextClassNameToScan.clear();
                for (String className : classNameSet) {
                    if (scannedClasses.contains(className)) continue;
                    nextClassNameToScan.add(className);
                }
            }
        }
        catch (ScanException e) {
            throw new DeployableMetadataException("Error during scan", e);
        }
        EjbJarDeployableMetadata<E> ejbJarArchiveMetadata = ejbJarArchiveMetadataConfigurator.getEjbJarArchiveMetadata();
        ejbJarArchiveMetadata.setEjb3(ejb3);
        MetadataMerge.merge(ejbJarArchiveMetadata);
        if (specificDeployableFactoryList != null) {
            for (ISpecificEjbJarDeployableFactory<E> specificEjbJarDeployableFactory : specificDeployableFactoryList) {
                specificEjbJarDeployableFactory.afterScan();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long tAnalyzeStartEnd = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Analyze of file {0} took {1} ms.", archive.getName(), tAnalyzeStartEnd - tAnalyzeStart);
            }
        }
        return ejbJarArchiveMetadata;
    }

    @Override
    public Class<IEjbJarDeployableMetadata<E>> getDeployableMetadataClass() {
        return IEjbJarDeployableMetadata.class;
    }
}

