/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.binder;

import java.util.List;
import org.apache.felix.dependencymanager.Dependency;
import org.apache.felix.dependencymanager.DependencyManager;
import org.apache.felix.dependencymanager.Logger;
import org.apache.felix.dependencymanager.Service;
import org.apache.felix.dependencymanager.ServiceDependency;
import org.osgi.framework.BundleContext;
import org.ow2.easybeans.osgi.binder.DependenciesBuilder;
import org.ow2.easybeans.osgi.binder.desc.DependencyDescription;
import org.ow2.easybeans.osgi.binder.listener.IDependencyListener;

public class DefaultDependencyManager {
    private DependencyManager manager = null;
    private final BundleContext context;

    public DefaultDependencyManager(BundleContext context) {
        Logger dmLogger = new Logger(context);
        this.manager = new DependencyManager(context, dmLogger);
        this.context = context;
    }

    public ServiceDependency createDependency() {
        return this.manager.createServiceDependency().setRequired(false);
    }

    public Service createService(Object instance) {
        return this.createService(instance, true);
    }

    public Service createService(Object instance, boolean configure) {
        Service service = this.manager.createService().setImplementation(instance);
        if (configure) {
            this.configureService(service, instance);
        }
        return service;
    }

    public void startTracking(Service service) {
        this.manager.add(service);
    }

    public void stopTracking(Service service) {
        this.manager.remove(service);
    }

    private Service configureService(Service service, Object instance) {
        DependenciesBuilder builder = new DependenciesBuilder(instance, this.context);
        List<DependencyDescription> dependencies = null;
        dependencies = builder.extractDependencies();
        for (DependencyDescription description : dependencies) {
            ServiceDependency dependency = this.createDependency();
            dependency.setService(description.getServiceInterface(), description.getFilter());
            IDependencyListener listener = null;
            listener = description.createListener(instance);
            dependency.setCallbacks((Object)listener, "added", "changed", "removed");
            service.add((Dependency)dependency);
        }
        return service;
    }
}

