/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.InstanceStateListener;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.osgi.framework.BundleContext;

public class InstanceManager
implements ComponentInstance,
InstanceStateListener {
    protected String m_name;
    protected String m_className;
    protected HandlerManager[] m_handlers = null;
    protected int m_state = 0;
    protected List m_instanceListeners = null;
    private ComponentFactory m_factory;
    private BundleContext m_context;
    private Map m_fieldRegistration = new HashMap();
    private Map m_methodRegistration;
    private Class m_clazz;
    private Object[] m_pojoObjects = null;
    private boolean m_inTransition = false;
    private List m_stateQueue = new ArrayList();
    private Map m_map = new HashMap();
    static /* synthetic */ Class class$org$apache$felix$ipojo$InstanceManager;
    static /* synthetic */ Class class$org$osgi$framework$BundleContext;

    public InstanceManager(ComponentFactory factory, BundleContext bc, HandlerManager[] handlers) {
        this.m_factory = factory;
        this.m_context = bc;
        this.m_handlers = handlers;
    }

    public void configure(Element cm, Dictionary configuration) throws ConfigurationException {
        this.m_className = cm.getAttribute("className");
        this.m_name = (String)configuration.get("name");
        for (int i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].init(this, cm, configuration);
        }
    }

    public InstanceDescription getInstanceDescription() {
        int i;
        int componentState = this.getState();
        InstanceDescription instanceDescription = new InstanceDescription(this.m_name, componentState, this.getContext().getBundle().getBundleId(), this.m_factory.getComponentDescription());
        if (this.m_pojoObjects != null) {
            String[] objects = new String[this.m_pojoObjects.length];
            for (i = 0; i < this.m_pojoObjects.length; ++i) {
                objects[i] = this.m_pojoObjects[i].toString();
            }
            instanceDescription.setCreatedObjects(objects);
        }
        Handler[] handlers = this.getRegistredHandlers();
        for (i = 0; i < handlers.length; ++i) {
            instanceDescription.addHandler(handlers[i].getDescription());
        }
        return instanceDescription;
    }

    public Handler[] getRegistredHandlers() {
        Handler[] h = new Handler[this.m_handlers.length];
        for (int i = 0; i < this.m_handlers.length; ++i) {
            h[i] = this.m_handlers[i].getHandler();
        }
        return h;
    }

    public Handler getHandler(String name) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            HandlerFactory fact = (HandlerFactory)this.m_handlers[i].getHandler().getInstance().getFactory();
            if (!fact.getHandlerName().equals(name)) continue;
            return this.m_handlers[i].getHandler();
        }
        return null;
    }

    public synchronized void start() {
        int i;
        if (this.m_state != 0) {
            return;
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].addInstanceStateListener(this);
            this.m_handlers[i].start();
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            if (this.m_handlers[i].getState() == 2) continue;
            this.setState(1);
            return;
        }
        this.setState(2);
    }

    public synchronized void stop() {
        int i;
        if (this.m_state == 0) {
            return;
        }
        this.setState(1);
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].removeInstanceStateListener(this);
            this.m_handlers[i].stop();
        }
        this.m_pojoObjects = null;
        this.m_state = 0;
        if (this.m_instanceListeners != null) {
            for (i = 0; i < this.m_instanceListeners.size(); ++i) {
                ((InstanceStateListener)this.m_instanceListeners.get(i)).stateChanged(this, 0);
            }
        }
    }

    public synchronized void dispose() {
        int i;
        if (this.m_state > 0) {
            this.stop();
        }
        this.m_state = -1;
        if (this.m_instanceListeners != null) {
            for (i = 0; i < this.m_instanceListeners.size(); ++i) {
                ((InstanceStateListener)this.m_instanceListeners.get(i)).stateChanged(this, -1);
            }
            this.m_instanceListeners = null;
        }
        this.m_factory.disposed(this);
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].dispose();
        }
        this.m_map.clear();
        this.m_handlers = new HandlerManager[0];
        this.m_fieldRegistration = new HashMap();
        this.m_methodRegistration = new HashMap();
        this.m_clazz = null;
        this.m_inTransition = false;
    }

    protected void kill() {
        int i;
        if (this.m_state > 0) {
            this.stop();
        }
        if (this.m_instanceListeners != null) {
            for (i = 0; i < this.m_instanceListeners.size(); ++i) {
                ((InstanceStateListener)this.m_instanceListeners.get(i)).stateChanged(this, -1);
            }
            this.m_instanceListeners = null;
        }
        this.m_state = -1;
        for (i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].dispose();
        }
        this.m_map.clear();
        this.m_handlers = new HandlerManager[0];
        this.m_fieldRegistration = new HashMap();
        this.m_methodRegistration = new HashMap();
        this.m_clazz = null;
        this.m_inTransition = false;
    }

    public synchronized void setState(int state) {
        if (this.m_inTransition) {
            this.m_stateQueue.add(new Integer(state));
            return;
        }
        if (this.m_state != state) {
            int i;
            this.m_inTransition = true;
            if (state > this.m_state) {
                this.m_state = state;
                for (i = 0; i < this.m_handlers.length; ++i) {
                    this.m_handlers[i].getHandler().stateChanged(state);
                }
            } else {
                this.m_state = state;
                for (i = this.m_handlers.length - 1; i > -1; --i) {
                    this.m_handlers[i].getHandler().stateChanged(state);
                }
            }
            if (this.m_instanceListeners != null) {
                for (i = 0; i < this.m_instanceListeners.size(); ++i) {
                    ((InstanceStateListener)this.m_instanceListeners.get(i)).stateChanged(this, state);
                }
            }
        }
        this.m_inTransition = false;
        if (!this.m_stateQueue.isEmpty()) {
            int newState = (Integer)this.m_stateQueue.remove(0);
            this.setState(newState);
        }
    }

    public int getState() {
        return this.m_state;
    }

    public boolean isStarted() {
        return this.m_state > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceStateListener(InstanceStateListener listener) {
        if (this.m_instanceListeners == null) {
            this.m_instanceListeners = new ArrayList();
        }
        List list = this.m_instanceListeners;
        synchronized (list) {
            this.m_instanceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceStateListener(InstanceStateListener listener) {
        if (this.m_instanceListeners != null) {
            List list = this.m_instanceListeners;
            synchronized (list) {
                this.m_instanceListeners.remove(listener);
                if (this.m_instanceListeners.size() == 0) {
                    this.m_instanceListeners = null;
                }
            }
        }
    }

    public ComponentFactory getFactory() {
        return this.m_factory;
    }

    private void load() {
        try {
            this.m_clazz = this.m_factory.loadClass(this.m_className);
        }
        catch (ClassNotFoundException e) {
            this.m_factory.getLogger().log(1, "[" + this.m_name + "] Class not found during the loading phase : " + e.getMessage());
            this.stop();
            return;
        }
    }

    private synchronized void addInstance(Object o) {
        if (this.m_pojoObjects != null) {
            Object[] newInstances = new Object[this.m_pojoObjects.length + 1];
            System.arraycopy(this.m_pojoObjects, 0, newInstances, 0, this.m_pojoObjects.length);
            newInstances[this.m_pojoObjects.length] = o;
            this.m_pojoObjects = newInstances;
        } else {
            this.m_pojoObjects = new Object[]{o};
        }
    }

    public Object[] getPojoObjects() {
        return this.m_pojoObjects;
    }

    public synchronized void deletePojoObject(Object o) {
        int idx = -1;
        for (int i = 0; i < this.m_pojoObjects.length; ++i) {
            if (this.m_pojoObjects[i] != o) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            if (this.m_pojoObjects.length - 1 == 0) {
                this.m_pojoObjects = null;
            } else {
                Object[] newInstances = new Object[this.m_pojoObjects.length - 1];
                System.arraycopy(this.m_pojoObjects, 0, newInstances, 0, idx);
                if (idx < newInstances.length) {
                    System.arraycopy(this.m_pojoObjects, idx + 1, newInstances, idx, newInstances.length - idx);
                }
                this.m_pojoObjects = newInstances;
            }
        }
    }

    public Object createPojoObject() {
        if (this.m_clazz == null) {
            this.load();
        }
        Object instance = null;
        try {
            Constructor constructor;
            try {
                constructor = this.m_clazz.getConstructor(class$org$apache$felix$ipojo$InstanceManager == null ? (class$org$apache$felix$ipojo$InstanceManager = InstanceManager.class$("org.apache.felix.ipojo.InstanceManager")) : class$org$apache$felix$ipojo$InstanceManager, class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = InstanceManager.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext);
                constructor.setAccessible(true);
                instance = constructor.newInstance(this, this.m_context);
            }
            catch (NoSuchMethodException e) {
                instance = null;
            }
            if (instance == null) {
                constructor = this.m_clazz.getConstructor(class$org$apache$felix$ipojo$InstanceManager == null ? (class$org$apache$felix$ipojo$InstanceManager = InstanceManager.class$("org.apache.felix.ipojo.InstanceManager")) : class$org$apache$felix$ipojo$InstanceManager);
                constructor.setAccessible(true);
                instance = constructor.newInstance(this);
            }
        }
        catch (InstantiationException e) {
            this.m_factory.getLogger().log(1, "[" + this.m_name + "] createInstance -> The Component Instance cannot be instancied : " + e.getMessage());
            this.stop();
        }
        catch (IllegalAccessException e) {
            this.m_factory.getLogger().log(1, "[" + this.m_name + "] createInstance -> The Component Instance is not accessible : " + e.getMessage());
            this.stop();
        }
        catch (SecurityException e) {
            this.m_factory.getLogger().log(1, "[" + this.m_name + "] createInstance -> The Component Instance is not accessible (security reason) : " + e.getMessage());
            this.stop();
        }
        catch (InvocationTargetException e) {
            this.m_factory.getLogger().log(1, "[" + this.m_name + "] createInstance -> Cannot invoke the constructor method (illegal target) : " + e.getTargetException().getMessage());
            e.printStackTrace();
            this.stop();
        }
        catch (NoSuchMethodException e) {
            this.m_factory.getLogger().log(1, "[" + this.m_name + "] createInstance -> Cannot invoke the constructor (method not found) : " + e.getMessage());
            this.stop();
        }
        if (instance == null) {
            this.m_factory.getLogger().log(1, "[" + this.m_name + "] createInstance -> Cannot create the instance");
            this.stop();
        }
        this.addInstance(instance);
        for (int i = 0; i < this.m_handlers.length; ++i) {
            ((PrimitiveHandler)this.m_handlers[i].getHandler()).objectCreated(instance);
        }
        return instance;
    }

    public synchronized Object getPojoObject() {
        if (this.m_pojoObjects == null) {
            this.createPojoObject();
        }
        return this.m_pojoObjects[0];
    }

    public Class getClazz() {
        if (this.m_clazz == null) {
            this.load();
        }
        return this.m_clazz;
    }

    public void register(PrimitiveHandler h, FieldMetadata[] fields, MethodMetadata[] methods) {
        PrimitiveHandler[] newList;
        PrimitiveHandler[] list;
        int i;
        for (i = 0; fields != null && i < fields.length; ++i) {
            if (this.m_fieldRegistration.get(fields[i].getFieldName()) == null) {
                this.m_fieldRegistration.put(fields[i].getFieldName(), new PrimitiveHandler[]{h});
                continue;
            }
            list = (PrimitiveHandler[])this.m_fieldRegistration.get(fields[i].getFieldName());
            for (int j = 0; j < list.length; ++j) {
                if (list[j] != h) continue;
                return;
            }
            newList = new PrimitiveHandler[list.length + 1];
            System.arraycopy(list, 0, newList, 0, list.length);
            newList[list.length] = h;
            this.m_fieldRegistration.put(fields[i].getFieldName(), newList);
        }
        for (i = 0; methods != null && i < methods.length; ++i) {
            if (this.m_methodRegistration == null) {
                this.m_methodRegistration = new HashMap();
                this.m_methodRegistration.put(methods[i].getMethodIdentifier(), new PrimitiveHandler[]{h});
                continue;
            }
            list = (PrimitiveHandler[])this.m_methodRegistration.get(methods[i].getMethodIdentifier());
            if (list == null) {
                this.m_methodRegistration.put(methods[i].getMethodIdentifier(), new PrimitiveHandler[]{h});
                continue;
            }
            for (int j = 0; j < list.length; ++j) {
                if (list[j] != h) continue;
                return;
            }
            newList = new PrimitiveHandler[list.length + 1];
            System.arraycopy(list, 0, newList, 0, list.length);
            newList[list.length] = h;
            this.m_methodRegistration.put(methods[i].getMethodIdentifier(), newList);
        }
    }

    public Object getterCallback(String fieldName) {
        int i;
        Object initialValue;
        Object result = initialValue = this.m_map.get(fieldName);
        PrimitiveHandler[] list = (PrimitiveHandler[])this.m_fieldRegistration.get(fieldName);
        for (i = 0; list != null && i < list.length; ++i) {
            Object handlerResult = list[i].getterCallback(fieldName, initialValue);
            if (handlerResult == initialValue) continue;
            if (result != initialValue && (handlerResult != null && !handlerResult.equals(result) || result != null && handlerResult == null)) {
                this.m_factory.getLogger().log(2, "A conflict was detected on the injection of " + fieldName + " - return the last value from " + list[i].getInstance().getInstanceName());
            }
            result = handlerResult;
        }
        if (result != null && !result.equals(initialValue) || result == null && initialValue != null) {
            this.m_map.put(fieldName, result);
            for (i = 0; list != null && i < list.length; ++i) {
                list[i].setterCallback(fieldName, result);
            }
        }
        return result;
    }

    public void entryCallback(String methodId) {
        PrimitiveHandler[] list = (PrimitiveHandler[])this.m_methodRegistration.get(methodId);
        for (int i = 0; list != null && i < list.length; ++i) {
            list[i].entryCallback(methodId);
        }
    }

    public void exitCallback(String methodId, Object e) {
        PrimitiveHandler[] list = (PrimitiveHandler[])this.m_methodRegistration.get(methodId);
        for (int i = 0; list != null && i < list.length; ++i) {
            list[i].exitCallback(methodId, e);
        }
    }

    public void setterCallback(String fieldName, Object objectValue) {
        Object o = this.m_map.get(fieldName);
        if (o != null && !o.equals(objectValue) || o == null && objectValue != null) {
            this.m_map.put(fieldName, objectValue);
            PrimitiveHandler[] list = (PrimitiveHandler[])this.m_fieldRegistration.get(fieldName);
            for (int i = 0; list != null && i < list.length; ++i) {
                list[i].setterCallback(fieldName, objectValue);
            }
        }
    }

    public BundleContext getContext() {
        return this.m_context;
    }

    public BundleContext getGlobalContext() {
        return ((IPojoContext)this.m_context).getGlobalContext();
    }

    public ServiceContext getLocalServiceContext() {
        return ((IPojoContext)this.m_context).getServiceContext();
    }

    public String getInstanceName() {
        return this.m_name;
    }

    public void reconfigure(Dictionary configuration) {
        int i;
        for (i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].getHandler().reconfigure(configuration);
        }
        if (this.m_state == 1) {
            for (i = 0; i < this.m_handlers.length; ++i) {
                if (this.m_handlers[i].getState() == 2) continue;
                return;
            }
            this.setState(2);
        }
    }

    public String getClassName() {
        return this.m_className;
    }

    public synchronized void stateChanged(ComponentInstance instance, int newState) {
        if (this.m_state <= 0) {
            return;
        }
        if (newState == 1 && this.m_state == 2) {
            this.setState(1);
            return;
        }
        if (newState == 2 && this.m_state == 1) {
            for (int i = 0; i < this.m_handlers.length; ++i) {
                if (this.m_handlers[i].getState() == 2) continue;
                return;
            }
            this.setState(2);
            return;
        }
    }

    public Set getRegistredFields() {
        if (this.m_fieldRegistration != null) {
            return this.m_fieldRegistration.keySet();
        }
        return null;
    }

    public Set getRegistredMethods() {
        if (this.m_methodRegistration != null) {
            return this.m_methodRegistration.keySet();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

