/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.composite.ServiceReferenceImpl;
import org.apache.felix.ipojo.composite.ServiceRegistry;
import org.apache.felix.ipojo.composite.StringMap;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    private ServiceRegistry m_registry = null;
    private String[] m_classes = null;
    private Long m_serviceId = null;
    private Object m_svcObj = null;
    private ServiceFactory m_factory = null;
    private Map m_propMap = null;
    private ServiceReferenceImpl m_ref = null;
    private List m_list = new ArrayList();

    public ServiceRegistrationImpl(ServiceRegistry registry, ComponentInstance cm, String[] classes, Long serviceId, Object svcObj, Dictionary dict) {
        this.m_registry = registry;
        this.m_classes = classes;
        this.m_serviceId = serviceId;
        this.m_svcObj = svcObj;
        if (this.m_svcObj instanceof ServiceFactory) {
            this.m_factory = (ServiceFactory)this.m_svcObj;
        }
        this.initializeProperties(dict);
        this.m_ref = new ServiceReferenceImpl(cm, this);
    }

    protected boolean isValid() {
        return this.m_svcObj != null;
    }

    public ServiceReference getReference() {
        return this.m_ref;
    }

    public void setProperties(Dictionary dict) {
        if (!this.isValid()) {
            throw new IllegalStateException("The service registration is no longer valid.");
        }
        this.initializeProperties(dict);
        this.m_registry.servicePropertiesModified(this);
    }

    public void unregister() {
        if (this.m_svcObj == null) {
            throw new IllegalStateException("Service already unregistered.");
        }
        this.m_registry.unregisterService(this);
        this.m_svcObj = null;
        this.m_factory = null;
    }

    protected Object getProperty(String key) {
        return this.m_propMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getPropertyKeys() {
        Map map = this.m_propMap;
        synchronized (map) {
            this.m_list.clear();
            Iterator i = this.m_propMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.m_list.add(entry.getKey());
            }
            return this.m_list.toArray(new String[this.m_list.size()]);
        }
    }

    protected Object getService() {
        if (this.m_factory != null) {
            return this.getFactoryUnchecked();
        }
        return this.m_svcObj;
    }

    private void initializeProperties(Dictionary dict) {
        if (this.m_propMap == null) {
            this.m_propMap = new StringMap(false);
        } else {
            this.m_propMap.clear();
        }
        if (dict != null) {
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                this.m_propMap.put(key, dict.get(key));
            }
        }
        this.m_propMap.put("objectClass", this.m_classes);
        this.m_propMap.put("service.id", this.m_serviceId);
    }

    private Object getFactoryUnchecked() {
        return this.m_factory.getService(null, (ServiceRegistration)this);
    }

    private void ungetFactoryUnchecked(ComponentInstance cm, Object svcObj) {
        if (cm instanceof InstanceManager) {
            this.m_factory.ungetService(((InstanceManager)cm).getContext().getBundle(), (ServiceRegistration)this, svcObj);
        }
    }

    public void ungetService(ComponentInstance cm, Object srvObj) {
        if (this.m_factory != null) {
            this.ungetFactoryUnchecked(cm, srvObj);
        }
    }
}

