/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.parser.MethodMetadata;

public class Callback {
    protected Method m_methodObj;
    private String m_method;
    private boolean m_isStatic;
    private InstanceManager m_manager;
    private String[] m_args;

    public Callback(String method, String[] args, boolean isStatic, InstanceManager im) {
        this.m_method = method;
        this.m_isStatic = isStatic;
        this.m_manager = im;
        if (args != null) {
            this.m_args = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                int index;
                int j;
                String arr;
                if (args[i].endsWith("[]") && args[i].indexOf(".") == -1) {
                    arr = "";
                    for (j = 0; j < args[i].length(); ++j) {
                        if (args[i].charAt(j) != '[') continue;
                        arr = arr + '[';
                    }
                    index = args[i].indexOf(91);
                    this.m_args[i] = arr + this.getInternalPrimitiveType(args[i].substring(0, index));
                }
                if (args[i].endsWith("[]") && args[i].indexOf(".") != -1) {
                    arr = "";
                    for (j = 0; j < args[i].length(); ++j) {
                        if (args[i].charAt(j) != '[') continue;
                        arr = arr + '[';
                    }
                    index = args[i].indexOf(91);
                    this.m_args[i] = arr + "L" + args[i].substring(0, index) + ";";
                }
                if (args[i].endsWith("[]")) continue;
                this.m_args[i] = args[i];
            }
        }
    }

    public Callback(String method, Class[] args, boolean isStatic, InstanceManager im) {
        this.m_method = method;
        this.m_isStatic = isStatic;
        this.m_manager = im;
        this.m_args = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.m_args[i] = args[i].getName();
        }
    }

    public Callback(MethodMetadata mm, InstanceManager im) {
        this.m_isStatic = false;
        this.m_method = mm.getMethodName();
        this.m_manager = im;
        String[] args = mm.getMethodArguments();
        this.m_args = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index;
            int j;
            String arr;
            if (args[i].endsWith("[]") && args[i].indexOf(".") == -1) {
                arr = "";
                for (j = 0; j < args[i].length(); ++j) {
                    if (args[i].charAt(j) != '[') continue;
                    arr = arr + '[';
                }
                index = args[i].indexOf(91);
                this.m_args[i] = arr + this.getInternalPrimitiveType(args[i].substring(0, index));
            }
            if (args[i].endsWith("[]") && args[i].indexOf(".") != -1) {
                arr = "";
                for (j = 0; j < args[i].length(); ++j) {
                    if (args[i].charAt(j) != '[') continue;
                    arr = arr + '[';
                }
                index = args[i].indexOf(91);
                this.m_args[i] = arr + "L" + args[i].substring(0, index) + ";";
            }
            if (args[i].endsWith("[]")) continue;
            this.m_args[i] = args[i];
        }
    }

    private String getInternalPrimitiveType(String string) {
        if (string.equalsIgnoreCase("boolean")) {
            return "Z";
        }
        if (string.equalsIgnoreCase("char")) {
            return "C";
        }
        if (string.equalsIgnoreCase("byte")) {
            return "B";
        }
        if (string.equalsIgnoreCase("short")) {
            return "S";
        }
        if (string.equalsIgnoreCase("int")) {
            return "I";
        }
        if (string.equalsIgnoreCase("float")) {
            return "F";
        }
        if (string.equalsIgnoreCase("long")) {
            return "J";
        }
        if (string.equalsIgnoreCase("double")) {
            return "D";
        }
        return null;
    }

    protected void searchMethod() {
        int j;
        boolean ok;
        Class<?>[] clazzes;
        int i;
        Method[] methods = this.m_manager.getClazz().getDeclaredMethods();
        for (i = 0; this.m_methodObj == null && i < methods.length; ++i) {
            if (!methods[i].getName().equals(this.m_method) || (clazzes = methods[i].getParameterTypes()).length != this.m_args.length) continue;
            ok = true;
            for (j = 0; ok && j < this.m_args.length; ++j) {
                if (this.m_args[j].equals(clazzes[j].getName())) continue;
                ok = false;
            }
            if (!ok) continue;
            this.m_methodObj = methods[i];
        }
        if (this.m_methodObj == null) {
            methods = this.m_manager.getClazz().getMethods();
            for (i = 0; this.m_methodObj == null && i < methods.length; ++i) {
                if (!methods[i].getName().equals(this.m_method) || (clazzes = methods[i].getParameterTypes()).length != this.m_args.length) continue;
                ok = true;
                for (j = 0; ok && j < this.m_args.length; ++j) {
                    if (this.m_args[j].equals(clazzes[j].getName())) continue;
                    ok = false;
                }
                if (!ok) continue;
                this.m_methodObj = methods[i];
            }
        }
        if (this.m_methodObj == null) {
            this.m_manager.getFactory().getLogger().log(1, "The method " + this.m_method + " cannot be called : method not found");
            this.m_manager.stop();
        } else {
            this.m_methodObj.setAccessible(true);
        }
    }

    public Object call() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.call(new Object[0]);
    }

    public Object call(Object instance) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.call(instance, new Object[0]);
    }

    public Object call(Object[] arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.m_methodObj == null) {
            this.searchMethod();
        }
        if (this.m_isStatic) {
            return this.m_methodObj.invoke(null, arg);
        }
        if (this.m_manager.getPojoObjects() == null) {
            return this.m_methodObj.invoke(this.m_manager.getPojoObject(), arg);
        }
        Object r = null;
        for (int i = 0; i < this.m_manager.getPojoObjects().length; ++i) {
            r = this.m_methodObj.invoke(this.m_manager.getPojoObjects()[i], arg);
        }
        return r;
    }

    public Object call(Object instance, Object[] arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.m_methodObj == null) {
            this.searchMethod();
        }
        return this.m_methodObj.invoke(instance, arg);
    }

    public String getMethod() {
        return this.m_method;
    }
}

