/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJBObject;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.osgi.ILoadBalancingService;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.cmi.internal.CmiServiceHelper;
import org.ow2.jonas.cmi.internal.CmiServicePolicyStrategyManager;
import org.ow2.jonas.cmi.internal.CmiServiceProperty;
import org.ow2.jonas.cmi.internal.LoadBalancingListener;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmiServiceImpl
extends AbsServiceImpl
implements CmiService,
Pojo {
    private InstanceManager _cm;
    private static Logger cmilogger = Log.getLogger((String)"org.ow2.jonas.cmi");
    private boolean _FjmxService;
    private JmxService jmxService;
    private boolean _Fcontext;
    private final BundleContext context;
    private boolean _FclusterViewManager;
    private ServerClusterViewManager clusterViewManager;
    private boolean _FclusterViewManagerRegistration;
    private ServiceRegistration clusterViewManagerRegistration;
    private boolean _FpolicyStrategyManager;
    private CmiServicePolicyStrategyManager policyStrategyManager;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext;
    private boolean _MdoStart;
    private boolean _MdoStop;
    private boolean _MaddClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean;
    private boolean _MgetJmxService;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;

    private JmxService _getjmxService() {
        if (!this._FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this._cm.getterCallback("jmxService");
    }

    private void _setjmxService(JmxService jmxService) {
        if (!this._FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this._cm.setterCallback("jmxService", (Object)jmxService);
    }

    private BundleContext _getcontext() {
        if (!this._Fcontext) {
            return this.context;
        }
        return (BundleContext)this._cm.getterCallback("context");
    }

    private void _setcontext(BundleContext bundleContext) {
        if (!this._Fcontext) {
            this.context = bundleContext;
            return;
        }
        this._cm.setterCallback("context", (Object)bundleContext);
    }

    private ServerClusterViewManager _getclusterViewManager() {
        if (!this._FclusterViewManager) {
            return this.clusterViewManager;
        }
        return (ServerClusterViewManager)this._cm.getterCallback("clusterViewManager");
    }

    private void _setclusterViewManager(ServerClusterViewManager serverClusterViewManager) {
        if (!this._FclusterViewManager) {
            this.clusterViewManager = serverClusterViewManager;
            return;
        }
        this._cm.setterCallback("clusterViewManager", (Object)serverClusterViewManager);
    }

    private ServiceRegistration _getclusterViewManagerRegistration() {
        if (!this._FclusterViewManagerRegistration) {
            return this.clusterViewManagerRegistration;
        }
        return (ServiceRegistration)this._cm.getterCallback("clusterViewManagerRegistration");
    }

    private void _setclusterViewManagerRegistration(ServiceRegistration serviceRegistration) {
        if (!this._FclusterViewManagerRegistration) {
            this.clusterViewManagerRegistration = serviceRegistration;
            return;
        }
        this._cm.setterCallback("clusterViewManagerRegistration", (Object)serviceRegistration);
    }

    private CmiServicePolicyStrategyManager _getpolicyStrategyManager() {
        if (!this._FpolicyStrategyManager) {
            return this.policyStrategyManager;
        }
        return (CmiServicePolicyStrategyManager)this._cm.getterCallback("policyStrategyManager");
    }

    private void _setpolicyStrategyManager(CmiServicePolicyStrategyManager cmiServicePolicyStrategyManager) {
        if (!this._FpolicyStrategyManager) {
            this.policyStrategyManager = cmiServicePolicyStrategyManager;
            return;
        }
        this._cm.setterCallback("policyStrategyManager", (Object)cmiServicePolicyStrategyManager);
    }

    public CmiServiceImpl(InstanceManager _manager, BundleContext context) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext");
        }
        this._setjmxService(null);
        this._setpolicyStrategyManager(null);
        this._setcontext(context);
        Object var4_3 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext", var4_3);
        }
    }

    protected void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        Properties cmiProperties = null;
        cmiProperties = CmiServiceHelper.buildCmiProperties();
        File deployDirectory = new File(JProp.getJonasBase(), CmiServiceProperty.DEFAULT_DEPLOY_DIRECTORY.getPropertyName());
        try {
            if (deployDirectory.exists()) {
                cmilogger.log(BasicLevel.DEBUG, (Object)("Deploy directory of CMI service is: " + deployDirectory.getAbsolutePath()));
                cmiProperties.put(CmiServiceProperty.DEPLOY_DIRECTORY_KEY.getPropertyName(), deployDirectory.toURL().toString());
            } else {
                cmilogger.log(BasicLevel.DEBUG, (Object)"No deploy directory for CMI service");
            }
            ConfigurationRepository.getServerConfiguration().enableCMI(cmiProperties);
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot configure Carol to use CMI", (Throwable)e);
            ServiceException serviceException = new ServiceException("Cannot configure Carol to use CMI", (Throwable)e);
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        IExecution<Void> startExec = new IExecution<Void>(){

            public Void execute() throws Exception {
                CmiServiceImpl.this.clusterViewManager = AbsServerClusterViewManager.start();
                return null;
            }
        };
        ExecutionResult startExecResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)startExec);
        if (startExecResult.hasException()) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot start the server-side manager", (Throwable)startExecResult.getException());
            ServiceException serviceException = new ServiceException("Cannot start the server-side manager", (Throwable)startExecResult.getException());
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        this._setclusterViewManagerRegistration(this._getcontext().registerService(ServerClusterViewManager.class.getName(), (Object)this._getclusterViewManager(), null));
        this._setpolicyStrategyManager(new CmiServicePolicyStrategyManager(this._getclusterViewManager()));
        LoadBalancingListener listener = new LoadBalancingListener(this._getpolicyStrategyManager());
        cmilogger.log(BasicLevel.DEBUG, (Object)"Adding listener for load balancing service ");
        try {
            this._getcontext().addServiceListener((ServiceListener)listener, "(objectClass=" + ILoadBalancingService.class.getName() + ")");
        }
        catch (InvalidSyntaxException e) {
            cmilogger.log(BasicLevel.ERROR, (Object)("Unable to add service listener for " + ILoadBalancingService.class.getName() + " because: " + (Object)((Object)e)));
        }
        Object var9_10 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var9_10);
        }
    }

    protected void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        if (this._getclusterViewManagerRegistration() != null) {
            this._getclusterViewManagerRegistration().unregister();
        }
        try {
            ConfigurationRepository.getServerConfiguration().disableCMI();
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot disable cmi in Carol", (Throwable)e);
        }
        if (this._getclusterViewManager() != null) {
            try {
                ((AbsServerClusterViewManager)this._getclusterViewManager()).stop();
            }
            catch (Exception e) {
                cmilogger.log(BasicLevel.ERROR, (Object)"Cannot stop the server-side manager", (Throwable)e);
                ServiceException serviceException = new ServiceException("Cannot stop the server-side manager", (Throwable)e);
                if (this._MdoStop) {
                    this._cm.exitCallback("doStop", (Object)serviceException);
                }
                throw serviceException;
            }
        }
        Object var3_4 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addClusteredObject(String string, String string2, Class<?> clazz, Class<? extends EJBObject> clazz2, ClassLoader classLoader, boolean bl, boolean bl2) throws Exception {
        void classLoader2;
        void jndiName;
        void clusterPolicyName;
        if (this._MaddClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean) {
            this._cm.entryCallback("addClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean");
        }
        if (clusterPolicyName == null) {
            cmilogger.log(BasicLevel.DEBUG, (Object)("The object with name " + (String)jndiName + " is not clustered."));
            Object var8_8 = null;
            if (this._MaddClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean) {
                this._cm.exitCallback("addClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean", var8_8);
            }
            return;
        }
        URL url = classLoader2.getResource((String)clusterPolicyName);
        if (url != null) {
            try {
                void clusterReplicated;
                void stateful;
                void remoteClass;
                void homeClass;
                ClusteredObjectInfo clusteredObjectInfo = null;
                clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromDD((String)jndiName, (Class)homeClass, (Class)remoteClass, (URL)url, (boolean)stateful, (boolean)clusterReplicated, null);
                CMIInfoRepository.addClusteredObjectInfo((String)jndiName, (ClusteredObjectInfo)clusteredObjectInfo);
                cmilogger.log(BasicLevel.INFO, (Object)("The object with name " + (String)jndiName + " is clustered."));
            }
            catch (CMIInfoExtractorException e) {
                cmilogger.log(BasicLevel.ERROR, (Object)("Error when extracting infos about clustering for the object with name " + (String)jndiName), (Throwable)e);
                Exception exception = new Exception("Error when extracting infos about clustering for the object with name " + (String)jndiName, e);
                if (this._MaddClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean) {
                    this._cm.exitCallback("addClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean", (Object)exception);
                }
                throw exception;
            }
        } else {
            cmilogger.log(BasicLevel.ERROR, (Object)("Cannot find the policy of load-balancing with name " + (String)clusterPolicyName));
            Exception exception = new Exception("Cannot find the policy of load-balancing with name " + (String)clusterPolicyName);
            if (this._MaddClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean) {
                this._cm.exitCallback("addClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean", (Object)exception);
            }
            throw exception;
        }
        Object var13_14 = null;
        if (this._MaddClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean) {
            this._cm.exitCallback("addClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean", var13_14);
        }
    }

    protected JmxService getJmxService() {
        if (this._MgetJmxService) {
            this._cm.entryCallback("getJmxService");
        }
        JmxService jmxService = this._getjmxService();
        if (this._MgetJmxService) {
            this._cm.exitCallback("getJmxService", (Object)jmxService);
        }
        return jmxService;
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this._setjmxService((JmxService)jmxService2);
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("clusterViewManager")) {
                this._FclusterViewManager = true;
            }
            if (set.contains("clusterViewManagerRegistration")) {
                this._FclusterViewManagerRegistration = true;
            }
            if (set.contains("policyStrategyManager")) {
                this._FpolicyStrategyManager = true;
            }
            if (set.contains("context")) {
                this._Fcontext = true;
            }
            if (set.contains("jmxService")) {
                this._FjmxService = true;
            }
            if (set.contains("cmilogger")) {
                this._Fcmilogger = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext")) {
                this._M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("addClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean")) {
                this._MaddClusteredObjectjava_lang_Stringjava_lang_Stringjava_lang_Classjava_lang_Classjava_lang_ClassLoaderbooleanboolean = true;
            }
            if (set.contains("getJmxService")) {
                this._MgetJmxService = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

