/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.jorm;

import java.util.ArrayList;
import java.util.HashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.eval.api.ConnectionResources;
import org.objectweb.medor.eval.api.QueryEvaluator;
import org.objectweb.medor.eval.lib.BasicEvaluationMetaData;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.eval.prefetch.api.PrefetchBufferFactory;
import org.objectweb.medor.eval.prefetch.lib.PrefetchBufferFactoryImpl;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.lib.Log;
import org.objectweb.medor.optim.api.ExecPlanGenerator;
import org.objectweb.medor.optim.api.QueryTransformer;
import org.objectweb.medor.optim.jorm.Jorm2Rdb;
import org.objectweb.medor.optim.lib.BasicQueryRewriter;
import org.objectweb.medor.optim.lib.FlattenQueryTreeRule;
import org.objectweb.medor.optim.lib.IndexesGenerator;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb2;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.MethodCmp2Desc;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.ejb21.jorm.JormFactory;
import org.ow2.jonas.lib.ejb21.sql.EjbqlLimiterRange;
import org.ow2.jonas.lib.ejb21.sql.EjbqlQueryTreeHolder;

public abstract class MedorFactory
extends JormFactory {
    protected QueryTransformer queryTransformer = null;
    protected Manager miManager = null;
    protected ExecPlanGenerator indexesGenerator;
    protected boolean optimizeAtInit = false;
    private int prefetchIndex;
    private HashMap qthList = new HashMap();

    public MedorFactory() {
        if (Log.loggerFactory != TraceEjb.loggerFactory) {
            Log.loggerFactory = TraceEjb.loggerFactory;
        }
    }

    public EjbqlQueryTreeHolder getQueryTreeHolder(int methodIndex) throws Exception {
        MethodCmp2Desc mcd = (MethodCmp2Desc)this.dd.getMethodDesc(methodIndex);
        EjbqlQueryTreeHolder qth = (EjbqlQueryTreeHolder)this.qthList.get(new Integer(methodIndex));
        if (qth == null) {
            qth = new EjbqlQueryTreeHolder(mcd, mcd.getQueryNode(), this.mapper, this.miManager);
            this.qthList.put(new Integer(methodIndex), qth);
        }
        return qth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleCollection evaluate(Object conn, int methodIndex, ParameterOperand[] parameters) throws MedorException {
        MethodCmp2Desc mcd = (MethodCmp2Desc)this.dd.getMethodDesc(methodIndex);
        EjbqlLimiterRange[] limiterRanges = null;
        QueryEvaluator evaluator = null;
        MedorFactory medorFactory = this;
        synchronized (medorFactory) {
            EjbqlQueryTreeHolder qth;
            try {
                qth = this.getQueryTreeHolder(methodIndex);
            }
            catch (Exception e) {
                throw new MedorException("Cannot build QueryTree:" + e);
            }
            this.setPrefetchIndex(qth.getPrefetchIndex());
            if (qth.getQueryOptimizer() == null) {
                if (this.queryTransformer == null) {
                    ArrayList<Object> rules = new ArrayList<Object>(2);
                    rules.add(new FlattenQueryTreeRule());
                    rules.add(new Jorm2Rdb());
                    this.queryTransformer = new BasicQueryRewriter(rules);
                }
                qth.setQueryOptimizer(new QueryTransformer(){

                    public QueryTree transform(QueryTree qt) throws MedorException {
                        QueryTree qt1 = MedorFactory.this.queryTransformer.transform(qt);
                        if (MedorFactory.this.indexesGenerator == null) {
                            throw new Error("getOptimizedRequest: indexesGenerator == null");
                        }
                        return MedorFactory.this.indexesGenerator.transform(qt1);
                    }
                });
            }
            limiterRanges = qth.getLimiterRanges();
            evaluator = qth.getOptimizedQueryTree();
        }
        ConnectionResources cr = evaluator.getRequiredConnectionResources();
        QueryLeaf[] leaves = cr.getRequiredQueryLeafConnection();
        if (conn == null) {
            throw new MedorException("invalid connection handle [null]");
        }
        for (int i = 0; i < leaves.length; ++i) {
            cr.setConnection(leaves[i], conn);
        }
        PrefetchBuffer prefetchBuffer = null;
        if (mcd.getPrefetch()) {
            Transaction tx = null;
            try {
                tx = this.getTransactionManager().getTransaction();
                if (tx != null) {
                    prefetchBuffer = this.mapper.getPrefetchCache().createPrefetchBuffer((PrefetchBufferFactory)new PrefetchBufferFactoryImpl(), (Object)this, (Object)tx, this.getPrefetchIndex(), true);
                }
            }
            catch (SystemException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"Cannot get the current transaction to create the Prefetch buffer:", (Throwable)e);
            }
        }
        HashMap<QueryLeaf, BasicEvaluationMetaData> evalMDMap = null;
        if (limiterRanges.length > 0) {
            try {
                evalMDMap = new HashMap<QueryLeaf, BasicEvaluationMetaData>();
                BasicEvaluationMetaData evalMD = new BasicEvaluationMetaData();
                EjbqlLimiterRange range = limiterRanges[0];
                if (range.getKind() == 2) {
                    evalMD.setLimitedRangeStartAt(parameters[range.getValue()].getInt());
                } else {
                    evalMD.setLimitedRangeStartAt(range.getValue());
                }
                if (TraceEjb.isDebugQuery()) {
                    TraceEjb.query.log(BasicLevel.LEVEL_DEBUG, (Object)("Query with LIMITer Range Start At = " + evalMD.getLimitedRangeStartAt() + " for method name " + mcd.getMethod().getName()));
                }
                if (limiterRanges.length > 1) {
                    range = limiterRanges[1];
                    if (range.getKind() == 2) {
                        System.out.println("parameters[range.getValue()].getInt() = " + parameters[range.getValue()].getInt());
                        evalMD.setLimitedRangeSize(parameters[range.getValue()].getInt());
                    } else {
                        evalMD.setLimitedRangeSize(range.getValue());
                    }
                    if (TraceEjb.isDebugQuery()) {
                        TraceEjb.query.log(BasicLevel.LEVEL_DEBUG, (Object)("Query with LIMITer Range Size = " + evalMD.getLimitedRangeSize() + " for method name " + mcd.getMethod().getName()));
                    }
                }
                evalMDMap.put(leaves[0], evalMD);
            }
            catch (TypingException te) {
                throw new MedorException("Invalid parameter for a LIMIT range", (Exception)((Object)te));
            }
        }
        return evaluator.evaluate(parameters, cr, prefetchBuffer, evalMDMap);
    }

    public void init(EntityDesc ed, JContainer c, String mapperName) {
        super.init(ed, c, mapperName);
        this.ecd = (EntityCmp2Desc)ed;
        if (TraceEjb.isVerbose()) {
            TraceEjb.logger.log(BasicLevel.DEBUG, (Object)"Jorm Meta information building");
        }
        DeploymentDescEjb2 dd = this.ecd.getDeploymentDescEjb2();
        this.miManager = c.getJormMapping().getJormMIManager();
        if (TraceEjb.isVerbose()) {
            TraceEjb.logger.log(BasicLevel.DEBUG, (Object)"Medor initialisation");
        }
        this.indexesGenerator = new IndexesGenerator();
    }

    private void setPrefetchIndex(int i) {
        this.prefetchIndex = i;
    }

    private int getPrefetchIndex() {
        return this.prefetchIndex;
    }
}

