/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.cluster.jgroups;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManager
implements ChannelListener,
InvocationHandler {
    private static Log logger = LogFactory.getLog(ConnectionManager.class);
    private volatile long timeout;
    private final Object handled;
    private final Class<?> itfHandled;
    private volatile boolean connected = true;

    public ConnectionManager(long timeout, Object handled, Class<?> itfHandled) {
        this.timeout = timeout;
        this.handled = handled;
        this.itfHandled = itfHandled;
    }

    public ConnectionManager(long timeout, Object handled) {
        this.timeout = timeout;
        this.handled = handled;
        this.itfHandled = null;
    }

    public void channelClosed(Channel arg0) {
        this.connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelConnected(Channel arg0) {
        this.connected = true;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.notifyAll();
        }
    }

    public void channelDisconnected(Channel arg0) {
        this.connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelReconnected(Address arg0) {
        this.connected = true;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.notifyAll();
        }
    }

    public void channelShunned() {
    }

    public Object getJgroupsObject() {
        return this.handled;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        if (this.handleThisMethod(method)) {
            long startTime = System.currentTimeMillis();
            while (!this.connected && System.currentTimeMillis() - startTime < this.timeout) {
                ConnectionManager connectionManager = this;
                synchronized (connectionManager) {
                    this.wait(this.timeout);
                }
            }
            if (this.connected) {
                return method.invoke(this.handled, args);
            }
            throw new Exception(this.timeout + " ms reconnection timeout exceeded, unable to invoke " + method.getName() + " with args " + args + "\n");
        }
        try {
            ret = method.invoke(this.handled, args);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"Cannot invoke the method {0}", new Object[]{method.getName(), e});
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Cannot invoke the method {0}", new Object[]{method.getName(), e});
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"Cannot invoke the method {0}", new Object[]{method.getName(), e});
        }
        return ret;
    }

    private boolean handleThisMethod(Method method) {
        if (this.itfHandled == null) {
            return method.getDeclaringClass() != Object.class;
        }
        Method[] handledMethods = this.itfHandled.getDeclaredMethods();
        for (int i = 0; i < handledMethods.length; ++i) {
            if (!method.getName().equals(handledMethods[i].getName()) || method.getParameterTypes().length != handledMethods[i].getParameterTypes().length) continue;
            return true;
        }
        return false;
    }
}

